/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.ability;

import java.util.List;
import me.pajic.rearm.ReArm;
import me.pajic.rearm.enchantment.ReArmEnchantments;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.NotNull;

public class BashAbility {
    public static final ResourceLocation BASH_SIGNAL = ReArm.id("bash_signal");

    public static void handleBash(C2SBashSignal signal, ServerPlayer player) {
        ServerLevel level = player.level();
        int bashLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ReArmEnchantments.BASH), (ItemStack)player.getUseItem());
        if (bashLevel > 0 && player.isBlocking()) {
            double bashRange = (Double)ReArm.CONFIG.shield.bashBaseRange.get() + (double)bashLevel * (Double)ReArm.CONFIG.shield.bashRangePerLevel.get();
            List<LivingEntity> targets = level.getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(bashRange, 1.0, bashRange)).stream().filter(livingEntity -> livingEntity != player).toList();
            if (!targets.isEmpty()) {
                targets.forEach(entity -> {
                    entity.knockback((Double)ReArm.CONFIG.shield.bashBaseKnockback.get() + (double)bashLevel * (Double)ReArm.CONFIG.shield.bashKnockbackPerLevel.get(), (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                    entity.hurt(level.damageSources().playerAttack((Player)player), ((Float)ReArm.CONFIG.shield.bashBaseDamage.get()).floatValue() + 2.0f * ((Float)ReArm.CONFIG.shield.bashDamagePerLevel.get()).floatValue());
                    level.sendParticles((ParticleOptions)ParticleTypes.CRIT, entity.getX(), entity.getY() + 0.5, entity.getZ(), 8, 0.3, 0.3, 0.3, 0.2);
                });
                level.playSound(null, player.getOnPos(), (SoundEvent)SoundEvents.SHIELD_BLOCK.value(), SoundSource.PLAYERS, 1.0f, 0.2f + level.random.nextFloat() * 0.3f);
                level.registryAccess().lookupOrThrow(Registries.ITEM).getTagOrEmpty(ReArm.SHIELDS).forEach(item -> player.getCooldowns().addCooldown(level.registryAccess().lookupOrThrow(Registries.ITEM).getKey((Object)((Item)item.value())), (Integer)ReArm.CONFIG.shield.bashShieldCooldown.get() * 20));
                player.getUseItem().hurtAndBreak(targets.size(), (LivingEntity)player, player.getMainHandItem().is(player.getUseItem().getItem()) ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                player.stopUsingItem();
            }
        }
    }

    public record C2SBashSignal() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<C2SBashSignal> TYPE = new CustomPacketPayload.Type(BASH_SIGNAL);
        public static final StreamCodec<RegistryFriendlyByteBuf, C2SBashSignal> CODEC = StreamCodec.unit((Object)new C2SBashSignal());

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

