/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.ability;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.UUID;
import me.pajic.rearm.ReArm;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CriticalCounterAbility {
    public static final ResourceLocation COUNTER_START_TIMER = ReArm.id("counter_start_timer");
    public static final ResourceLocation UPDATE_PLAYER_COUNTER_CONDITION = ReArm.id("update_player_counter_condition");
    private static final Object2BooleanOpenHashMap<UUID> playerCounterConditions = new Object2BooleanOpenHashMap();

    public static void setPlayerCounterCondition(UUID playerUUID, boolean shouldCounter) {
        if (playerCounterConditions.containsKey((Object)playerUUID)) {
            playerCounterConditions.replace((Object)playerUUID, shouldCounter);
        } else {
            playerCounterConditions.put((Object)playerUUID, shouldCounter);
        }
    }

    public static boolean getPlayerCounterCondition(UUID playerUUID) {
        if (playerCounterConditions.containsKey((Object)playerUUID)) {
            return playerCounterConditions.getBoolean((Object)playerUUID);
        }
        return false;
    }

    public static void removePlayerCounterConditionData(UUID playerUUID) {
        playerCounterConditions.removeBoolean((Object)playerUUID);
    }

    public static boolean canCounter(ItemStack stack) {
        return (Boolean)ReArm.CONFIG.sword.enableCriticalCounter.get() != false && stack.is(ItemTags.SWORDS) || (Boolean)ReArm.CONFIG.axe.enableCriticalCounter.get() != false && stack.is(ItemTags.AXES);
    }

    public static boolean canVanillaCrit(ItemStack stack) {
        return (Boolean)ReArm.CONFIG.sword.disableVanillaCrits.get() == false && stack.is(ItemTags.SWORDS) || (Boolean)ReArm.CONFIG.axe.disableVanillaCrits.get() == false && stack.is(ItemTags.AXES);
    }

    public record S2CStartCriticalCounterTimer() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<S2CStartCriticalCounterTimer> TYPE = new CustomPacketPayload.Type(COUNTER_START_TIMER);
        public static final StreamCodec<RegistryFriendlyByteBuf, S2CStartCriticalCounterTimer> CODEC = StreamCodec.unit((Object)new S2CStartCriticalCounterTimer());

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record C2SUpdatePlayerCounterCondition(UUID activePlayerUUID, boolean shouldCounter) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<C2SUpdatePlayerCounterCondition> TYPE = new CustomPacketPayload.Type(UPDATE_PLAYER_COUNTER_CONDITION);
        public static final StreamCodec<RegistryFriendlyByteBuf, C2SUpdatePlayerCounterCondition> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, C2SUpdatePlayerCounterCondition::activePlayerUUID, (StreamCodec)ByteBufCodecs.BOOL, C2SUpdatePlayerCounterCondition::shouldCounter, C2SUpdatePlayerCounterCondition::new);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

