/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.injector.ModifyReceiver;
import java.util.Map;
import java.util.function.BiConsumer;
import me.pajic.rearm.ReArm;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.Equippable;
import org.apache.commons.lang3.function.TriConsumer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    public abstract ItemEnchantments getEnchantments();

    @ModifyReceiver(method={"forEachModifier(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/ItemAttributeModifiers;forEach(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V")})
    private ItemAttributeModifiers addToughness(ItemAttributeModifiers instance, EquipmentSlot equipmentSlot, BiConsumer<Holder<Attribute>, AttributeModifier> action) {
        return this.rearm$addToughness(instance);
    }

    @ModifyReceiver(method={"forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Lorg/apache/commons/lang3/function/TriConsumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/ItemAttributeModifiers;forEach(Lnet/minecraft/world/entity/EquipmentSlotGroup;Lorg/apache/commons/lang3/function/TriConsumer;)V")})
    private ItemAttributeModifiers addToughness(ItemAttributeModifiers instance, EquipmentSlotGroup slotGroup, TriConsumer action) {
        return this.rearm$addToughness(instance);
    }

    @Unique
    private ItemAttributeModifiers rearm$addToughness(ItemAttributeModifiers instance) {
        ItemStack self;
        if (ReArm.armorRebalanceActive() && ((Boolean)ReArm.CONFIG.armor.enchantmentBasedToughness.get()).booleanValue() && (self = (ItemStack)this).has(DataComponents.EQUIPPABLE)) {
            Equippable equippable = (Equippable)self.get(DataComponents.EQUIPPABLE);
            double toughness = 0.0;
            for (Holder holder : this.getEnchantments().keySet()) {
                String enchantment = holder.getRegisteredName().split(":")[1];
                if (!((Map)ReArm.CONFIG.armor.toughnessPerEnchantment.get()).containsKey(enchantment)) continue;
                int level = EnchantmentHelper.getItemEnchantmentLevel((Holder)holder, (ItemStack)self);
                toughness += (double)(((Float)((Map)ReArm.CONFIG.armor.toughnessPerEnchantment.get()).get(enchantment)).floatValue() * (float)level);
            }
            String type = switch (equippable.slot()) {
                case EquipmentSlot.HEAD -> "helmet";
                case EquipmentSlot.CHEST -> "chestplate";
                case EquipmentSlot.LEGS -> "leggings";
                case EquipmentSlot.FEET -> "boots";
                default -> "body";
            };
            return instance.withModifierAdded(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("armor." + type)), toughness, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)equippable.slot()));
        }
        return instance;
    }
}

