package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import me.pajic.rearm.ReArm;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
//? if 1.21.1 {
import me.pajic.rearm.item.ReArmItems;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_3966;

@Mixin(class_1665.class)
public abstract class AbstractArrowMixin extends class_1676 {

    public AbstractArrowMixin(class_1299<? extends class_1676> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow public abstract boolean isCritArrow();
    @Shadow public abstract class_1799 method_59958();
    //? if 1.21.1 {
    @Shadow public abstract boolean shotFromCrossbow();

    @ModifyExpressionValue(
            method = "shotFromCrossbow",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/world/item/Item;)Z"
            )
    )
    private boolean considerModCrossbows(boolean original) {
        return ReArmItems.isCrossbow(method_59958());
    }
    //?} else {
    /*@Shadow private @Nullable ItemStack firedFromWeapon;
    @Unique private boolean shotFromCrossbow() {
        return firedFromWeapon != null && firedFromWeapon.getItem() instanceof CrossbowItem;
    }
    *///?}

    @ModifyExpressionValue(
            method = "onHitEntity",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/phys/Vec3;length()D"
            )
    )
    private double modifyVelocity(double original) {
        if (ReArm.CONFIG.bow.enablePerfectShot.get() && !shotFromCrossbow() && original > 3.0 && original < 3.5) {
            return 3.0;
        }
        if (ReArm.CONFIG.crossbow.fixedArrowDamage.get() && shotFromCrossbow()) {
            return ReArm.CONFIG.crossbow.fixedArrowDamageAmount.get() / 2.0;
        }
        return original;
    }

    @ModifyExpressionValue(
            method = "onHitEntity",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/projectile/AbstractArrow;isCritArrow()Z"
            )
    )
    private boolean modifyCrit(
            boolean original,
            @Local LocalIntRef i,
            @Local(ordinal = 0) class_1297 entity,
            @Local class_1282 damageSource
    ) {
        if (ReArm.CONFIG.bow.enablePerfectShot.get() && isCritArrow() && !shotFromCrossbow()) {
            if (method_59958() != null) {
                float bonusDamage = class_1890.method_60120(
                        (class_3218) method_37908(),
                        method_59958(),
                        entity,
                        damageSource,
                        ReArm.CONFIG.bow.perfectShotAdditionalDamage.get()
                );
                i.set((int) (i.get() + bonusDamage));
            }
            return false;
        }
        if (ReArm.CONFIG.crossbow.fixedArrowDamage.get() && shotFromCrossbow()) {
            return false;
        }
        return original;
    }

    @ModifyExpressionValue(
            method = "onHitEntity",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/projectile/AbstractArrow;getPierceLevel()B",
                    ordinal = 3
            )
    )
    private byte stopPiercingArrowOnArmoredEntity(byte original, @Local(argsOnly = true) class_3966 result) {
        if (ReArm.CONFIG.crossbow.stopPiercingOnArmoredEntity.get() && original > 0 && result.method_17782() instanceof class_1309 entity) {
            //? if 1.21.1 {
            for (class_1799 stack : entity.method_5661()) {
                if (
                        stack.method_31573(class_3489.field_48297) ||
                        stack.method_31573(class_3489.field_48296) ||
                        stack.method_31573(class_3489.field_48295) ||
                        stack.method_31573(class_3489.field_48294)
                ) {
                    return 0;
                }
            }
            //?} else {
            /*if (
                    !entity.equipment.get(EquipmentSlot.HEAD).isEmpty() ||
                    !entity.equipment.get(EquipmentSlot.CHEST).isEmpty() ||
                    !entity.equipment.get(EquipmentSlot.LEGS).isEmpty() ||
                    !entity.equipment.get(EquipmentSlot.FEET).isEmpty()
            ) {
                return 0;
            }
            *///?}
        }
        return original;
    }
}
