package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import me.pajic.rearm.ReArm;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1753.class)
public abstract class BowItemMixin extends class_1811 {

    public BowItemMixin(class_1793 properties) {
        super(properties);
    }

    @ModifyArg(
            method = "releaseUsing",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/BowItem;shoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;Ljava/util/List;FFZLnet/minecraft/world/entity/LivingEntity;)V"
            ),
            index = 7
    )
    private boolean modifyIsCrit(
            boolean isCrit,
            @Share("isCrit") LocalBooleanRef isPerfectShot,
            @Local(ordinal = 1) int i
    ) {
        if (ReArm.CONFIG.bow.enablePerfectShot.get()) {
            if (i >= 20 && i <= 20 + ReArm.CONFIG.bow.perfectShotTimeframe.get() * 20) {
                isPerfectShot.set(true);
                return true;
            }
            return false;
        }
        return isCrit;
    }

    @ModifyArg(
            method = "releaseUsing",
            at = @At(
                    value = "INVOKE",
                    //? if 1.21.1
                    target = "Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V"
                    //? if > 1.21.1
                    /*target = "Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/Entity;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V"*/
            ),
            index = 7
    )
    private float increasePitchIfPerfectShot(float pitch, @Share("isCrit") LocalBooleanRef isPerfectShot) {
        if (isPerfectShot.get()) {
            return pitch * 1.4F;
        }
        return pitch;
    }

    @Inject(
            method = "use",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Player;startUsingItem(Lnet/minecraft/world/InteractionHand;)V"
            )
    )
    private void playPlayerBowDrawingSound(class_1937 level, class_1657 player, class_1268 interactionHand,
                                           //? if 1.21.1
                                           CallbackInfoReturnable<class_1271<class_1799>> cir
                                           //? if > 1.21.1
                                           /*CallbackInfoReturnable<InteractionResult> cir*/
    ) {
        if (ReArm.CONFIG.bow.playerDrawingSounds.get() && !player.method_18808(player.method_5998(interactionHand)).method_7960()) {
            level.method_60511(
                    null, player.method_23317(), player.method_23318(), player.method_23321(),
                    class_3417.field_15011,
                    class_3419.field_15248, 0.65F, 1.0F
            );
        }
    }
}
