package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import me.pajic.rearm.CompatFlags;
import me.pajic.rearm.ReArm;
import me.pajic.rearm.ability.CripplingThrowAbility;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3489;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_1792.class)
public abstract class ItemMixin {

    @Shadow public abstract int getUseDuration(class_1799 stack, class_1309 entity);

    @WrapMethod(method = "getUseDuration")
    private int axe_useDuration(class_1799 stack, class_1309 entity, Operation<Integer> original) {
        if (ReArm.CONFIG.axe.cripplingThrow.get() && stack.method_31573(class_3489.field_42612)) {
            return 72000;
        }
        return original.call(stack, entity);
    }

    @WrapMethod(method = "getUseAnimation")
    private /*? if 1.21.1 {*/class_1839/*?} else {*//*ItemUseAnimation*//*?}*/ axe_useAnimaton(
            class_1799 stack,
            Operation</*? if 1.21.1 {*/class_1839/*?} else {*//*ItemUseAnimation*//*?}*/> original
    ) {
        if (ReArm.CONFIG.axe.cripplingThrow.get() && stack.method_31573(class_3489.field_42612)) {
            if (CompatFlags.HMI_LOADED) return /*? if 1.21.1 {*/class_1839/*?} else {*//*ItemUseAnimation*//*?}*/.field_8952;
            return /*? if 1.21.1 {*/class_1839/*?} else {*//*ItemUseAnimation*//*?}*/.field_8951;
        }
        return original.call(stack);
    }

    @WrapMethod(method = "use")
    private /*? if 1.21.1 {*/class_1271<class_1799>/*?} else {*//*InteractionResult*//*?}*/ axe_use(
            class_1937 level, class_1657 player, class_1268 usedHand,
            Operation</*? if 1.21.1 {*/class_1271<class_1799>/*?} else {*//*InteractionResult*//*?}*/> original) {
        if (ReArm.CONFIG.axe.cripplingThrow.get()) {
            class_1799 stack = player.method_5998(usedHand);
            if (stack.method_31573(class_3489.field_42612)) {
                return CripplingThrowAbility.useAxe(level, player, usedHand, stack);
            }
        }
        return original.call(level, player, usedHand);
    }

    @WrapMethod(method = "releaseUsing")
    private /*? if 1.21.1 {*/void/*?} else {*//*boolean*//*?}*/ axe_releaseUsing(
            class_1799 stack, class_1937 level, class_1309 livingEntity, int timeCharged,
            Operation</*? if 1.21.1 {*/Void/*?} else {*//*Boolean*//*?}*/> original
    ) {
        if (ReArm.CONFIG.axe.cripplingThrow.get() && stack.method_31573(class_3489.field_42612)) {
            CripplingThrowAbility.throwAxe(stack, level, livingEntity, timeCharged, getUseDuration(stack, livingEntity));
        }
        //? if 1.21.1 {
        else {
            original.call(stack, level, livingEntity, timeCharged);
        }
        //?} else {
        /*return original.call(stack, level, livingEntity, timeCharged);
        *///?}
    }
}
