package me.pajic.rearm.mixin.compat.ia;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.moulberry.mixinconstraints.annotations.IfModLoaded;
import immersive_armors.Items;
import immersive_armors.item.ExtendedArmorMaterial;
import me.pajic.rearm.ReArm;
import me.pajic.rearm.util.ArmorMaterialHelper;
import net.minecraft.class_1738;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import java.util.Map;

@IfModLoaded("immersive_armors")
@Mixin(Items.class)
public interface ItemsMixin {

    @ModifyExpressionValue(
            method = "<clinit>",
            at = @At(
                    value = "INVOKE",
                    target = "Limmersive_armors/item/ExtendedArmorMaterial;equipSound(Lnet/minecraft/sounds/SoundEvent;)Limmersive_armors/item/ExtendedArmorMaterial;"
            )
    )
    private static ExtendedArmorMaterial modifyMaterial1(ExtendedArmorMaterial original) {
        return rearm$modifyMaterial(original);
    }

    @ModifyExpressionValue(
            method = "<clinit>",
            at = @At(
                    value = "INVOKE",
                    target = "Limmersive_armors/item/ExtendedArmorMaterial;equipSound(Lnet/minecraft/core/Holder;)Limmersive_armors/item/ExtendedArmorMaterial;"
            )
    )
    private static ExtendedArmorMaterial modifyMaterial2(ExtendedArmorMaterial original) {
        return rearm$modifyMaterial(original);
    }

    @Unique
    private static ExtendedArmorMaterial rearm$modifyMaterial(ExtendedArmorMaterial original) {
        //? if 1.21.1 {
        class_2960 rl = class_2960.method_60655("immersive_armors", original.getName());
        ArmorMaterialHelper.add(rl);
        if (ReArm.CONFIG.armor.armorRebalance.get()) {
            int targetTotal = 0;
            if (ReArm.CONFIG.armor.totalArmorOverrides.get().containsKey(rl)) {
                targetTotal = ReArm.CONFIG.armor.totalArmorOverrides.get().get(rl);
            } else {
                for (Map.Entry</*? if 1.21.1 {*/class_1738.class_8051/*?} else {*//*ArmorType*//*?}*/, Integer> entry : original.getProtection().entrySet()) {
                    if (entry.getKey() != /*? if 1.21.1 {*/class_1738.class_8051/*?} else {*//*ArmorType*//*?}*/.field_48838)
                        targetTotal += (int) (entry.getValue() * ReArm.CONFIG.armor.armorMultiplier.get());
                }
            }
            if (targetTotal > 0) {
                Map</*? if 1.21.1 {*/class_1738.class_8051/*?} else {*//*ArmorType*//*?}*/, Integer> map = ArmorMaterialHelper.calculateDefenses(targetTotal);
                original.protectionAmount(
                        map.get(/*? if 1.21.1 {*/class_1738.class_8051/*?} else {*//*ArmorType*//*?}*/.field_41934),
                        map.get(/*? if 1.21.1 {*/class_1738.class_8051/*?} else {*//*ArmorType*//*?}*/.field_41935),
                        map.get(/*? if 1.21.1 {*/class_1738.class_8051/*?} else {*//*ArmorType*//*?}*/.field_41936),
                        map.get(/*? if 1.21.1 {*/class_1738.class_8051/*?} else {*//*ArmorType*//*?}*/.field_41937)
                );
            }
            if (ReArm.CONFIG.armor.enchantmentBasedToughness.get()) original.toughness(0);
            if (ReArm.CONFIG.armor.defenseBasedKnockbackResist.get()) {
                original.knockbackReduction(ArmorMaterialHelper.calculateKnockbackResist(targetTotal));
            }
        }
        //?}
        return original;
    }
}
