package me.pajic.rearm.projectile;

import me.pajic.rearm.ReArm;
import me.pajic.rearm.ability.CripplingThrowAbility;
import me.pajic.rearm.effect.ReArmEffects;
import me.pajic.rearm.enchantment.ReArmEnchantments;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import java.util.UUID;

public class ThrownAxe extends class_1665 {
    private boolean dealtDamage;
    private boolean failedPickup;
    private class_1309 stuckEntity;
    private UUID stuckEntityId;
    private float damage;
    private class_1268 hand;
    private int timeInTarget;
    public static final class_2940<Boolean> STUCK = class_2945.method_12791(ThrownAxe.class, class_2943.field_13323);
    public static final class_2940<Boolean> ALLOW_PICKUP = class_2945.method_12791(ThrownAxe.class, class_2943.field_13323);
    public static final class_2940<class_1799> THROWN_AXE_ITEM_STACK = class_2945.method_12791(ThrownAxe.class, class_2943.field_13322);

    public ThrownAxe(class_1299<? extends class_1665> entityType, class_1937 level) {
        super(entityType, level);
    }

    public ThrownAxe(class_1937 level, class_1309 shooter, class_1799 axe, float damage, class_1268 hand) {
        super(CripplingThrowAbility.AXE, shooter, level, axe, axe);
        field_6011.method_12778(STUCK, false);
        field_6011.method_12778(ALLOW_PICKUP, false);
        field_6011.method_12778(THROWN_AXE_ITEM_STACK, axe);
        CripplingThrowAbility.recallSignals.remove(shooter.method_5667());
        this.damage = damage;
        this.hand = hand;
    }

    @SuppressWarnings("resource")
    @Override
    public void method_5773() {
        if (stuckEntity == null && method_37908() instanceof class_3218 sl && stuckEntityId != null && !stuckEntityId.equals(new UUID(0, 0))) {
            stuckEntity = (class_1309) sl.method_14190(stuckEntityId);
            method_5875(true);
            field_6011.method_12778(STUCK, true);
        }
        if (field_7576 > 4) dealtDamage = true;
        if (/*? if 1.21.1 {*/field_7588/*?} else {*//*isInGround()*//*?}*/) {
            field_6011.method_12778(STUCK, true);
            field_6011.method_12778(ALLOW_PICKUP, true);
        }

        class_1297 entity = method_24921();
        if (entity != null) {
            if (((dealtDamage || method_7441()) && (CripplingThrowAbility.recallSignals.contains(entity.method_5667())) || method_23318() < -65) && !failedPickup) {
                if (stuckEntity != null && !stuckEntity.method_5864().method_20210(class_3483.field_15507)) {
                    stuckEntity.method_37222(
                            new class_1293(
                                    ReArmEffects.BLEEDING,
                                    ReArm.CONFIG.axe.cripplingThrowBleedingDuration.get(),
                                    getCripplingThrowLevel()
                            ), entity
                    );
                    method_5783(class_3417.field_14994, 1.0F, 1.0F);
                }
                if (!isAcceptableReturnOwner()) {
                    if (!method_37908().method_8608() && field_7572 == class_1666.field_7593) {
                        method_5699(/*? if > 1.21.1 {*//*(ServerLevel) level(),*//*?}*/ method_7445(), 0.1F);
                    }
                    method_31472();
                } else {
                    method_7433(true);
                    field_6011.method_12778(ALLOW_PICKUP, true);
                    class_243 vec3 = entity.method_33571().method_1020(method_19538());
                    method_23327(method_23317(), method_23318() + vec3.field_1351 * 0.045, method_23321());
                    if (method_37908().method_8608()) {
                        field_5971 = method_23318();
                    }
                    method_18799(method_18798().method_1021(0.95).method_1019(vec3.method_1029().method_1021(0.15)));
                }
                stuckEntity = null;
                stuckEntityId = null;
                method_5875(false);
                field_6011.method_12778(STUCK, false);
                timeInTarget = 0;
            }
        }

        if (stuckEntity != null) {
            method_5814(stuckEntity.method_23317(), stuckEntity.method_23318() + stuckEntity.method_17682() / 2, stuckEntity.method_23321());
            stuckEntity.method_37222(
                    new class_1293(
                            class_1294./*? if > 1.21.1 {*//*SLOWNESS*//*?} else {*/field_5909/*?}*/,
                            20,
							ReArm.CONFIG.axe.cripplingThrowBaseSlownessAmplifier.get() +
                                    (getCripplingThrowLevel() - 1) * ReArm.CONFIG.axe.cripplingThrowSlownessAmplifierIncreasePerLevel.get()
                    ), entity
            );
            timeInTarget++;
            if (!stuckEntity.method_5805() || timeInTarget > ReArm.CONFIG.axe.maxTimeStuckInTarget.get()) {
                stuckEntity = null;
                stuckEntityId = null;
                method_5875(false);
                field_6011.method_12778(STUCK, false);
                timeInTarget = 0;
            }
        }

        super.method_5773();
    }

    private boolean isAcceptableReturnOwner() {
        class_1297 entity = method_24921();
        return entity != null && entity.method_5805() && (!(entity instanceof class_3222) || !entity.method_7325());
    }

    @SuppressWarnings({"resource"/*? if > 1.21.1 {*//*, "deprecation"*//*?}*/})
    @Override
    protected void method_7454(@NotNull class_3966 result) {
        class_1297 entity = result.method_17782();
        class_1297 entity2 = method_24921();
        class_1282 damageSource = method_48923().method_48811(this, entity2 == null ? this : entity2);
        float f = damage;
        float g = 0;
        if (method_37908() instanceof class_3218 serverLevel) {
            g = class_1890.method_60120(serverLevel, method_59958(), entity, damageSource, f) - f;
        }

        dealtDamage = true;
        //? if 1.21.1
        if (entity.method_5643(damageSource, f + g)) {
        //? if > 1.21.1
        /*if (entity.hurtOrSimulate(damageSource, f + g)) {*/
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }
            if (method_37908() instanceof class_3218 serverLevel) {
                class_1890.method_60619(serverLevel, entity, damageSource, method_59958());
            }
            if (entity instanceof class_1309 livingEntity) {
                method_59957(livingEntity, damageSource);
                method_7450(livingEntity);
                stuckEntity = livingEntity;
                stuckEntityId = livingEntity.method_5667();
                method_5875(true);
                field_6011.method_12778(STUCK, true);
            }
        }

        method_18799(method_18798().method_18805(0.01, 0.1, 0.01));
        method_5783(class_3417.field_15213, 1.0F, 1.0F);
    }

    private int getCripplingThrowLevel() {
        return class_1890.method_8225(
                //? if 1.21.1
                method_56673().method_30530(class_7924.field_41265).method_40290(ReArmEnchantments.CRIPPLING_THROW),
                //? if > 1.21.1
                /*registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ReArmEnchantments.CRIPPLING_THROW),*/
                field_6011.method_12789(THROWN_AXE_ITEM_STACK)
        );
    }

    @Override
    protected void method_59956(@NotNull class_3218 level, class_3965 hitResult, @NotNull class_1799 stack) {
        class_243 vec3 = hitResult.method_17777().method_60913(hitResult.method_17784());
        class_1890.method_60124(
                level,
                stack,
                method_24921() instanceof class_1309 livingEntity ? livingEntity : null,
                this,
                null,
                vec3,
                level.method_8320(hitResult.method_17777()),
                item -> method_5768(/*? if > 1.21.1 {*//*level*//*?}*/)
        );
    }

    @Override
    protected @NotNull class_1799 method_57314() {
        return class_1799.field_8037;
    }

    @Override
    protected void method_5693(@NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(STUCK, false);
        builder.method_56912(ALLOW_PICKUP, false);
        builder.method_56912(THROWN_AXE_ITEM_STACK, class_1799.field_8037);
    }

    @Override
    protected class_3966 method_7434(@NotNull class_243 startVec, @NotNull class_243 endVec) {
        return dealtDamage ? null : super.method_7434(startVec, endVec);
    }

    @Override
    public @NotNull class_1799 method_59958() {
        return method_54759();
    }

    @Override
    protected boolean method_34713(@NotNull class_1657 player) {
        boolean result = switch (field_7572) {
            case field_7592 -> false;
            case field_7593 -> field_6011.method_12789(ALLOW_PICKUP) && method_34714(player);
            case field_7594 -> player.method_56992();
        };
        if (result) {
            if (hand != null && player.method_5998(hand).method_7960()) {
                player.method_6122(hand, method_7445());
            } else {
                boolean added = player.method_31548().method_7394(method_7445());
                if (!added) {
                    failedPickup = true;
                    stuckEntity = null;
                    method_5875(false);
                    method_7433(false);
                    field_6011.method_12778(STUCK, false);
                    timeInTarget = 0;
                    return false;
                }
            }
            CripplingThrowAbility.recallSignals.remove(player.method_5667());
        }
        return result;
    }

    @Override
    protected @NotNull class_3414 method_7440() {
        return class_3417.field_15104;
    }

    @SuppressWarnings("resource")
    @Override
    public void method_5694(@NotNull class_1657 player) {
        if (method_34714(player) || method_24921() == null && !method_37908().method_8608() && (/*? if 1.21.1 {*/field_7588/*?} else {*//*isInGround()*//*?}*/ || method_7441()) && field_7574 <= 0) {
            if (method_34713(player)) {
                player.method_6103(this, 1);
                method_31472();
            }
        }
    }

    //? if 1.21.1 {
    @Override
    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        dealtDamage = compound.method_10577("DealtDamage");
        failedPickup = compound.method_10577("FailedPickup");
        stuckEntityId = compound.method_25926("StuckEntityId");
        timeInTarget = compound.method_10550("TimeInTarget");
        hand = compound.method_10577("Hand") ? class_1268.field_5808 : class_1268.field_5810;
        field_6011.method_12778(STUCK, compound.method_10577("Stuck"));
        field_6011.method_12778(ALLOW_PICKUP, compound.method_10577("AllowPickup"));
        if (compound.method_10545("ThrownAxeItemStack")) {
            field_6011.method_12778(THROWN_AXE_ITEM_STACK, class_1799.method_57359(method_56673(), compound.method_10562("ThrownAxeItemStack")));
        }
    }

    @Override
    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("DealtDamage", dealtDamage);
        compound.method_10556("FailedPickup", failedPickup);
        compound.method_25927("StuckEntityId", stuckEntity == null ? new UUID(0, 0) : stuckEntity.method_5667());
        compound.method_10569("TimeInTarget", timeInTarget);
        compound.method_10556("Hand", hand == class_1268.field_5808);
        compound.method_10556("Stuck", field_6011.method_12789(STUCK));
        compound.method_10556("AllowPickup", field_6011.method_12789(ALLOW_PICKUP));
        if (!field_6011.method_12789(THROWN_AXE_ITEM_STACK).method_7960()) {
            compound.method_10566("ThrownAxeItemStack", field_6011.method_12789(THROWN_AXE_ITEM_STACK).method_57358(method_56673()));
        }
    }
    //?} else {
    /*@Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        dealtDamage = valueInput.getBooleanOr("DealtDamage", false);
        failedPickup = valueInput.getBooleanOr("FailedPickup", false);
        stuckEntityId = valueInput.read("StuckEntityId", UUIDUtil.CODEC).orElse(null);
        timeInTarget = valueInput.getIntOr("TimeInTarget", 0);
        hand = valueInput.getBooleanOr("Hand", true) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        entityData.set(STUCK, valueInput.getBooleanOr("Stuck", false));
        entityData.set(ALLOW_PICKUP, valueInput.getBooleanOr("AllowPickup", true));
        entityData.set(THROWN_AXE_ITEM_STACK, valueInput.read("ThrownAxeItemStack", ItemStack.CODEC).orElse(ItemStack.EMPTY));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean("DealtDamage", dealtDamage);
        valueOutput.putBoolean("FailedPickup", failedPickup);
        if (stuckEntityId != null) {
            valueOutput.store("StuckEntityId", UUIDUtil.CODEC, stuckEntityId);
        }
        valueOutput.putInt("TimeInTarget", timeInTarget);
        valueOutput.putBoolean("Hand", hand == InteractionHand.MAIN_HAND);
        valueOutput.putBoolean("Stuck", entityData.get(STUCK));
        valueOutput.putBoolean("AllowPickup", entityData.get(ALLOW_PICKUP));
        if (!entityData.get(THROWN_AXE_ITEM_STACK).isEmpty()) {
            valueOutput.store("ThrownAxeItemStack", ItemStack.CODEC, entityData.get(THROWN_AXE_ITEM_STACK));
        }
    }
    *///?}

    public void method_7446() {
        if (field_7572 != class_1666.field_7593) {
            super.method_7446();
        }
    }

    @Override
    protected float method_7436() {
        return 0.8F;
    }

    @Override
    public boolean method_5727(double x, double y, double z) {
        return true;
    }
}
