/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.platform.fabric;

import me.pajic.rearm.ReArm;
import me.pajic.rearm.ability.BackstepAbility;
import me.pajic.rearm.ability.BashAbility;
import me.pajic.rearm.ability.CripplingThrowAbility;
import me.pajic.rearm.ability.CriticalCounterAbility;
import me.pajic.rearm.effect.ReArmEffects;
import me.pajic.rearm.item.ReArmItems;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class FabricEntrypoint
implements ModInitializer {
    public void onInitialize() {
        ReArm.onInitialize();
        ReArmItems.init();
        ReArmEffects.init();
        this.initCommonResources();
        FabricEntrypoint.initItems();
        this.initBackstep();
        FabricEntrypoint.initBash();
        FabricEntrypoint.initCripplingThrow();
        FabricEntrypoint.initCriticalCounter();
        FabricEntrypoint.enchantableShield();
    }

    private void initCommonResources() {
        FabricLoader.getInstance().getModContainer("rearm").ifPresent(modContainer -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ReArm.id(ReArm.PACK_VERSION + "/dp"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            if (((Boolean)ReArm.CONFIG.bow.enableBackstep.get()).booleanValue()) {
                ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ReArm.id("backstep"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            }
            if (((Boolean)ReArm.CONFIG.axe.cripplingThrow.get()).booleanValue()) {
                ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ReArm.id("crippling_throw"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            }
            if (((Boolean)ReArm.CONFIG.protection.magicProtection.get()).booleanValue()) {
                ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ReArm.id("magic_protection"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            }
            if (((Boolean)ReArm.CONFIG.shield.enableBash.get()).booleanValue()) {
                ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ReArm.id("bash"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            }
        });
    }

    private static void initItems() {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)ReArm.id("netherite_bow"), (Object)ReArmItems.NETHERITE_BOW);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)ReArm.id("netherite_crossbow"), (Object)ReArmItems.NETHERITE_CROSSBOW);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)ReArm.id("netherite_shield"), (Object)ReArmItems.NETHERITE_SHIELD);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40202).register(contents -> {
            contents.addAfter((class_1935)class_1802.field_8399, new class_1935[]{ReArmItems.NETHERITE_CROSSBOW});
            contents.addAfter((class_1935)class_1802.field_8102, new class_1935[]{ReArmItems.NETHERITE_BOW});
            contents.addAfter((class_1935)class_1802.field_8255, new class_1935[]{ReArmItems.NETHERITE_SHIELD});
        });
    }

    private void initBackstep() {
        PayloadTypeRegistry.playC2S().register(BackstepAbility.C2SCauseBackstepExhaustionPayload.TYPE, BackstepAbility.C2SCauseBackstepExhaustionPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(BackstepAbility.C2SCauseBackstepExhaustionPayload.TYPE, (payload, context) -> context.player().method_7322(payload.exhaustion()));
    }

    private static void initBash() {
        PayloadTypeRegistry.playC2S().register(BashAbility.C2SBashSignal.TYPE, BashAbility.C2SBashSignal.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(BashAbility.C2SBashSignal.TYPE, (payload, context) -> BashAbility.handleBash(payload, context.player()));
    }

    private static void initCripplingThrow() {
        class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)ReArm.id("axe"), CripplingThrowAbility.AXE);
        PayloadTypeRegistry.playC2S().register(CripplingThrowAbility.C2SUpdatePlayerRecallCondition.TYPE, CripplingThrowAbility.C2SUpdatePlayerRecallCondition.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(CripplingThrowAbility.C2SUpdatePlayerRecallCondition.TYPE, (payload, context) -> CripplingThrowAbility.recallSignals.add(payload.activePlayerUUID()));
    }

    private static void initCriticalCounter() {
        PayloadTypeRegistry.playC2S().register(CriticalCounterAbility.C2SUpdatePlayerCounterCondition.TYPE, CriticalCounterAbility.C2SUpdatePlayerCounterCondition.CODEC);
        PayloadTypeRegistry.playS2C().register(CriticalCounterAbility.S2CStartCriticalCounterTimer.TYPE, CriticalCounterAbility.S2CStartCriticalCounterTimer.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(CriticalCounterAbility.C2SUpdatePlayerCounterCondition.TYPE, (payload, context) -> CriticalCounterAbility.setPlayerCounterCondition(payload.activePlayerUUID(), payload.shouldCounter()));
    }

    private static void enchantableShield() {
    }
}

