/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm;

import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.pajic.rearm.config.ModConfig;
import me.pajic.rearm.mixson.ClientResourceModifications;
import me.pajic.rearm.mixson.CommonResourceModifications;
import me.pajic.rearm.model.ReArmModels;
import me.pajic.rearm.platform.Platform;
import me.pajic.rearm.platform.neoforge.NeoforgePlatform;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReArm {
    public static final String MOD_ID = "rearm";
    public static final String MOD_VERSION = "2.4.9";
    public static final String MOD_FRIENDLY_NAME = "ReArm";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rearm");
    public static final ResourceLocation CONFIG_RL = ResourceLocation.fromNamespaceAndPath((String)"rearm", (String)"config");
    public static ModConfig CONFIG = (ModConfig)ConfigApiJava.registerAndLoadConfig(ModConfig::new);
    private static final Platform PLATFORM = ReArm.createPlatformInstance();
    public static final String PACK_VERSION = PLATFORM.mcVersion().replace(".", "_");
    public static final TagKey<Item> SHIELDS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/shield"));

    public static void onInitialize() {
        CommonResourceModifications.init();
    }

    public static void onInitializeClient() {
        ReArmModels.initModels();
        ClientResourceModifications.init();
        ConfigApi.event().onUpdateClient((rl, config) -> {
            if (rl.equals((Object)CONFIG_RL) && (Integer)ReArm.CONFIG.armor.helmetArmorPercent.get() + (Integer)ReArm.CONFIG.armor.chestplateArmorPercent.get() + (Integer)ReArm.CONFIG.armor.leggingsArmorPercent.get() + (Integer)ReArm.CONFIG.armor.bootsArmorPercent.get() != 100) {
                ReArm.CONFIG.armor.helmetArmorPercent.validateAndSet((Object)((Integer)ReArm.CONFIG.armor.helmetArmorPercent.getDefault()));
                ReArm.CONFIG.armor.chestplateArmorPercent.validateAndSet((Object)((Integer)ReArm.CONFIG.armor.chestplateArmorPercent.getDefault()));
                ReArm.CONFIG.armor.leggingsArmorPercent.validateAndSet((Object)((Integer)ReArm.CONFIG.armor.leggingsArmorPercent.getDefault()));
                ReArm.CONFIG.armor.bootsArmorPercent.validateAndSet((Object)((Integer)ReArm.CONFIG.armor.bootsArmorPercent.getDefault()));
            }
        });
    }

    public static Platform xplat() {
        return PLATFORM;
    }

    private static Platform createPlatformInstance() {
        return new NeoforgePlatform();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void debugLog(String message, Object ... args) {
        if (PLATFORM.isDebug()) {
            LOGGER.info(message, args);
        }
    }
}

