/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import me.pajic.rearm.Main;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Projectile {
    @Shadow
    @Nullable
    private ItemStack firedFromWeapon;

    public AbstractArrowMixin(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean isCritArrow();

    @Shadow
    public abstract ItemStack getWeaponItem();

    @Unique
    private boolean shotFromCrossbow() {
        return this.firedFromWeapon != null && this.firedFromWeapon.getItem() instanceof CrossbowItem;
    }

    @ModifyExpressionValue(method={"onHitEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;length()D")})
    private double modifyVelocity(double original) {
        if (((Boolean)Main.CONFIG.bow.enablePerfectShot.get()).booleanValue() && !this.shotFromCrossbow() && original > 3.0 && original < 3.5) {
            return 3.0;
        }
        if (((Boolean)Main.CONFIG.crossbow.fixedArrowDamage.get()).booleanValue() && this.shotFromCrossbow()) {
            return (double)((Integer)Main.CONFIG.crossbow.fixedArrowDamageAmount.get()).intValue() / 2.0;
        }
        return original;
    }

    @ModifyExpressionValue(method={"onHitEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/AbstractArrow;isCritArrow()Z")})
    private boolean modifyCrit(boolean original, @Local LocalIntRef i, @Local(ordinal=0) Entity entity, @Local DamageSource damageSource) {
        if (((Boolean)Main.CONFIG.bow.enablePerfectShot.get()).booleanValue() && this.isCritArrow() && !this.shotFromCrossbow()) {
            if (this.getWeaponItem() != null) {
                float bonusDamage = EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)this.level()), (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damageSource, (float)((Integer)Main.CONFIG.bow.perfectShotAdditionalDamage.get()).intValue());
                i.set((int)((float)i.get() + bonusDamage));
            }
            return false;
        }
        if (((Boolean)Main.CONFIG.crossbow.fixedArrowDamage.get()).booleanValue() && this.shotFromCrossbow()) {
            return false;
        }
        return original;
    }

    @ModifyExpressionValue(method={"onHitEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/AbstractArrow;getPierceLevel()B", ordinal=3)})
    private byte stopPiercingArrowOnArmoredEntity(byte original, @Local(argsOnly=true) EntityHitResult result) {
        Entity entity;
        if (((Boolean)Main.CONFIG.crossbow.stopPiercingOnArmoredEntity.get()).booleanValue() && original > 0 && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (!(entity2.equipment.get(EquipmentSlot.HEAD).isEmpty() && entity2.equipment.get(EquipmentSlot.CHEST).isEmpty() && entity2.equipment.get(EquipmentSlot.LEGS).isEmpty() && entity2.equipment.get(EquipmentSlot.FEET).isEmpty())) {
                return 0;
            }
        }
        return original;
    }
}

