/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import me.pajic.rearm.CompatFlags;
import me.pajic.rearm.renderer.RendererConstants;
import me.pajic.rearm.renderer.TrimicaCompat;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.special.ShieldSpecialRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetheriteShieldSpecialRenderer
extends ShieldSpecialRenderer {
    private final MaterialSet materials;
    private final ShieldModel model;

    public NetheriteShieldSpecialRenderer(MaterialSet materials, ShieldModel model) {
        super(materials, model);
        this.materials = materials;
        this.model = model;
    }

    public void submit(@Nullable DataComponentMap dataComponentMap, @NotNull ItemDisplayContext displayContext, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, boolean hasFoil, int outlineColor) {
        BannerPatternLayers bannerPatternLayers = dataComponentMap != null ? (BannerPatternLayers)dataComponentMap.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY) : BannerPatternLayers.EMPTY;
        DyeColor dyeColor = dataComponentMap != null ? (DyeColor)dataComponentMap.get(DataComponents.BASE_COLOR) : null;
        boolean bl2 = !bannerPatternLayers.layers().isEmpty() || dyeColor != null;
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        Material material = bl2 ? new Material(ResourceLocation.fromNamespaceAndPath((String)"rearm", (String)"textures/atlas/netherite_shield_patterns.png"), ResourceLocation.fromNamespaceAndPath((String)"rearm", (String)"entity/netherite_shield_base")) : new Material(ResourceLocation.fromNamespaceAndPath((String)"rearm", (String)"textures/atlas/netherite_shield_patterns.png"), ResourceLocation.fromNamespaceAndPath((String)"rearm", (String)"entity/netherite_shield_base_nopattern"));
        nodeCollector.submitModelPart(this.model.handle(), poseStack, this.model.renderType(material.atlasLocation()), packedLight, packedOverlay, this.materials.get(material), false, false, -1, null, outlineColor);
        if (bl2) {
            BannerRenderer.submitPatterns((MaterialSet)this.materials, (PoseStack)poseStack, (SubmitNodeCollector)nodeCollector, (int)packedLight, (int)packedOverlay, (Model)this.model, (Object)Unit.INSTANCE, (Material)material, (boolean)false, (DyeColor)Objects.requireNonNullElse(dyeColor, DyeColor.WHITE), (BannerPatternLayers)bannerPatternLayers, (boolean)hasFoil, null, (int)outlineColor);
        } else {
            nodeCollector.submitModelPart(this.model.plate(), poseStack, this.model.renderType(material.atlasLocation()), packedLight, packedOverlay, this.materials.get(material), false, hasFoil, -1, null, outlineColor);
        }
        if (CompatFlags.TRIMICA_LOADED) {
            TrimicaCompat.submitTrim(this.model.plate(), dataComponentMap, poseStack, nodeCollector, packedLight, packedOverlay, hasFoil, outlineColor);
        }
        poseStack.popPose();
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final Unbaked INSTANCE = new Unbaked();
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit((Object)INSTANCE);

        @NotNull
        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        @NotNull
        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext context) {
            return new NetheriteShieldSpecialRenderer(context.materials(), new ShieldModel(context.entityModelSet().bakeLayer(RendererConstants.NETHERITE_SHIELD_LAYER)));
        }
    }
}

