/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.util;

import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.pajic.rearm.Main;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.equipment.ArmorType;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmorMaterialHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ReArm Armor Material Helper");
    private static final Path FILE_PATH = FMLPaths.CONFIGDIR.get().resolve("rearm/armor_materials.txt");
    private static final List<ResourceLocation> ARMOR_MATERIALS = new ArrayList<ResourceLocation>();

    public static Map<ArmorType, Integer> calculateDefenses(int targetTotal) {
        int[] values = new int[]{Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.chestplateArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.leggingsArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.helmetArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.bootsArmorPercent.get()).intValue() / 100.0f))};
        int body = Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.bodyArmorPercent.get()).intValue() / 100.0f));
        int total = Arrays.stream(values).sum();
        if (total != targetTotal) {
            int i = 0;
            while (total != targetTotal) {
                if (total > targetTotal) {
                    int n = i;
                    values[n] = values[n] - 1;
                    --total;
                } else {
                    int n = i;
                    values[n] = values[n] + 1;
                    ++total;
                }
                i = i == 3 ? 0 : i + 1;
            }
        }
        return Maps.newEnumMap(Map.of(ArmorType.HELMET, values[2], ArmorType.CHESTPLATE, values[0], ArmorType.LEGGINGS, values[1], ArmorType.BOOTS, values[3], ArmorType.BODY, body));
    }

    public static float calculateKnockbackResist(int targetTotal) {
        return Mth.lerp((float)((float)targetTotal / (20.0f * ((Float)Main.CONFIG.armor.armorMultiplier.get()).floatValue())), (float)0.0f, (float)0.1f);
    }

    public static void add(ResourceLocation rl) {
        ARMOR_MATERIALS.add(rl);
    }

    public static void write() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(FILE_PATH.toFile()));
            writer.write(Component.translatable((String)"rearm.config.armor.armorMaterialList").getString());
            writer.newLine();
            writer.newLine();
            for (ResourceLocation rl : ARMOR_MATERIALS) {
                writer.write(rl.toString());
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            LOGGER.warn("Error writing armor materials to file", (Throwable)e);
        }
    }
}

