/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import me.pajic.rearm.CompatFlags;
import me.pajic.rearm.ReArm;
import me.pajic.rearm.ability.CripplingThrowAbility;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Shadow
    public abstract int getUseDuration(ItemStack var1, LivingEntity var2);

    @WrapMethod(method={"getUseDuration"})
    private int axe_useDuration(ItemStack stack, LivingEntity entity, Operation<Integer> original) {
        if (((Boolean)ReArm.CONFIG.axe.cripplingThrow.get()).booleanValue() && stack.is(ItemTags.AXES)) {
            return 72000;
        }
        return (Integer)original.call(new Object[]{stack, entity});
    }

    @WrapMethod(method={"getUseAnimation"})
    private ItemUseAnimation axe_useAnimaton(ItemStack stack, Operation<ItemUseAnimation> original) {
        if (((Boolean)ReArm.CONFIG.axe.cripplingThrow.get()).booleanValue() && stack.is(ItemTags.AXES)) {
            if (CompatFlags.HMI_LOADED) {
                return ItemUseAnimation.NONE;
            }
            return ItemUseAnimation.SPEAR;
        }
        return (ItemUseAnimation)original.call(new Object[]{stack});
    }

    @WrapMethod(method={"use"})
    private InteractionResult axe_use(Level level, Player player, InteractionHand usedHand, Operation<InteractionResult> original) {
        ItemStack stack;
        if (((Boolean)ReArm.CONFIG.axe.cripplingThrow.get()).booleanValue() && (stack = player.getItemInHand(usedHand)).is(ItemTags.AXES)) {
            return CripplingThrowAbility.useAxe(level, player, usedHand, stack);
        }
        return (InteractionResult)original.call(new Object[]{level, player, usedHand});
    }

    @WrapMethod(method={"releaseUsing"})
    private boolean axe_releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, Operation<Boolean> original) {
        if (((Boolean)ReArm.CONFIG.axe.cripplingThrow.get()).booleanValue() && stack.is(ItemTags.AXES)) {
            CripplingThrowAbility.throwAxe(stack, level, livingEntity, timeCharged, this.getUseDuration(stack, livingEntity));
        }
        return (Boolean)original.call(new Object[]{stack, level, livingEntity, timeCharged});
    }
}

