/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.rearm.ReArm;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private int parryTimer = 0;
    @Unique
    private final LivingEntity self = (LivingEntity)this;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyArg(method={"getDamageAfterArmorAbsorb"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterAbsorb(Lnet/minecraft/world/entity/LivingEntity;FLnet/minecraft/world/damagesource/DamageSource;FF)F"), index=3)
    private float crossbow_pierceArmor(float original, @Local(argsOnly=true) DamageSource source) {
        if (((Boolean)ReArm.CONFIG.crossbow.improvedPiercing.get()).booleanValue()) {
            int piercingLevel = source.getWeaponItem() != null ? EnchantmentHelper.getItemEnchantmentLevel((Holder)this.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PIERCING), (ItemStack)source.getWeaponItem()) : 0;
            return original * (1.0f - (float)((Integer)ReArm.CONFIG.crossbow.percentArmorIgnoredPerLevel.get() * piercingLevel) / 100.0f);
        }
        return original;
    }

    @Inject(method={"applyItemBlocking"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/common/CommonHooks;onDamageBlock(Lnet/minecraft/world/entity/LivingEntity;Lnet/neoforged/neoforge/common/damagesource/DamageContainer;FZ)Lnet/neoforged/neoforge/event/entity/living/LivingShieldBlockEvent;")})
    private void parry_onHurtShield(ServerLevel level, DamageSource source, float damageAmount, CallbackInfoReturnable<Float> cir) {
        Entity entity;
        if (this.self instanceof Player && this.parryTimer > 0 && source.is(DamageTypeTags.IS_PROJECTILE) && (entity = source.getDirectEntity()) instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            level.sendParticles((ParticleOptions)ParticleTypes.CRIT, projectile.getX(), projectile.getY(), projectile.getZ(), 8, 0.2, 0.2, 0.2, 0.2);
            projectile.setDeltaMovement(projectile.getDeltaMovement().scale(7.5));
            float f = 170.0f + this.random.nextFloat() * 20.0f;
            projectile.setYRot(projectile.getYRot() + f);
            projectile.hasImpulse = true;
        }
    }

    @Inject(method={"startUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseDuration(Lnet/minecraft/world/entity/LivingEntity;)I")})
    private void parry_onStartUsingShield(InteractionHand hand, CallbackInfo ci, @Local ItemStack itemStack) {
        if (((Boolean)ReArm.CONFIG.shield.enableParry.get()).booleanValue() && this.self instanceof Player && itemStack.is(ReArm.SHIELDS)) {
            this.parryTimer = (Integer)ReArm.CONFIG.shield.parryTimeframe.get();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void parry_onTick(CallbackInfo ci) {
        if (this.self instanceof Player && this.parryTimer > 0) {
            --this.parryTimer;
        }
    }

    @WrapWithCondition(method={"hurtServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/BlocksAttacks;onBlocked(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private boolean parry_increasePitch(BlocksAttacks instance, ServerLevel level, LivingEntity entity) {
        if (this.self instanceof Player && this.parryTimer > 0) {
            instance.blockSound().ifPresent(holder -> level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), holder, entity.getSoundSource(), 1.0f, 1.2f + level.random.nextFloat() * 0.4f));
            return false;
        }
        return true;
    }

    @ModifyExpressionValue(method={"getItemBlockingWith"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/BlocksAttacks;blockDelayTicks()I")})
    private int parry_removeShieldBlockDelay(int original) {
        return 0;
    }

    @ModifyExpressionValue(method={"getVisibilityPercent"}, at={@At(value="CONSTANT", args={"doubleValue=0.8"})})
    private double modifyVisibilityWhenDiscrete(double original) {
        if (((Boolean)ReArm.CONFIG.tweaks.improvedSneaking.get()).booleanValue()) {
            return 1.0 - (double)((Integer)ReArm.CONFIG.tweaks.detectionRangeReduction.get()).intValue() / 100.0;
        }
        return original;
    }
}

