/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import me.pajic.rearm.projectile.ThrownAxe;
import me.pajic.rearm.renderer.ThrownAxeRenderState;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class ThrownAxeRenderer
extends EntityRenderer<ThrownAxe, ThrownAxeRenderState> {
    private final ItemModelResolver itemModelResolver;

    public ThrownAxeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
    }

    public void submit(ThrownAxeRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.scale(1.3f, 1.3f, 1.3f);
        poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(90.0f - renderState.yRot));
        if (!renderState.stuck) {
            poseStack.mulPose((Quaternionfc)Axis.ZN.rotationDegrees(Mth.lerp((float)renderState.partialTick, (float)renderState.yRot, (float)(renderState.yRot + 180.0f))));
        } else {
            poseStack.mulPose((Quaternionfc)Axis.ZN.rotationDegrees(90.0f));
        }
        renderState.item.submit(poseStack, nodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.outlineColor);
        poseStack.popPose();
        super.submit((EntityRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
    }

    @NotNull
    public ThrownAxeRenderState createRenderState() {
        return new ThrownAxeRenderState();
    }

    public void extractRenderState(ThrownAxe entity, ThrownAxeRenderState renderState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)renderState, partialTick);
        renderState.yRot = entity.getYRot(partialTick);
        renderState.xRot = entity.getXRot(partialTick);
        renderState.stuck = (Boolean)entity.getEntityData().get(ThrownAxe.STUCK);
        renderState.axe = (ItemStack)entity.getEntityData().get(ThrownAxe.THROWN_AXE_ITEM_STACK);
        renderState.partialTick = partialTick;
        renderState.extractItemGroupRenderState((Entity)entity, this.itemModelResolver);
    }
}

