package me.pajic.rearm.renderer;

import com.mojang.serialization.MapCodec;
import me.pajic.rearm.CompatFlags;
import me.pajic.rearm.ReArm;
import net.minecraft.class_10509;
import net.minecraft.class_10515;
import net.minecraft.class_11659;
import net.minecraft.class_11701;
import net.minecraft.class_1767;
import net.minecraft.class_3902;
import net.minecraft.class_4587;
import net.minecraft.class_4730;
import net.minecraft.class_600;
import net.minecraft.class_811;
import net.minecraft.class_823;
import net.minecraft.class_9307;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class NetheriteShieldSpecialRenderer extends class_10509 {
    private final class_11701 materials;
    private final class_600 model;

    public NetheriteShieldSpecialRenderer(class_11701 materials, class_600 model) {
        super(materials, model);
        this.materials = materials;
        this.model = model;
    }

    @Override
    public void method_65707(
            @Nullable class_9323 dataComponentMap,
            class_811 displayContext,
            class_4587 poseStack,
            class_11659 nodeCollector,
            int packedLight,
            int packedOverlay,
            boolean hasFoil,
            int outlineColor
    ) {
        class_9307 bannerPatternLayers = dataComponentMap != null
                ? dataComponentMap.method_58695(class_9334.field_49619, class_9307.field_49404)
                : class_9307.field_49404;
        class_1767 dyeColor = dataComponentMap != null ? dataComponentMap.method_58694(class_9334.field_49620) : null;
        boolean bl2 = !bannerPatternLayers.comp_2428().isEmpty() || dyeColor != null;
        poseStack.method_22903();
        poseStack.method_22905(1.0F, -1.0F, -1.0F);
        class_4730 material = bl2 ? new class_4730(
                ReArm.id("textures/atlas/netherite_shield_patterns.png"),
				ReArm.id("entity/netherite_shield_base")
        ) : new class_4730(
				ReArm.id("textures/atlas/netherite_shield_patterns.png"),
				ReArm.id("entity/netherite_shield_base_nopattern")
        );
        nodeCollector.method_73494(
                this.model.method_23775(),
                poseStack,
                this.model.method_23500(material.method_24144()),
                packedLight,
                packedOverlay,
                this.materials.method_73030(material),
                false,
                false,
                -1,
                null,
                outlineColor
        );
        if (bl2) {
            class_823.method_23802(
                    this.materials,
                    poseStack,
                    nodeCollector,
                    packedLight,
                    packedOverlay,
                    this.model,
                    class_3902.field_17274,
                    material,
                    false,
                    Objects.requireNonNullElse(dyeColor, class_1767.field_7952),
                    bannerPatternLayers,
                    hasFoil,
                    null,
                    outlineColor
            );
        } else {
            nodeCollector.method_73494(
                    this.model.method_23774(),
                    poseStack,
                    this.model.method_23500(material.method_24144()),
                    packedLight,
                    packedOverlay,
                    this.materials.method_73030(material),
                    false,
                    hasFoil,
                    -1,
                    null,
                    outlineColor
            );
        }
        if (CompatFlags.TRIMICA_LOADED) TrimicaCompat.submitTrim(
                model.method_23774(), dataComponentMap, poseStack, nodeCollector, packedLight, packedOverlay, hasFoil, outlineColor
        );

        poseStack.method_22909();
    }

    public record Unbaked() implements class_10515.class_10516 {
        public static final Unbaked INSTANCE = new Unbaked();
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit(INSTANCE);

        @Override @NotNull
        public MapCodec<Unbaked> method_65696() {
            return MAP_CODEC;
        }

        @Override
        public @NotNull class_10515<?> method_65698(class_11695 context) {
            return new NetheriteShieldSpecialRenderer(
                    context.comp_4551(),
                    new class_600(context.comp_3391().method_32072(RendererConstants.NETHERITE_SHIELD_LAYER))
            );
        }
    }
}
//?}
