package me.pajic.rearm.renderer;

import me.pajic.rearm.projectile.ThrownAxe;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

public class ThrownAxeRenderer extends class_897<ThrownAxe, ThrownAxeRenderState> {
    private final class_10442 itemModelResolver;

    public ThrownAxeRenderer(class_5617.class_5618 context) {
        super(context);
        itemModelResolver = context.method_65566();
    }

    @Override
    public void submit(ThrownAxeRenderState renderState, class_4587 poseStack, class_11659 nodeCollector, class_12075 cameraRenderState) {
        poseStack.method_22903();
        poseStack.method_22905(1.3F, 1.3F, 1.3F);
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(90.0F - renderState.yRot));
        if (!renderState.stuck) {
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(class_3532.method_16439(renderState.partialTick, renderState.yRot, renderState.yRot + 180.0F)));
        } else {
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(90.0F));
        }
        renderState.item.method_65604(poseStack, nodeCollector, renderState.field_61820, class_4608.field_21444, renderState.field_61821);
        poseStack.method_22909();
        super.method_3936(renderState, poseStack, nodeCollector, cameraRenderState);
    }

    @Override
    public @NotNull ThrownAxeRenderState method_55269() {
        return new ThrownAxeRenderState();
    }

    @Override
    public void extractRenderState(ThrownAxe entity, ThrownAxeRenderState renderState, float partialTick) {
        super.method_62354(entity, renderState, partialTick);
        renderState.yRot = entity.method_61415(partialTick);
        renderState.xRot = entity.method_61414(partialTick);
        renderState.stuck = entity.method_5841().method_12789(ThrownAxe.STUCK);
        renderState.axe = entity.method_5841().method_12789(ThrownAxe.THROWN_AXE_ITEM_STACK);
        renderState.partialTick = partialTick;
        renderState.extractItemGroupRenderState(entity, itemModelResolver);
    }
}
//?}
