/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.List;
import me.pajic.rearm.Main;
import me.pajic.rearm.ability.CriticalCounterAbility;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Player.class}, priority=250)
public abstract class PlayerMixin
extends LivingEntity {
    @Shadow
    @NotNull
    public abstract ItemStack getWeaponItem();

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getSweepHitBox(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/phys/AABB;")})
    private AABB sweepingEdge_increaseAttackRadius(AABB original, @Local(argsOnly=true) Entity target) {
        int sweepingEdgeLevel;
        if (((Boolean)Main.CONFIG.sword.improvedSweepingEdge.get()).booleanValue() && (sweepingEdgeLevel = this.getWeaponItem().getEnchantmentLevel((Holder)this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SWEEPING_EDGE))) > 0) {
            return target.getBoundingBox().inflate((double)sweepingEdgeLevel, sweepingEdgeLevel >= 3 ? 1.0 : 0.25, (double)sweepingEdgeLevel);
        }
        return original;
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;")})
    private <T extends Entity> List<T> sweepingEdge_getHitEntities(List<T> original, @Share(value="original") LocalRef<List<T>> hitEntityList) {
        if (((Boolean)Main.CONFIG.sword.improvedSweepingEdge.get()).booleanValue()) {
            hitEntityList.set(original);
        }
        return original;
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"), index=2)
    private <T extends Entity> float sweepingEdge_increaseDamage(float damage, @Share(value="original") LocalRef<List<T>> hitEntityList, @Local(ordinal=2) float h) {
        if (((Boolean)Main.CONFIG.sword.improvedSweepingEdge.get()).booleanValue()) {
            float additionalDamage = ((Float)Main.CONFIG.sword.sweepingEdgeAdditionalDamagePerMob.get()).floatValue() * (float)Math.min(((List)hitEntityList.get()).size() - 1, (Integer)Main.CONFIG.sword.maxMobAmountUsedForDamageIncrease.get());
            return damage + additionalDamage * h;
        }
        return damage;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), ordinal=2)
    private boolean criticalCounter_critOnlyIfCriticalCounter(boolean original) {
        Player player = (Player)this;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (CriticalCounterAbility.canCounter(this.getWeaponItem())) {
                return CriticalCounterAbility.getPlayerCounterCondition(serverPlayer.getUUID());
            }
        }
        return original;
    }

    @ModifyExpressionValue(method={"getProjectile"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Abilities;instabuild:Z")})
    private boolean infinityFix(boolean original, @Local(argsOnly=true) ItemStack weaponStack) {
        if (((Boolean)Main.CONFIG.tweaks.infinityFix.get()).booleanValue()) {
            int infinityLevel = weaponStack.getEnchantmentLevel((Holder)this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.INFINITY));
            return original || infinityLevel > 0;
        }
        return original;
    }
}

