package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.rearm.ReArm;
import net.minecraft.class_10707;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Unique private int parryTimer = 0;
    @Unique private final class_1309 self = (class_1309) (Object) this;

    @ModifyArg(
            method = "getDamageAfterArmorAbsorb",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterAbsorb(Lnet/minecraft/world/entity/LivingEntity;FLnet/minecraft/world/damagesource/DamageSource;FF)F"
            ),
            index = 3
    )
    private float crossbow_pierceArmor(float original, @Local(argsOnly = true) class_1282 source) {
        if (ReArm.CONFIG.crossbow.improvedPiercing.get()) {
            int piercingLevel = source.method_60948() != null ?
                    class_1890.method_8225(
                            //? if 1.21.1
                            /*registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.PIERCING),*/
                            //? if > 1.21.1
                            method_56673().method_30530(class_7924.field_41265).method_46747(class_1893.field_9132),
                            source.method_60948()
                    ) : 0;
            return original * (1 - ((float) (ReArm.CONFIG.crossbow.percentArmorIgnoredPerLevel.get() * piercingLevel) / 100));
        }
        return original;
    }

    //? if 1.21.1 {
    /*@Inject(
            method = "hurt",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/LivingEntity;hurtCurrentlyUsedShield(F)V"
            )
    )
    private void parry_onHurtShield(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (self instanceof Player && parryTimer > 0 && source.is(DamageTypeTags.IS_PROJECTILE) && source.getDirectEntity() instanceof Projectile projectile) {
            if (!level().isClientSide) ((ServerLevel) level()).sendParticles(ParticleTypes.CRIT, projectile.getX(), projectile.getY(), projectile.getZ(), 8, 0.2, 0.2, 0.2, 0.2);
            projectile.setDeltaMovement(projectile.getDeltaMovement().scale(7.5));
            float f = 170.0F + random.nextFloat() * 20.0F;
            projectile.setYRot(projectile.getYRot() + f);
            projectile.hasImpulse = true;
        }
    }
    *///?} else {
    @Inject(
            method = "applyItemBlocking",
            at = @At(
                    value = "INVOKE",
					//? if fabric
                    target = "Lnet/minecraft/world/item/component/BlocksAttacks;hurtBlockingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/InteractionHand;F)V"
					//? if neoforge
					/*target = "Lnet/neoforged/neoforge/common/CommonHooks;onDamageBlock(Lnet/minecraft/world/entity/LivingEntity;Lnet/neoforged/neoforge/common/damagesource/DamageContainer;FZ)Lnet/neoforged/neoforge/event/entity/living/LivingShieldBlockEvent;"*/
            )
    )
    private void parry_onHurtShield(class_3218 level, class_1282 source, float damageAmount, CallbackInfoReturnable<Float> cir) {
        if (self instanceof class_1657 && parryTimer > 0 && source.method_48789(class_8103.field_42247) && source.method_5526() instanceof class_1676 projectile) {
            level.method_65096(class_2398.field_11205, projectile.method_23317(), projectile.method_23318(), projectile.method_23321(), 8, 0.2, 0.2, 0.2, 0.2);
            projectile.method_18799(projectile.method_18798().method_1021(7.5));
            float f = 170.0F + field_5974.method_43057() * 20.0F;
            projectile.method_36456(projectile.method_36454() + f);
            projectile.field_6007 = true;
        }
    }
    //?}

    @Inject(
            method = "startUsingItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;getUseDuration(Lnet/minecraft/world/entity/LivingEntity;)I"
            )
    )
    private void parry_onStartUsingShield(class_1268 hand, CallbackInfo ci, @Local class_1799 itemStack) {
        if (ReArm.CONFIG.shield.enableParry.get() && self instanceof class_1657 && itemStack.method_31573(ReArm.SHIELDS)) {
            parryTimer = ReArm.CONFIG.shield.parryTimeframe.get();
        }
    }

    @Inject(
            method = "tick",
            at = @At("TAIL")
    )
    private void parry_onTick(CallbackInfo ci) {
        if (self instanceof class_1657 && parryTimer > 0) parryTimer--;
    }

    //? if 1.21.1 {
    /*@ModifyArg(
            method = "handleEntityEvent",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/LivingEntity;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V",
                    ordinal = 2
            ),
            index = 2
    )
    private float parry_increasePitch(float original) {
        if (self instanceof Player && parryTimer > 0) return original + 0.4F;
        return original;
    }
    *///?} else {
    @WrapWithCondition(
            method = "hurtServer",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/component/BlocksAttacks;onBlocked(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"
            )
    )
    private boolean parry_increasePitch(class_10707 instance, class_3218 level, class_1309 entity) {
        if (self instanceof class_1657 && parryTimer > 0) {
            instance.comp_3590().ifPresent(holder -> level.method_60511(
                    null, entity.method_23317(), entity.method_23318(), entity.method_23321(),
                    holder, entity.method_5634(), 1.0F, 1.2F + level.field_9229.method_43057() * 0.4F
            ));
            return false;
        }
        return true;
    }
    //?}

    //? if 1.21.1 {
    /*@ModifyExpressionValue(
            method = "isBlocking",
            at = @At(
                    value = "CONSTANT",
                    args = "intValue=5"
            )
    )
    private int parry_removeShieldBlockDelay(int original) {
        return 0;
    }
    *///?} else {
    @ModifyExpressionValue(
            method = "getItemBlockingWith",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/component/BlocksAttacks;blockDelayTicks()I"
            )
    )
    private int parry_removeShieldBlockDelay(int original) {
        return 0;
    }
    //?}

    @ModifyExpressionValue(
            method = "getVisibilityPercent",
            at = @At(
                    value = "CONSTANT",
                    args = "doubleValue=0.8"
            )
    )
    private double modifyVisibilityWhenDiscrete(double original) {
        if (ReArm.CONFIG.tweaks.improvedSneaking.get()) {
            return 1 - (double) ReArm.CONFIG.tweaks.detectionRangeReduction.get() / 100;
        }
        return original;
    }
}
