/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.util;

import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.pajic.rearm.ReArm;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_8051;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmorMaterialHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ReArm Armor Material Helper");
    private static final Path FILE_PATH = ReArm.xplat().getConfigDir().resolve("rearm/armor_materials.txt");
    private static final List<class_2960> ARMOR_MATERIALS = new ArrayList<class_2960>();

    public static Map<class_8051, Integer> calculateDefenses(int targetTotal) {
        int[] values = new int[]{Math.round((float)targetTotal * ((float)((Integer)ReArm.CONFIG.armor.chestplateArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)ReArm.CONFIG.armor.leggingsArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)ReArm.CONFIG.armor.helmetArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)ReArm.CONFIG.armor.bootsArmorPercent.get()).intValue() / 100.0f))};
        int body = Math.round((float)targetTotal * ((float)((Integer)ReArm.CONFIG.armor.bodyArmorPercent.get()).intValue() / 100.0f));
        int total = Arrays.stream(values).sum();
        if (total != targetTotal) {
            int i = 0;
            while (total != targetTotal) {
                if (total > targetTotal) {
                    int n = i;
                    values[n] = values[n] - 1;
                    --total;
                } else {
                    int n = i;
                    values[n] = values[n] + 1;
                    ++total;
                }
                i = i == 3 ? 0 : i + 1;
            }
        }
        return Maps.newEnumMap(Map.of(class_8051.field_41934, values[2], class_8051.field_41935, values[0], class_8051.field_41936, values[1], class_8051.field_41937, values[3], class_8051.field_48838, body));
    }

    public static float calculateKnockbackResist(int targetTotal) {
        return class_3532.method_16439((float)((float)targetTotal / (20.0f * ((Float)ReArm.CONFIG.armor.armorMultiplier.get()).floatValue())), (float)0.0f, (float)0.1f);
    }

    public static void add(class_2960 rl) {
        ARMOR_MATERIALS.add(rl);
    }

    public static void write() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(FILE_PATH.toFile()));
            writer.write(class_2561.method_43471((String)"rearm.config.armor.armorMaterialList").getString());
            writer.newLine();
            writer.newLine();
            for (class_2960 rl : ARMOR_MATERIALS) {
                writer.write(rl.toString());
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            LOGGER.warn("Error writing armor materials to file", (Throwable)e);
        }
    }
}

