/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.ability;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.pajic.rearm.ReArm;
import me.pajic.rearm.enchantment.ReArmEnchantments;
import me.pajic.rearm.projectile.ThrownAxe;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CripplingThrowAbility {
    public static final ResourceLocation RECALL_AXE = ReArm.id("recall_axe");
    public static final EntityType<ThrownAxe> AXE = EntityType.Builder.of(ThrownAxe::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).eyeHeight(0.13f).updateInterval(1).build("axe");
    public static final Set<UUID> recallSignals = new HashSet<UUID>();

    public static InteractionResultHolder<ItemStack> useAxe(Level level, Player player, InteractionHand usedHand, ItemStack stack) {
        int cripplingThrowLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(ReArmEnchantments.CRIPPLING_THROW), (ItemStack)stack);
        if (cripplingThrowLevel > 0) {
            if (stack.getDamageValue() >= stack.getMaxDamage() - 1) {
                return InteractionResultHolder.fail((Object)stack);
            }
            player.startUsingItem(usedHand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public static void throwAxe(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged, int useDuration) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (useDuration - timeCharged >= 10 && stack.getDamageValue() < stack.getMaxDamage() - 1 && !level.isClientSide()) {
                stack.hurtAndBreak(2, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                ThrownAxe thrownAxe = new ThrownAxe(level, (LivingEntity)player, stack, (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE), player.getUsedItemHand());
                thrownAxe.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
                if (player.hasInfiniteMaterials()) {
                    thrownAxe.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                level.addFreshEntity((Entity)thrownAxe);
                level.playSound(null, (Entity)thrownAxe, (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.hasInfiniteMaterials()) {
                    player.getInventory().removeItem(stack);
                }
            }
        }
    }

    public record C2SUpdatePlayerRecallCondition(UUID activePlayerUUID) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<C2SUpdatePlayerRecallCondition> TYPE = new CustomPacketPayload.Type(RECALL_AXE);
        public static final StreamCodec<RegistryFriendlyByteBuf, C2SUpdatePlayerRecallCondition> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, C2SUpdatePlayerRecallCondition::activePlayerUUID, C2SUpdatePlayerRecallCondition::new);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

