/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.Map;
import me.pajic.rearm.ReArm;
import me.pajic.rearm.util.ArmorMaterialHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ArmorMaterial.class})
public class ArmorMaterialMixin {
    @Shadow
    @Final
    @Mutable
    private float knockbackResistance;
    @Shadow
    @Final
    @Mutable
    private float toughness;
    @Shadow
    @Final
    @Mutable
    private Map<ArmorItem.Type, Integer> defense;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void modifyMaterial(CallbackInfo ci, @Local(argsOnly=true) List<ArmorMaterial.Layer> id) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = id.isEmpty() ? null : id.getFirst().assetName;
        if (rl != null) {
            ArmorMaterialHelper.add(rl);
        }
        if (((Boolean)ReArm.CONFIG.armor.armorRebalance.get()).booleanValue()) {
            int targetTotal = 0;
            if (rl != null && ((Map)ReArm.CONFIG.armor.totalArmorOverrides.get()).containsKey(rl)) {
                targetTotal = (Integer)((Map)ReArm.CONFIG.armor.totalArmorOverrides.get()).get(rl);
            } else {
                for (Map.Entry<ArmorItem.Type, Integer> entry : this.defense.entrySet()) {
                    if (entry.getKey() == ArmorItem.Type.BODY) continue;
                    targetTotal += (int)((float)entry.getValue().intValue() * ((Float)ReArm.CONFIG.armor.armorMultiplier.get()).floatValue());
                }
            }
            if (targetTotal > 0) {
                this.defense = ArmorMaterialHelper.calculateDefenses(targetTotal);
            }
            if (((Boolean)ReArm.CONFIG.armor.enchantmentBasedToughness.get()).booleanValue()) {
                this.toughness = 0.0f;
            }
            if (((Boolean)ReArm.CONFIG.armor.defenseBasedKnockbackResist.get()).booleanValue()) {
                this.knockbackResistance = ArmorMaterialHelper.calculateKnockbackResist(targetTotal);
            }
        }
    }
}

