/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm;

import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.pajic.rearm.ability.CripplingThrowAbility;
import me.pajic.rearm.config.ModConfig;
import me.pajic.rearm.data.ReArmData;
import me.pajic.rearm.effect.ReArmEffects;
import me.pajic.rearm.item.ReArmItems;
import me.pajic.rearm.mixson.ResourceModifications;
import me.pajic.rearm.network.ReArmNetworking;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="rearm")
public class Main {
    public static final String MOD_ID = "rearm";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ReArm");
    private static final boolean DEBUG = !FMLLoader.isProduction();
    public static final ResourceLocation CONFIG_RL = ResourceLocation.fromNamespaceAndPath((String)"rearm", (String)"config");
    public static ModConfig CONFIG = (ModConfig)ConfigApiJava.registerAndLoadConfig(ModConfig::new);
    public static final TagKey<Item> SHIELDS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/shield"));

    public Main(IEventBus modEventBus) {
        modEventBus.addListener(ReArmData::registerDatapacks);
        modEventBus.addListener(this::registerData);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(ReArmNetworking::init);
        modEventBus.addListener(this::onInitialize);
    }

    private void registerData(RegisterEvent event) {
        ReArmEffects.init();
        ReArmItems.initItems();
        event.register(Registries.ENTITY_TYPE, registry -> registry.register(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"axe"), CripplingThrowAbility.AXE));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            event.insertAfter(Items.BOW.getDefaultInstance(), ((Item)ReArmItems.NETHERITE_BOW.value()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.CROSSBOW.getDefaultInstance(), ((Item)ReArmItems.NETHERITE_CROSSBOW.value()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.SHIELD.getDefaultInstance(), ((Item)ReArmItems.NETHERITE_SHIELD.value()).getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public void onInitialize(FMLCommonSetupEvent event) {
        ResourceModifications.init();
    }

    public static void debugLog(String message, Object ... args) {
        if (DEBUG) {
            LOGGER.info(message, args);
        }
    }
}

