/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.keybind;

import com.mojang.blaze3d.platform.InputConstants;
import me.pajic.rearm.Main;
import me.pajic.rearm.ability.CooldownTracker;
import me.pajic.rearm.effect.ReArmEffects;
import me.pajic.rearm.enchantment.ReArmEnchantments;
import me.pajic.rearm.network.ReArmNetworking;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.util.Lazy;

@EventBusSubscriber(modid="rearm", value={Dist.CLIENT})
public class ReArmKeybinds {
    private static final Lazy<KeyMapping> ACTION_KEY = Lazy.of(() -> new KeyMapping("key.rearm.action", InputConstants.Type.KEYSYM, 342, "category.rearm.keybindings"));

    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)ACTION_KEY.get());
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        if (((KeyMapping)ACTION_KEY.get()).isDown() && client.level != null && client.player != null) {
            if (CooldownTracker.backstepCooldown == 0 && ReArmKeybinds.tryBackstep((KeyMapping)ACTION_KEY.get(), client)) {
                CooldownTracker.backstepCooldown = (Integer)Main.CONFIG.bow.backstepTimeframe.get();
            }
            ReArmNetworking.sendToServer(new ReArmNetworking.C2SUpdatePlayerRecallCondition(client.player.getUUID()));
            if (((Boolean)Main.CONFIG.shield.enableBash.get()).booleanValue()) {
                ReArmNetworking.sendToServer(new ReArmNetworking.C2SBashSignal());
            }
        }
    }

    public static boolean tryBackstep(KeyMapping actionKey, Minecraft client) {
        if (client.player.hasEffect(ReArmEffects.BACKSTEP_EFFECT)) {
            LocalPlayer player = client.player;
            int backstepLevel = Math.min(EnchantmentHelper.getTagEnchantmentLevel((Holder)client.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(ReArmEnchantments.BACKSTEP), (ItemStack)player.getMainHandItem()), 3);
            Vec3 look = player.getViewVector(1.0f);
            player.setDeltaMovement(-look.x / (double)(4 - backstepLevel), player.getAttributeValue(Attributes.JUMP_STRENGTH), -look.z / (double)(4 - backstepLevel));
            ReArmNetworking.sendToServer(new ReArmNetworking.C2SCauseBackstepExhaustionPayload(5.0f));
            actionKey.setDown(false);
            return true;
        }
        return false;
    }
}

