/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.mixin;

import com.google.common.collect.Maps;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.pajic.rearm.Main;
import me.pajic.rearm.config.ArmorMaterialHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ArmorMaterial.class})
public class ArmorMaterialMixin {
    @Shadow
    @Final
    @Mutable
    private float knockbackResistance;
    @Shadow
    @Final
    @Mutable
    private float toughness;
    @Shadow
    @Final
    @Mutable
    private Map<ArmorItem.Type, Integer> defense;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void modifyMaterial(CallbackInfo ci, @Local(argsOnly=true) List<ArmorMaterial.Layer> id) {
        ResourceLocation rl = id.getFirst().assetName;
        ArmorMaterialHelper.add(rl);
        if (((Boolean)Main.CONFIG.armor.armorRebalance.get()).booleanValue()) {
            int targetTotal = 0;
            if (((Map)Main.CONFIG.armor.totalArmorOverrides.get()).containsKey(rl)) {
                targetTotal = (Integer)((Map)Main.CONFIG.armor.totalArmorOverrides.get()).get(rl);
            } else {
                for (Map.Entry<ArmorItem.Type, Integer> entry : this.defense.entrySet()) {
                    if (entry.getKey() == ArmorItem.Type.BODY) continue;
                    targetTotal += (int)((float)entry.getValue().intValue() * ((Float)Main.CONFIG.armor.armorMultiplier.get()).floatValue());
                }
            }
            int[] values = new int[]{Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.chestplateArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.leggingsArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.helmetArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.bootsArmorPercent.get()).intValue() / 100.0f))};
            int body = Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.bodyArmorPercent.get()).intValue() / 100.0f));
            int total = Arrays.stream(values).sum();
            if (total != targetTotal) {
                int i = 0;
                while (total != targetTotal) {
                    if (total > targetTotal) {
                        int n = i;
                        values[n] = values[n] - 1;
                        --total;
                    } else {
                        int n = i;
                        values[n] = values[n] + 1;
                        ++total;
                    }
                    i = i == 3 ? 0 : i + 1;
                }
            }
            this.defense = Maps.newEnumMap(Map.of(ArmorItem.Type.HELMET, values[2], ArmorItem.Type.CHESTPLATE, values[0], ArmorItem.Type.LEGGINGS, values[1], ArmorItem.Type.BOOTS, values[3], ArmorItem.Type.BODY, body));
            this.toughness = 0.0f;
            if (((Boolean)Main.CONFIG.armor.defenseBasedKnockbackResist.get()).booleanValue()) {
                this.knockbackResistance = Mth.lerp((float)((float)targetTotal / (20.0f * ((Float)Main.CONFIG.armor.armorMultiplier.get()).floatValue())), (float)0.0f, (float)0.1f);
            }
        }
    }
}

