/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.projectile;

import java.util.UUID;
import me.pajic.rearm.Main;
import me.pajic.rearm.ability.CripplingThrowAbility;
import me.pajic.rearm.effect.ReArmEffects;
import me.pajic.rearm.enchantment.ReArmEnchantments;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ThrownAxe
extends AbstractArrow {
    private boolean dealtDamage;
    private boolean failedPickup;
    private LivingEntity stuckEntity;
    private UUID stuckEntityId;
    private float damage;
    private InteractionHand hand;
    private int timeInTarget;
    public static final EntityDataAccessor<Boolean> STUCK = SynchedEntityData.defineId(ThrownAxe.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> ALLOW_PICKUP = SynchedEntityData.defineId(ThrownAxe.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<ItemStack> THROWN_AXE_ITEM_STACK = SynchedEntityData.defineId(ThrownAxe.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public ThrownAxe(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownAxe(Level level, LivingEntity shooter, ItemStack axe, float damage, InteractionHand hand) {
        super(CripplingThrowAbility.AXE, shooter, level, axe, axe);
        this.entityData.set(STUCK, (Object)false);
        this.entityData.set(ALLOW_PICKUP, (Object)false);
        this.entityData.set(THROWN_AXE_ITEM_STACK, (Object)axe);
        CripplingThrowAbility.recallSignals.remove(shooter.getUUID());
        this.damage = damage;
        this.hand = hand;
    }

    public void tick() {
        Entity entity;
        Level level;
        if (this.stuckEntity == null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (this.stuckEntityId != null && !this.stuckEntityId.equals(new UUID(0L, 0L))) {
                this.stuckEntity = (LivingEntity)sl.getEntity(this.stuckEntityId);
                this.setNoGravity(true);
                this.entityData.set(STUCK, (Object)true);
            }
        }
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        if (this.isInGround()) {
            this.entityData.set(STUCK, (Object)true);
            this.entityData.set(ALLOW_PICKUP, (Object)true);
        }
        if ((entity = this.getOwner()) != null && ((this.dealtDamage || this.isNoPhysics()) && CripplingThrowAbility.recallSignals.contains(entity.getUUID()) || this.getY() < -65.0) && !this.failedPickup) {
            if (this.stuckEntity != null && !this.stuckEntity.getType().is(EntityTypeTags.SKELETONS)) {
                this.stuckEntity.addEffect(new MobEffectInstance(ReArmEffects.BLEEDING, ((Integer)Main.CONFIG.axe.cripplingThrowBleedingDuration.get()).intValue(), this.getCripplingThrowLevel()), entity);
                this.playSound(SoundEvents.HOSTILE_HURT, 1.0f, 1.0f);
            }
            if (!this.isAcceptableReturnOwner()) {
                if (!this.level().isClientSide() && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation((ServerLevel)this.level(), this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                this.entityData.set(ALLOW_PICKUP, (Object)true);
                Vec3 vec3 = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3.y * 0.045, this.getZ());
                if (this.level().isClientSide()) {
                    this.yOld = this.getY();
                }
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(0.15)));
            }
            this.stuckEntity = null;
            this.stuckEntityId = null;
            this.setNoGravity(false);
            this.entityData.set(STUCK, (Object)false);
            this.timeInTarget = 0;
        }
        if (this.stuckEntity != null) {
            this.setPos(this.stuckEntity.getX(), this.stuckEntity.getY() + (double)(this.stuckEntity.getBbHeight() / 2.0f), this.stuckEntity.getZ());
            this.stuckEntity.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 20, (Integer)Main.CONFIG.axe.cripplingThrowBaseSlownessAmplifier.get() + (this.getCripplingThrowLevel() - 1) * (Integer)Main.CONFIG.axe.cripplingThrowSlownessAmplifierIncreasePerLevel.get()), entity);
            ++this.timeInTarget;
            if (!this.stuckEntity.isAlive() || this.timeInTarget > (Integer)Main.CONFIG.axe.maxTimeStuckInTarget.get()) {
                this.stuckEntity = null;
                this.stuckEntityId = null;
                this.setNoGravity(false);
                this.entityData.set(STUCK, (Object)false);
                this.timeInTarget = 0;
            }
        }
        super.tick();
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.getOwner();
        return entity != null && entity.isAlive() && (!(entity instanceof ServerPlayer) || !entity.isSpectator());
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        ServerLevel serverLevel;
        Entity entity = result.getEntity();
        Entity entity2 = this.getOwner();
        DamageSource damageSource = this.damageSources().thrown((Entity)this, (Entity)(entity2 == null ? this : entity2));
        float f = this.damage;
        float g = 0.0f;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            g = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damageSource, (float)f) - f;
        }
        this.dealtDamage = true;
        if (entity.hurtOrSimulate(damageSource, f + g)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            level = this.level();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)entity, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.doKnockback(livingEntity, damageSource);
                this.doPostHurtEffects(livingEntity);
                this.stuckEntity = livingEntity;
                this.stuckEntityId = livingEntity.getUUID();
                this.setNoGravity(true);
                this.entityData.set(STUCK, (Object)true);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.01, 0.1, 0.01));
        this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
    }

    private int getCripplingThrowLevel() {
        return ((ItemStack)this.entityData.get(THROWN_AXE_ITEM_STACK)).getEnchantmentLevel((Holder)this.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ReArmEnchantments.CRIPPLING_THROW));
    }

    protected void hitBlockEnchantmentEffects(@NotNull ServerLevel level, BlockHitResult hitResult, @NotNull ItemStack stack) {
        LivingEntity livingEntity;
        Vec3 vec3 = hitResult.getBlockPos().clampLocationWithin(hitResult.getLocation());
        Entity entity = this.getOwner();
        EnchantmentHelper.onHitBlock((ServerLevel)level, (ItemStack)stack, (LivingEntity)(entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null), (Entity)this, null, (Vec3)vec3, (BlockState)level.getBlockState(hitResult.getBlockPos()), item -> this.kill(level));
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STUCK, (Object)false);
        builder.define(ALLOW_PICKUP, (Object)false);
        builder.define(THROWN_AXE_ITEM_STACK, (Object)ItemStack.EMPTY);
    }

    protected EntityHitResult findHitEntity(@NotNull Vec3 startVec, @NotNull Vec3 endVec) {
        return this.dealtDamage ? null : super.findHitEntity(startVec, endVec);
    }

    @NotNull
    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }

    protected boolean tryPickup(@NotNull Player player) {
        boolean result;
        switch (this.pickup) {
            default: {
                throw new MatchException(null, null);
            }
            case DISALLOWED: {
                boolean bl = false;
                break;
            }
            case ALLOWED: {
                boolean bl;
                if (((Boolean)this.entityData.get(ALLOW_PICKUP)).booleanValue() && this.ownedBy((Entity)player)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case CREATIVE_ONLY: {
                boolean bl = result = player.hasInfiniteMaterials();
            }
        }
        if (result) {
            if (this.hand != null && player.getItemInHand(this.hand).isEmpty()) {
                player.setItemInHand(this.hand, this.getPickupItem());
            } else {
                boolean added = player.getInventory().add(this.getPickupItem());
                if (!added) {
                    this.failedPickup = true;
                    this.stuckEntity = null;
                    this.setNoGravity(false);
                    this.setNoPhysics(false);
                    this.entityData.set(STUCK, (Object)false);
                    this.timeInTarget = 0;
                    return false;
                }
            }
            CripplingThrowAbility.recallSignals.remove(player.getUUID());
        }
        return result;
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void playerTouch(@NotNull Player player) {
        if ((this.ownedBy((Entity)player) || this.getOwner() == null && !this.level().isClientSide() && (this.isInGround() || this.isNoPhysics()) && this.shakeTime <= 0) && this.tryPickup(player)) {
            player.take((Entity)this, 1);
            this.discard();
        }
    }

    protected void readAdditionalSaveData(@NotNull ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.dealtDamage = valueInput.getBooleanOr("DealtDamage", false);
        this.failedPickup = valueInput.getBooleanOr("FailedPickup", false);
        this.stuckEntityId = valueInput.read("StuckEntityId", UUIDUtil.CODEC).orElse(null);
        this.timeInTarget = valueInput.getIntOr("TimeInTarget", 0);
        this.hand = valueInput.getBooleanOr("Hand", true) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.entityData.set(STUCK, (Object)valueInput.getBooleanOr("Stuck", false));
        this.entityData.set(ALLOW_PICKUP, (Object)valueInput.getBooleanOr("AllowPickup", true));
        this.entityData.set(THROWN_AXE_ITEM_STACK, (Object)valueInput.read("ThrownAxeItemStack", ItemStack.CODEC).orElse(ItemStack.EMPTY));
    }

    protected void addAdditionalSaveData(@NotNull ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean("DealtDamage", this.dealtDamage);
        valueOutput.putBoolean("FailedPickup", this.failedPickup);
        if (this.stuckEntityId != null) {
            valueOutput.store("StuckEntityId", UUIDUtil.CODEC, (Object)this.stuckEntityId);
        }
        valueOutput.putInt("TimeInTarget", this.timeInTarget);
        valueOutput.putBoolean("Hand", this.hand == InteractionHand.MAIN_HAND);
        valueOutput.putBoolean("Stuck", ((Boolean)this.entityData.get(STUCK)).booleanValue());
        valueOutput.putBoolean("AllowPickup", ((Boolean)this.entityData.get(ALLOW_PICKUP)).booleanValue());
        if (!((ItemStack)this.entityData.get(THROWN_AXE_ITEM_STACK)).isEmpty()) {
            valueOutput.store("ThrownAxeItemStack", ItemStack.CODEC, (Object)((ItemStack)this.entityData.get(THROWN_AXE_ITEM_STACK)));
        }
    }

    public void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED) {
            super.tickDespawn();
        }
    }

    protected float getWaterInertia() {
        return 0.8f;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }
}

