/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.config;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmorMaterialHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ReArm Armor Material Helper");
    private static final Path FILE_PATH = FMLPaths.CONFIGDIR.get().resolve("rearm/armor_materials.txt");
    private static final List<ResourceLocation> ARMOR_MATERIALS = new ArrayList<ResourceLocation>();

    public static void add(ResourceLocation rl) {
        ARMOR_MATERIALS.add(rl);
    }

    public static void write() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(FILE_PATH.toFile()));
            for (ResourceLocation rl : ARMOR_MATERIALS) {
                writer.write(rl.toString());
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            LOGGER.warn("Error writing armor materials to file", (Throwable)e);
        }
    }
}

