/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.rearm.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.Arrays;
import java.util.Map;
import me.pajic.rearm.Main;
import me.pajic.rearm.config.ArmorMaterialHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAsset;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ArmorMaterial.class})
public class ArmorMaterialMixin {
    @Shadow
    @Final
    @Mutable
    private float knockbackResistance;
    @Shadow
    @Final
    @Mutable
    private float toughness;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void modifyMaterial(CallbackInfo ci, @Local(argsOnly=true) Map<ArmorType, Integer> map, @Local(argsOnly=true) ResourceKey<EquipmentAsset> id) {
        ResourceLocation rl = id.location();
        ArmorMaterialHelper.add(rl);
        if (((Boolean)Main.CONFIG.armor.armorRebalance.get()).booleanValue()) {
            int targetTotal = 0;
            if (((Map)Main.CONFIG.armor.totalArmorOverrides.get()).containsKey(rl)) {
                targetTotal = (Integer)((Map)Main.CONFIG.armor.totalArmorOverrides.get()).get(rl);
            } else {
                for (Map.Entry<ArmorType, Integer> entry : map.entrySet()) {
                    if (entry.getKey() == ArmorType.BODY) continue;
                    targetTotal += (int)((float)entry.getValue().intValue() * ((Float)Main.CONFIG.armor.armorMultiplier.get()).floatValue());
                }
            }
            int[] values = new int[]{Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.chestplateArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.leggingsArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.helmetArmorPercent.get()).intValue() / 100.0f)), Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.bootsArmorPercent.get()).intValue() / 100.0f))};
            int body = Math.round((float)targetTotal * ((float)((Integer)Main.CONFIG.armor.bodyArmorPercent.get()).intValue() / 100.0f));
            int total = Arrays.stream(values).sum();
            if (total != targetTotal) {
                int i2 = 0;
                while (total != targetTotal) {
                    if (total > targetTotal) {
                        int n = i2;
                        values[n] = values[n] - 1;
                        --total;
                    } else {
                        int n = i2;
                        values[n] = values[n] + 1;
                        ++total;
                    }
                    i2 = i2 == 3 ? 0 : i2 + 1;
                }
            }
            map.replaceAll((type, i) -> switch (type) {
                default -> throw new MatchException(null, null);
                case ArmorType.HELMET -> values[2];
                case ArmorType.CHESTPLATE -> values[0];
                case ArmorType.LEGGINGS -> values[1];
                case ArmorType.BOOTS -> values[3];
                case ArmorType.BODY -> body;
            });
            this.toughness = 0.0f;
            if (((Boolean)Main.CONFIG.armor.defenseBasedKnockbackResist.get()).booleanValue()) {
                this.knockbackResistance = Mth.lerp((float)((float)targetTotal / (20.0f * ((Float)Main.CONFIG.armor.armorMultiplier.get()).floatValue())), (float)0.0f, (float)0.1f);
            }
        }
    }
}

