/*
 * Decompiled with CFR 0.152.
 */
package vt.icl.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import org.apache.commons.io.FileUtils;
import vt.icl.ICLCommon;
import vt.icl.config.Configuration;

public class ConfigManager {
    private static final String CONFIG_FILE_NAME = "icl".toUpperCase() + ".json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Configuration config;

    public static void loadConfig() {
        File configFile = ICLCommon.CONFIG_DIR.resolve(CONFIG_FILE_NAME).toFile();
        if (configFile.exists()) {
            try {
                config = (Configuration)GSON.fromJson(FileUtils.readFileToString((File)configFile, (String)"UTF-8"), Configuration.class);
                for (String key : new Configuration().get().keySet()) {
                    if (config.get().containsKey(key)) continue;
                    config.get().put(key, new Configuration().get().get(key));
                }
            }
            catch (Exception e) {
                ICLCommon.LOGGER.info("Failed to load config file " + e.getMessage());
                config = new Configuration();
            }
        } else {
            config = new Configuration();
        }
        ConfigManager.saveConfig();
    }

    public static Configuration getConfig() {
        if (config == null) {
            ConfigManager.loadConfig();
        }
        return config;
    }

    public static void setConfig(Configuration config) {
        ConfigManager.config = config;
        ConfigManager.saveConfig();
    }

    public static void saveConfig() {
        File configFile = ICLCommon.CONFIG_DIR.resolve(CONFIG_FILE_NAME).toFile();
        try {
            FileUtils.writeStringToFile((File)configFile, (String)GSON.toJson((Object)config), (String)"UTF-8");
        }
        catch (Exception e) {
            ICLCommon.LOGGER.info("Failed to save config file " + e.getMessage());
        }
    }
}

