/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.blur;

import eu.midnightdust.blur.BlurInfo;
import eu.midnightdust.blur.config.BlurConfig;
import eu.midnightdust.blur.util.RainbowColor;
import eu.midnightdust.lib.util.MidnightColorUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Math;
import org.joml.Matrix3x2fStack;

public class Blur {
    public static final String MOD_ID = "blur";
    public static boolean doFade = false;

    public static void init() {
        BlurConfig.init((String)MOD_ID, BlurConfig.class);
    }

    public static void onRender() {
        if (!BlurInfo.doTest && BlurInfo.screenChanged) {
            Blur.onScreenChange();
            BlurInfo.screenChanged = false;
        }
        BlurInfo.doTest = false;
    }

    public static void renderFadeout(GuiGraphics context, int width, int height, Minecraft client) {
        if (BlurInfo.start >= 0L && !BlurInfo.screenHasBlur && BlurInfo.prevScreenHasBlur) {
            client.gameRenderer.processBlurEffect();
            if (BlurInfo.prevScreenHasBackground && BlurConfig.useGradient) {
                Blur.renderRotatedGradient(context, width, height);
            }
        }
    }

    public static void onScreenChange() {
        if (BlurInfo.screenHasBlur) {
            if (doFade) {
                BlurInfo.start = System.currentTimeMillis();
                doFade = false;
            }
        } else if (BlurInfo.prevScreenHasBlur && BlurConfig.fadeOutTimeMillis > 0) {
            BlurInfo.start = System.currentTimeMillis();
            doFade = true;
        } else {
            BlurInfo.start = -1L;
            doFade = true;
        }
    }

    public static void updateProgress(boolean fadeIn) {
        double x;
        if (fadeIn) {
            x = Math.min((double)((double)(System.currentTimeMillis() - BlurInfo.start) / (double)BlurConfig.fadeTimeMillis), (double)1.0);
        } else {
            x = Math.max((double)(1.0 + (double)(BlurInfo.start - System.currentTimeMillis()) / (double)BlurConfig.fadeOutTimeMillis), (double)0.0);
            if (x <= 0.0) {
                BlurInfo.start = -1L;
            }
        }
        x = BlurConfig.animationCurve.apply(x, fadeIn);
        x = Math.clamp((double)0.0, (double)1.0, (double)x);
        BlurInfo.progress = Double.valueOf(x).floatValue();
    }

    public static int getBackgroundColor(boolean second) {
        int a = second ? BlurConfig.gradientEndAlpha : BlurConfig.gradientStartAlpha;
        Color col = MidnightColorUtil.hex2Rgb((String)(second ? BlurConfig.gradientEnd : BlurConfig.gradientStart));
        if (BlurConfig.rainbowMode) {
            col = second ? Color.getHSBColor(RainbowColor.hue, 1.0f, 1.0f) : Color.getHSBColor(RainbowColor.hue2, 1.0f, 1.0f);
        }
        int r = col.getRGB() >> 16 & 0xFF;
        int b = col.getRGB() >> 8 & 0xFF;
        int g = col.getRGB() & 0xFF;
        float prog = BlurInfo.progress;
        a = (int)(prog * (float)a);
        r = (int)(prog * (float)r);
        g = (int)(prog * (float)g);
        b = (int)(prog * (float)b);
        return a << 24 | r << 16 | b << 8 | g;
    }

    public static int getRotation() {
        if (BlurConfig.rainbowMode) {
            return RainbowColor.rotation;
        }
        return BlurConfig.gradientRotation;
    }

    public static void renderRotatedGradient(GuiGraphics context, int width, int height) {
        float diagonal = Math.sqrt((float)((float)width * (float)width + (float)(height * height)));
        int smallestDimension = Math.min((int)width, (int)height);
        context.pose().pushMatrix();
        Matrix3x2fStack posMatrix = context.pose();
        posMatrix.rotate(Math.toRadians((float)Blur.getRotation()));
        posMatrix.setTranslation((float)width / 2.0f, (float)height / 2.0f);
        posMatrix.scale(diagonal / (float)smallestDimension);
        context.fillGradient(-width / 2, -height / 2, width / 2, height / 2, Blur.getBackgroundColor(false), Blur.getBackgroundColor(true));
        context.pose().popMatrix();
    }
}

