/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.blur.config;

import com.google.common.collect.Lists;
import eu.midnightdust.lib.config.EntryInfo;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.config.MidnightConfigListWidget;
import eu.midnightdust.lib.config.MidnightConfigScreen;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BlurConfig
extends MidnightConfig {
    public static final String ANIMATIONS = "animations";
    public static final String STYLE = "style";
    public static final String SCREENS = "screens";
    @MidnightConfig.Entry
    @MidnightConfig.Hidden
    public static int configVersion = 2;
    @MidnightConfig.Comment(category="screens", centered=true)
    public static MidnightConfig.Comment _general;
    @MidnightConfig.Entry(category="screens")
    public static boolean blurContainers;
    @MidnightConfig.Entry(category="screens")
    public static boolean blurTitleScreen;
    @MidnightConfig.Condition(requiredOption="blurTitleScreen", visibleButLocked=true)
    @MidnightConfig.Entry(category="screens")
    public static boolean darkenTitleScreen;
    @MidnightConfig.Comment(category="screens", centered=true)
    public static MidnightConfig.Comment _advanced;
    @MidnightConfig.Entry(category="screens")
    public static List<String> excludedScreens;
    @MidnightConfig.Entry(category="screens")
    public static List<String> forceEnabledScreens;
    @MidnightConfig.Entry(category="screens")
    public static List<String> forceDisabledScreens;
    @MidnightConfig.Comment(category="style", centered=true)
    public static MidnightConfig.Comment _gradient;
    @MidnightConfig.Entry(category="style")
    public static boolean useGradient;
    @MidnightConfig.Condition(requiredOption="useGradient", visibleButLocked=true)
    @MidnightConfig.Entry(category="style", isColor=true, width=7, min=7.0)
    public static String gradientStart;
    @MidnightConfig.Condition(requiredOption="useGradient", visibleButLocked=true)
    @MidnightConfig.Entry(category="style", isSlider=true, min=0.0, max=255.0)
    public static int gradientStartAlpha;
    @MidnightConfig.Condition(requiredOption="useGradient", visibleButLocked=true)
    @MidnightConfig.Entry(category="style", isColor=true, width=7, min=7.0)
    public static String gradientEnd;
    @MidnightConfig.Condition(requiredOption="useGradient", visibleButLocked=true)
    @MidnightConfig.Entry(category="style", isSlider=true, min=0.0, max=255.0)
    public static int gradientEndAlpha;
    @MidnightConfig.Condition(requiredOption="useGradient", visibleButLocked=true)
    @MidnightConfig.Entry(category="style", isSlider=true, min=0.0, max=360.0)
    public static int gradientRotation;
    @MidnightConfig.Entry(category="style")
    public static boolean rainbowMode;
    @MidnightConfig.Comment(category="animations", centered=true)
    public static MidnightConfig.Comment _animations;
    @MidnightConfig.Entry(category="animations", min=0.0, max=2000.0, isSlider=true)
    public static int fadeTimeMillis;
    @MidnightConfig.Entry(category="animations", min=0.0, max=2000.0, isSlider=true)
    public static int fadeOutTimeMillis;
    @MidnightConfig.Entry(category="animations")
    public static Easing animationCurve;
    private static Options options;

    public void onTabInit(String tabName, MidnightConfigListWidget list, MidnightConfigScreen screen) {
        options = Minecraft.getInstance().options;
        if (Objects.equals(tabName, STYLE)) {
            EntryInfo centered = new EntryInfo(null, "blur");
            centered.comment = new MidnightConfig.Comment(this){

                public boolean centered() {
                    return true;
                }

                public Class<? extends Annotation> annotationType() {
                    return null;
                }

                public String category() {
                    return "";
                }

                public String name() {
                    return "";
                }

                public String url() {
                    return "";
                }

                public String requiredMod() {
                    return "";
                }
            };
            RadiusSliderWidget slider = new RadiusSliderWidget(screen.width - 185, 0, 150, 20);
            SpriteIconButton resetButton = SpriteIconButton.builder((Component)Component.translatable((String)"controls.reset"), button -> {
                options.menuBackgroundBlurriness().set((Object)5);
                screen.updateList();
            }, (boolean)true).sprite(ResourceLocation.fromNamespaceAndPath((String)"midnightlib", (String)"icon/reset"), 12, 12).size(20, 20).build();
            resetButton.setPosition(screen.width - 205 + 150 + 25, 0);
            slider.resetButton = resetButton;
            slider.updateMessage();
            list.addButton((List)Lists.newArrayList(), (Component)Component.translatable((String)"blur.midnightconfig._blur"), centered);
            list.addButton((List)Lists.newArrayList((Object[])new AbstractWidget[]{slider, resetButton}), (Component)Component.translatable((String)"blur.midnightconfig.radius"), new EntryInfo(null, "blur"));
        }
    }

    static {
        blurContainers = true;
        blurTitleScreen = false;
        darkenTitleScreen = false;
        excludedScreens = Lists.newArrayList((Object[])new String[]{"net.irisshaders.iris.gui.screen.ShaderPackScreen"});
        forceEnabledScreens = Lists.newArrayList((Object[])new String[]{"dev.emi.emi.screen.RecipeScreen"});
        forceDisabledScreens = Lists.newArrayList();
        useGradient = true;
        gradientStart = "#000000";
        gradientStartAlpha = 75;
        gradientEnd = "#000000";
        gradientEndAlpha = 75;
        gradientRotation = 0;
        rainbowMode = false;
        fadeTimeMillis = 300;
        fadeOutTimeMillis = 300;
        animationCurve = Easing.FLAT;
    }

    public static class RadiusSliderWidget
    extends AbstractSliderButton {
        SpriteIconButton resetButton;

        public RadiusSliderWidget(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.empty(), (double)options.getMenuBackgroundBlurriness() / 20.0);
        }

        public void updateMessage() {
            this.setMessage(Component.nullToEmpty((String)String.valueOf(options.getMenuBackgroundBlurriness())));
            if (this.resetButton != null) {
                this.resetButton.active = options.getMenuBackgroundBlurriness() != 5;
            }
        }

        public void applyValue() {
            options.menuBackgroundBlurriness().set((Object)Double.valueOf(this.value * 20.0).intValue());
        }
    }

    public static enum Easing {
        FLAT(x -> x, x -> x),
        SINE(x -> 1.0 - Math.cos(x * Math.PI) / 2.0, x -> Math.sin(x * Math.PI) / 2.0),
        QUAD(x -> x * x, x -> 1.0 - (1.0 - x) * (1.0 - x)),
        CUBIC(x -> x * x * x, x -> 1.0 - Math.pow(1.0 - x, 3.0)),
        QUART(x -> x * x * x * x, x -> 1.0 - Math.pow(1.0 - x, 4.0)),
        QUINT(x -> x * x * x * x * x, x -> 1.0 - Math.pow(1.0 - x, 5.0)),
        EXPO(x -> x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0), x -> x == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * x)),
        CIRC(x -> 1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0)), x -> Math.sqrt(1.0 - Math.pow(x - 1.0, 2.0))),
        BACK(x -> 2.70158 * x * x * x - 1.70158 * x * x, x -> 1.0 + 2.70158 * Math.pow(x - 1.0, 3.0) + 1.70158 * Math.pow(x - 1.0, 2.0)),
        ELASTIC(x -> x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * x - 10.0) * Math.sin((x * 10.0 - 10.75) * 2.0943951023931953)), x -> x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * 2.0943951023931953) + 1.0));

        final Function<Double, Number> functionIn;
        final Function<Double, Number> functionOut;

        private Easing(Function<Double, Number> functionIn, Function<Double, Number> functionOut) {
            this.functionIn = functionIn;
            this.functionOut = functionOut;
        }

        public Double apply(Double x, boolean in) {
            if (in) {
                return this.functionIn.apply(x).doubleValue();
            }
            return this.functionOut.apply(x).doubleValue();
        }
    }
}

