/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.blur.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import eu.midnightdust.blur.Blur;
import eu.midnightdust.blur.BlurInfo;
import eu.midnightdust.blur.config.BlurConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Screen.class})
public abstract class MixinScreen {
    @Shadow
    @Final
    protected Component title;
    @Shadow
    protected Minecraft minecraft;
    @Shadow
    public int width;
    @Shadow
    public int height;

    @Shadow
    protected abstract void renderBlurredBackground(GuiGraphics var1);

    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"})
    public void blur$processScreenChange(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        Blur.onRender();
        Blur.renderFadeout(context, this.width, this.height, this.minecraft);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderBlurredBackground(Lnet/minecraft/client/gui/GuiGraphics;)V"}, cancellable=true)
    public void blur$getBlurEnabled(CallbackInfo ci) {
        if (BlurConfig.forceDisabledScreens.contains(this.getClass().getCanonicalName())) {
            ci.cancel();
            return;
        }
        if (!BlurConfig.excludedScreens.contains(this.getClass().getCanonicalName())) {
            BlurInfo.screenHasBlur = true;
        }
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;renderMenuBackgroundTexture(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/resources/ResourceLocation;IIFFII)V")}, method={"renderMenuBackground(Lnet/minecraft/client/gui/GuiGraphics;IIII)V"})
    private void blur$applyGradient(GuiGraphics context, ResourceLocation texture, int x, int y, float u, float v, int width, int height, Operation<Void> original) {
        if (BlurConfig.useGradient) {
            this.blur$renderGradient(context);
        } else {
            original.call(new Object[]{context, texture, x, y, Float.valueOf(u), Float.valueOf(v), width, height});
        }
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fillGradient(IIIIII)V")}, method={"renderTransparentBackground(Lnet/minecraft/client/gui/GuiGraphics;)V"})
    public void blur$rotatedGradient(GuiGraphics context, int startX, int startY, int endX, int endY, int colorStart, int colorEnd, Operation<Void> original) {
        this.blur$renderGradient(context);
    }

    @Unique
    private void blur$renderGradient(GuiGraphics context) {
        BlurInfo.screenHasBackground = true;
        if (BlurConfig.forceEnabledScreens.contains(this.getClass().getCanonicalName())) {
            this.renderBlurredBackground(context);
        }
        Blur.renderRotatedGradient(context, this.width, this.height);
    }
}

