/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_3728;
import net.minecraft.class_7530;
import net.minecraft.class_7533;
import net.minecraft.class_8029;
import net.replaceitem.symbolchat.mixin.MultilineTextFieldAccessor;
import net.replaceitem.symbolchat.mixin.widget.EditBoxAccessor;
import org.jetbrains.annotations.Nullable;

public interface SymbolSuggestable {
    public static final Pattern SUGGESTION_PATTERN = Pattern.compile("(?<=\\s|^):(\\S+)$", 8);
    public static final Pattern SEPERATION_PATTERN = Pattern.compile("[_\\-,.+ ]");

    public class_8029 getCursorPosition();

    @Nullable
    public String getSuggestionTerm();

    public void replaceSuggestion(String var1);

    default public boolean suggestionsDisabled() {
        return false;
    }

    @Nullable
    public static MatchResult getSuggestionArea(String text, int cursor) {
        Matcher matcher = SUGGESTION_PATTERN.matcher(text).region(0, cursor);
        if (!matcher.find()) {
            return null;
        }
        return matcher.toMatchResult();
    }

    public static String getSuggestionSearch(MatchResult result) {
        return SEPERATION_PATTERN.matcher(result.group(1)).replaceAll(" ");
    }

    public static interface EditBoxSymbolSuggestable
    extends SymbolSuggestable {
        @Override
        default public String getSuggestionTerm() {
            if (this.suggestionsDisabled()) {
                return null;
            }
            if (this.getMultilineTextField().method_44435()) {
                return null;
            }
            int cursor = this.getMultilineTextField().method_44424();
            String string = this.getMultilineTextField().method_44421();
            MatchResult suggestionArea = SymbolSuggestable.getSuggestionArea(string, cursor);
            if (suggestionArea == null) {
                return null;
            }
            return SymbolSuggestable.getSuggestionSearch(suggestionArea);
        }

        @Override
        default public void replaceSuggestion(String symbol) {
            if (this.getMultilineTextField().method_44435()) {
                return;
            }
            int cursor = this.getMultilineTextField().method_44424();
            String string = this.getMultilineTextField().method_44421();
            MatchResult suggestionArea = SymbolSuggestable.getSuggestionArea(string, cursor);
            if (suggestionArea == null) {
                return;
            }
            this.getMultilineTextField().method_44412(class_7533.field_39535, suggestionArea.start());
            ((MultilineTextFieldAccessor)this.getMultilineTextField()).setSelectCursor(suggestionArea.end());
            this.getMultilineTextField().method_44420(symbol);
        }

        public class_7530 getMultilineTextField();
    }

    public static interface SelectionManagerSymbolSuggestable
    extends SymbolSuggestable {
        @Override
        default public String getSuggestionTerm() {
            if (this.suggestionsDisabled()) {
                return null;
            }
            if (this.getTextFieldHelper().method_27568()) {
                return null;
            }
            int cursor = this.getTextFieldHelper().method_16201();
            String string = this.getText();
            MatchResult suggestionArea = SymbolSuggestable.getSuggestionArea(string, cursor);
            if (suggestionArea == null) {
                return null;
            }
            return SymbolSuggestable.getSuggestionSearch(suggestionArea);
        }

        @Override
        default public void replaceSuggestion(String symbol) {
            if (this.getTextFieldHelper().method_27568()) {
                return;
            }
            int cursor = this.getTextFieldHelper().method_16201();
            String string = this.getText();
            MatchResult suggestionArea = SymbolSuggestable.getSuggestionArea(string, cursor);
            if (suggestionArea == null) {
                return;
            }
            this.getTextFieldHelper().method_27548(suggestionArea.start(), suggestionArea.end());
            this.getTextFieldHelper().method_16197(symbol);
        }

        public String getText();

        public class_3728 getTextFieldHelper();
    }

    public static interface TextFieldWidgetSymbolSuggestable
    extends SymbolSuggestable {
        @Override
        default public class_8029 getCursorPosition() {
            class_342 chatField = this.getTextField();
            int x = chatField.method_46426() + chatField.method_1889(chatField.method_1881()) - chatField.method_1889(((EditBoxAccessor)chatField).getDisplayPos());
            x = class_3532.method_15340((int)x, (int)0, (int)(chatField.method_1889(0) + chatField.method_1859()));
            return new class_8029(x, chatField.method_46427());
        }

        @Override
        default public String getSuggestionTerm() {
            if (this.suggestionsDisabled()) {
                return null;
            }
            class_342 chatField = this.getTextField();
            if (((EditBoxAccessor)chatField).getCursorPos() != ((EditBoxAccessor)chatField).getHighlightPos()) {
                return null;
            }
            MatchResult suggestionArea = TextFieldWidgetSymbolSuggestable.getSuggestionArea(chatField);
            if (suggestionArea == null) {
                return null;
            }
            return SymbolSuggestable.getSuggestionSearch(suggestionArea);
        }

        @Override
        default public void replaceSuggestion(String symbol) {
            class_342 textFieldWidget = this.getTextField();
            MatchResult suggestionArea = TextFieldWidgetSymbolSuggestable.getSuggestionArea(textFieldWidget);
            if (suggestionArea == null) {
                return;
            }
            textFieldWidget.method_1875(suggestionArea.start());
            textFieldWidget.method_1884(suggestionArea.end());
            textFieldWidget.method_1867(symbol);
        }

        @Nullable
        public static MatchResult getSuggestionArea(class_342 textFieldWidget) {
            return SymbolSuggestable.getSuggestionArea(textFieldWidget.method_1882(), textFieldWidget.method_1881());
        }

        public class_342 getTextField();
    }
}

