/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.ibm.icu.lang.UCharacter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7654;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.resource.SymbolList;
import net.replaceitem.symbolchat.resource.SymbolTab;
import org.jetbrains.annotations.NotNull;

public class SymbolManager
implements SimpleSynchronousResourceReloadListener {
    public static final class_2960 IDENTIFIER = class_2960.method_60655((String)"symbol-chat", (String)"symbols");
    public static final class_7654 SYMBOLS_FINDER = new class_7654("symbols", ".txt");
    public static final class_7654 SYMBOL_TABS_FINDER = class_7654.method_45114((String)"symbol_tabs");
    private List<SymbolTab> tabs = List.of();
    private List<String> allSymbols = List.of();
    private final HashMap<class_2960, SymbolList> listCache = new HashMap();
    private final SymbolList.Mutable favoritesList = new SymbolList.Mutable(class_2960.method_60655((String)"symbol-chat", (String)"favorites"));
    private final SymbolList.Mutable customKaomojisList = new SymbolList.Mutable(class_2960.method_60655((String)"symbol-chat", (String)"custom_kaomojis"));

    public class_2960 getFabricId() {
        return IDENTIFIER;
    }

    public void method_14491(class_3300 manager) {
        this.listCache.clear();
        this.addCachedList(this.favoritesList);
        this.addCachedList(this.customKaomojisList);
        this.tabs = new ArrayList<SymbolTab>();
        for (Map.Entry identifierListEntry : SYMBOL_TABS_FINDER.method_45113(manager).entrySet()) {
            class_2960 identifier = SYMBOL_TABS_FINDER.method_45115((class_2960)identifierListEntry.getKey());
            class_3298 tabResource = (class_3298)identifierListEntry.getValue();
            try {
                BufferedReader symbolTabReader = tabResource.method_43039();
                try {
                    SymbolTab symbolTab = this.readTab(manager, symbolTabReader, identifier);
                    this.tabs.add(symbolTab);
                }
                finally {
                    if (symbolTabReader == null) continue;
                    symbolTabReader.close();
                }
            }
            catch (JsonParseException | IOException | class_151 e) {
                SymbolChat.LOGGER.error("Could not load symbol tab {}", (Object)identifier, (Object)e);
            }
        }
        this.tabs.sort(SymbolTab::compareTo);
        this.tabs = Collections.unmodifiableList(this.tabs);
        this.allSymbols = this.tabs.stream().flatMap(SymbolTab::streamSymbols).distinct().toList();
    }

    public boolean isFavorite(String symbol) {
        return this.favoritesList.contains(symbol);
    }

    public List<SymbolTab> getTabs() {
        return this.tabs;
    }

    public Optional<SymbolTab> getTab(class_2960 identifier) {
        return this.tabs.stream().filter(tab -> tab.getId().equals((Object)identifier)).findFirst();
    }

    public Stream<String> getFavoriteSymbols() {
        return this.favoritesList.stream();
    }

    public Stream<String> streamAllSymbols() {
        return this.allSymbols.stream().filter(s -> s.codePoints().count() <= 1L);
    }

    @NotNull
    private SymbolTab readTab(class_3300 manager, BufferedReader symbolTabReader, class_2960 identifier) {
        JsonObject object = class_3518.method_15255((Reader)symbolTabReader);
        String icon = class_3518.method_15265((JsonObject)object, (String)"icon");
        int order = class_3518.method_15260((JsonObject)object, (String)"order");
        SymbolTab.Type type = SymbolTab.Type.getOrDefault(class_3518.method_15253((JsonObject)object, (String)"type", null), SymbolTab.Type.SYMBOLS);
        boolean searchBar = class_3518.method_15258((JsonObject)object, (String)"search_bar", (boolean)false);
        JsonArray symbolFiles = class_3518.method_15292((JsonObject)object, (String)"symbols", (JsonArray)new JsonArray(0));
        List<SymbolList> symbols = this.readSymbolLists(manager, symbolFiles);
        return new SymbolTab(identifier, icon, order, type, searchBar, symbols);
    }

    @NotNull
    private List<SymbolList> readSymbolLists(class_3300 manager, JsonArray symbolFiles) {
        ArrayList<SymbolList> symbols = new ArrayList<SymbolList>();
        for (JsonElement symbolFile : symbolFiles) {
            SymbolList.SplitType type;
            class_2960 identifier;
            if (symbolFile instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)symbolFile;
                identifier = class_2960.method_60654((String)primitive.getAsString());
                type = SymbolList.SplitType.CODEPOINT;
            } else {
                if (!(symbolFile instanceof JsonObject)) continue;
                JsonObject object = (JsonObject)symbolFile;
                identifier = class_2960.method_60654((String)class_3518.method_15265((JsonObject)object, (String)"id"));
                type = SymbolList.SplitType.getOrDefault(class_3518.method_15253((JsonObject)object, (String)"split", null), SymbolList.SplitType.CODEPOINT);
            }
            try {
                symbols.add(this.readSymbolList(manager, identifier, type));
            }
            catch (JsonParseException | IOException e) {
                SymbolChat.LOGGER.error("Could not load symbols {}", (Object)identifier, (Object)e);
            }
        }
        return symbols;
    }

    @NotNull
    private SymbolList readSymbolList(class_3300 manager, class_2960 identifier, SymbolList.SplitType type) throws IOException, JsonParseException {
        if (this.listCache.containsKey(identifier)) {
            return this.listCache.get(identifier);
        }
        try (BufferedReader symbolsReader = manager.openAsReader(SYMBOLS_FINDER.method_45112(identifier));){
            SymbolList symbolList = new SymbolList(identifier, type.split(symbolsReader));
            this.addCachedList(symbolList);
            SymbolList symbolList2 = symbolList;
            return symbolList2;
        }
    }

    private void addCachedList(SymbolList symbolList) {
        this.listCache.put(symbolList.getId(), symbolList);
    }

    public void onCustomSymbolsChanged(String favoriteSymbols) {
        this.favoritesList.clear();
        favoriteSymbols.codePoints().mapToObj(UCharacter::toString).forEach(this.favoritesList::addSymbol);
    }

    public void onCustomKaomojisChanged(List<String> customKaomojis) {
        this.customKaomojisList.clear();
        customKaomojis.forEach(this.customKaomojisList::addSymbol);
    }

    public boolean isOnlyFavorites(SymbolTab tab) {
        return tab.getSymbols().size() == 1 && tab.getSymbols().getFirst() == this.favoritesList;
    }
}

