/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.gui;

import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8662;
import net.minecraft.class_8667;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.UnicodeSearch;
import net.replaceitem.symbolchat.extensions.TextRendererAccess;
import net.replaceitem.symbolchat.gui.widget.IntSpinnerWidget;
import net.replaceitem.symbolchat.gui.widget.UnicodeTable;
import net.replaceitem.symbolchat.mixin.FontManagerAccessor;
import net.replaceitem.symbolchat.mixin.MinecraftClientAccessor;

public class UnicodeTableScreen
extends class_437 {
    private static final class_2960 COPY_TEXTURE = class_2960.method_60655((String)"symbol-chat", (String)"copy");
    private static final class_2960 FAVORITE_TEXTURE = class_2960.method_60655((String)"symbol-chat", (String)"favorite");
    private final class_437 parent;
    private UnicodeTable unicodeTable;
    private class_4185 copySelectedButton;
    private class_4185 favoriteSymbolButton;
    private class_342 searchTextField;
    private IntSpinnerWidget pageSpinner;
    private IntSpinnerWidget widthSpinner;
    private class_4286 hideMissingGlyphsCheckbox;
    public static final int SIDEBAR_WIDTH = 128;
    public static final int SYMBOLS_START_X = 129;

    public UnicodeTableScreen(class_437 parent) {
        super(class_2561.method_30163((String)"Unicode Table"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.unicodeTable = new UnicodeTable(this.field_22793, 129, 0, this.field_22789 - 129, this.field_22790){

            @Override
            protected void onRefreshed() {
                boolean hasSelection = this.hasSelection();
                if (UnicodeTableScreen.this.copySelectedButton != null) {
                    UnicodeTableScreen.this.copySelectedButton.field_22763 = hasSelection;
                }
                if (UnicodeTableScreen.this.favoriteSymbolButton != null) {
                    UnicodeTableScreen.this.favoriteSymbolButton.field_22763 = hasSelection;
                }
            }
        };
        this.method_37063((class_364)this.unicodeTable);
        int widgetWidth = 124;
        class_8667 adder = new class_8667(2, 2, class_8667.class_8668.field_45404);
        adder.method_52735(4);
        class_8667 buttonRow = (class_8667)adder.method_52736((class_8021)new class_8667(0, 0, class_8667.class_8668.field_45403));
        this.copySelectedButton = class_8662.method_52723((class_2561)class_5244.field_39003, button -> this.unicodeTable.copySelected(), (boolean)true).method_52727(COPY_TEXTURE, 16, 16).method_52726(20, 20).method_52724();
        this.copySelectedButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.copy_to_clipboard")));
        buttonRow.method_52736((class_8021)this.copySelectedButton);
        this.favoriteSymbolButton = class_8662.method_52723((class_2561)class_5244.field_39003, button -> this.unicodeTable.favoriteSymbols(), (boolean)true).method_52727(FAVORITE_TEXTURE, 16, 16).method_52726(20, 20).method_52724();
        buttonRow.method_52736((class_8021)this.favoriteSymbolButton);
        this.favoriteSymbolButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.favorite_symbol")));
        adder.method_52736((class_8021)class_7852.method_46513((int)6));
        adder.method_52736((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.view").method_27694(style -> style.method_30938(Boolean.valueOf(true))), this.field_22793));
        adder.method_52736((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.font"), this.field_22793));
        assert (this.field_22787 != null);
        List fonts = ((FontManagerAccessor)((MinecraftClientAccessor)this.field_22787).getFontManager()).getFontStorages().keySet().stream().sorted().toList();
        class_5676 fontButton = class_5676.method_32606(class_2561::method_54154).method_32620(fonts).method_32616().method_32617(0, 0, widgetWidth, 20, (class_2561)class_2561.method_43473(), (button, value) -> {
            this.unicodeTable.setFont((class_2960)value);
            this.reloadSymbols();
        });
        fontButton.method_32605((Object)class_310.field_1740);
        adder.method_52736((class_8021)fontButton);
        class_4286 showBlocksCheckbox = class_4286.method_54787((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.show_blocks"), (class_327)this.field_22793).method_54794(((Boolean)SymbolChat.config.unicodeTableShowBlocks.get()).booleanValue()).method_54791((checkbox, checked) -> {
            SymbolChat.config.unicodeTableShowBlocks.setIfValid((Object)checked);
            this.unicodeTable.setShowBlocks(checked);
        }).method_54788();
        this.unicodeTable.setShowBlocks(showBlocksCheckbox.method_20372());
        adder.method_52736((class_8021)showBlocksCheckbox);
        class_4286 textShadowCheckbox = class_4286.method_54787((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.text_shadow"), (class_327)this.field_22793).method_54794(((Boolean)SymbolChat.config.unicodeTableTextShadow.get()).booleanValue()).method_54791((checkbox, checked) -> {
            SymbolChat.config.unicodeTableTextShadow.setIfValid((Object)checked);
            this.unicodeTable.setRenderTextShadow(checked);
        }).method_54788();
        this.unicodeTable.setRenderTextShadow(textShadowCheckbox.method_20372());
        adder.method_52736((class_8021)textShadowCheckbox);
        class_7842 jumpToLabel = new class_7842((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.jump_to"), this.field_22793);
        class_342 jumpToTextField = new class_342(this.field_22793, widgetWidth - jumpToLabel.method_25368(), 12, (class_2561)class_2561.method_43473()){

            public boolean method_25404(class_11908 input) {
                if (input.method_74230()) {
                    int codepoint;
                    try {
                        codepoint = Integer.parseInt(this.method_1882(), 16);
                    }
                    catch (NumberFormatException e) {
                        return true;
                    }
                    int page = (codepoint & 0xFF0000) >> 16;
                    if (UnicodeTableScreen.this.pageSpinner.getValue().isEmpty() || UnicodeTableScreen.this.pageSpinner.getValue().getAsInt() != page) {
                        UnicodeTableScreen.this.pageSpinner.setValue(page);
                    }
                    UnicodeTableScreen.this.unicodeTable.jumpTo(codepoint);
                    return true;
                }
                return super.method_25404(input);
            }
        };
        jumpToTextField.method_1863(s -> this.reloadSymbols());
        class_7843 jumpToRow = (class_7843)adder.method_52736((class_8021)new class_7843(widgetWidth, 0));
        jumpToRow.method_52732((class_8021)jumpToLabel, class_7847::method_46461);
        jumpToRow.method_52732((class_8021)jumpToTextField, class_7847::method_46470);
        adder.method_52736((class_8021)class_7852.method_46513((int)6));
        adder.method_52736((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.filter").method_27694(style -> style.method_30938(Boolean.valueOf(true))), this.field_22793));
        class_7842 searchLabel = new class_7842((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.search"), this.field_22793);
        this.searchTextField = new class_342(this.field_22793, widgetWidth - searchLabel.method_25368(), 12, (class_2561)class_2561.method_43473());
        this.searchTextField.method_1863(s -> this.reloadSymbols());
        class_7843 searchRow = (class_7843)adder.method_52736((class_8021)new class_7843(widgetWidth, 0));
        searchRow.method_52732((class_8021)searchLabel, class_7847::method_46461);
        searchRow.method_52732((class_8021)this.searchTextField, class_7847::method_46470);
        this.pageSpinner = IntSpinnerWidget.builder(this.field_22793).value(0).min(0).changedListener(optionalInt -> this.reloadSymbols()).build();
        class_7843 pageRow = (class_7843)adder.method_52736((class_8021)new class_7843(widgetWidth, 0));
        pageRow.method_52732((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.page"), this.field_22793), class_7847::method_46461);
        pageRow.method_52732((class_8021)this.pageSpinner, class_7847::method_46470);
        this.widthSpinner = IntSpinnerWidget.builder(this.field_22793).value("").changedListener(optionalInt -> this.reloadSymbols()).build();
        pageRow = (class_7843)adder.method_52736((class_8021)new class_7843(widgetWidth, 0));
        pageRow.method_52732((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.symbol_width"), this.field_22793), class_7847::method_46461);
        pageRow.method_52732((class_8021)this.widthSpinner, class_7847::method_46470);
        this.hideMissingGlyphsCheckbox = class_4286.method_54787((class_2561)class_2561.method_43471((String)"symbolchat.unicode_table.hide_missing_glyphs"), (class_327)this.field_22793).method_54794(((Boolean)SymbolChat.config.unicodeTableHideMissingGlyphs.get()).booleanValue()).method_54791((checkbox, checked) -> {
            SymbolChat.config.unicodeTableHideMissingGlyphs.setIfValid((Object)checked);
            this.reloadSymbols();
        }).method_54788();
        adder.method_52736((class_8021)this.hideMissingGlyphsCheckbox);
        adder.method_48222();
        adder.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.reloadSymbols();
    }

    private void reloadSymbols() {
        OptionalInt page = this.pageSpinner.getValue();
        UnicodeSearch search = page.isPresent() ? UnicodeSearch.ofPage(page.getAsInt()) : UnicodeSearch.ofAll();
        search = search.search(this.searchTextField.method_1882());
        OptionalInt width = this.widthSpinner.getValue();
        if (width.isPresent()) {
            IntUnaryOperator codepointWidthGetter = ((TextRendererAccess)this.field_22793).getCodepointWidthGetter(this.unicodeTable.getStyle());
            search = search.filterWidth(width.getAsInt(), codepointWidthGetter);
        }
        if (this.hideMissingGlyphsCheckbox.method_20372()) {
            search = search.filter(((TextRendererAccess)this.field_22793).getMissingGlyphPredicate(this.unicodeTable.getStyle()).negate());
        }
        this.unicodeTable.setCodepoints(search.collect());
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -13619152);
        context.method_51742(128, -1, this.field_22790, -1);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }
}

