/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.gui.widget;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.replaceitem.symbolchat.SearchUtil;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.gui.SymbolSelectionPanel;
import net.replaceitem.symbolchat.gui.container.NonScrollableContainerWidget;
import net.replaceitem.symbolchat.gui.container.ScrollableGridContainer;
import net.replaceitem.symbolchat.gui.container.SmoothScrollableContainerWidget;
import net.replaceitem.symbolchat.gui.widget.SymbolSearchBar;
import net.replaceitem.symbolchat.gui.widget.symbolButton.PasteSymbolButtonWidget;
import net.replaceitem.symbolchat.resource.SymbolTab;
import org.jetbrains.annotations.Nullable;

public class SymbolTabWidget
extends NonScrollableContainerWidget
implements PasteSymbolButtonWidget.Context {
    private static final int SEARCH_BAR_HEIGHT = 10;
    public static final class_2561 NO_RESULTS = class_2561.method_43471((String)"symbolchat.symbol_panel.no_search_results");
    public static final class_2561 NO_FAVORITE_SYMBOLS = class_2561.method_43471((String)"symbolchat.symbol_panel.no_favorite_symbols");
    private final SymbolSelectionPanel symbolSelectionPanel;
    @Nullable
    private class_2561 emptyText;
    protected final SymbolTab tab;
    @Nullable
    private SymbolSearchBar searchBar;
    protected final ScrollableGridContainer scrollableWidget;

    public SymbolTabWidget(int x, int y, int width, int height, SymbolTab symbolTab, SymbolSelectionPanel symbolSelectionPanel, int panelColumns) {
        super(x, y, width, height);
        this.tab = symbolTab;
        this.symbolSelectionPanel = symbolSelectionPanel;
        int columns = this.tab.getType().getColumns(panelColumns);
        int offset = this.tab.hasSearchBar() ? 12 : 0;
        this.scrollableWidget = new ScrollableGridContainer(this.method_46426() + 1, this.method_46427() + offset, this.method_25368() - 1, this.method_25364() - offset, columns);
        this.scrollableWidget.setSmoothScrolling(true);
        this.scrollableWidget.setScrollbarStyle(SmoothScrollableContainerWidget.ScrollbarStyle.SLIM);
        this.addChildren((class_339)this.scrollableWidget);
        if (this.tab.hasSearchBar()) {
            this.searchBar = new SymbolSearchBar(this.method_46426() + 2, this.method_46427() + 1, this.method_25368() - 4, 10);
            this.searchBar.method_1863(s -> this.refresh());
            this.addChildren((class_339)this.searchBar);
        }
        this.refresh();
    }

    @Override
    public void onSymbolClicked(String symbol) {
        this.symbolSelectionPanel.getSymbolInsertable().insertSymbol(symbol);
    }

    @Override
    public void refresh() {
        this.scrollableWidget.clearElements();
        this.addSymbols();
        this.scrollableWidget.refreshPositions();
    }

    protected void addSymbols() {
        Stream<String> stream = this.tab.streamSymbols();
        if (this.searchBar != null) {
            stream = SearchUtil.performSearch(stream, this.searchBar.method_1882());
        }
        List<PasteSymbolButtonWidget> buttons = stream.map(this::createButton).toList();
        buttons.forEach(this.scrollableWidget::add);
        this.emptyText = this.getEmptyText(buttons.isEmpty());
    }

    private class_2561 getEmptyText(boolean noSymbols) {
        if (!noSymbols) {
            return null;
        }
        if (SymbolChat.symbolManager.isOnlyFavorites(this.tab)) {
            return NO_FAVORITE_SYMBOLS;
        }
        return NO_RESULTS;
    }

    protected PasteSymbolButtonWidget createButton(String symbol) {
        SymbolTab.Type type = this.tab.getType();
        PasteSymbolButtonWidget pasteSymbolButtonWidget = new PasteSymbolButtonWidget(this.method_46426(), this.method_46427(), this, symbol);
        if (type.hasFullWidthButtons()) {
            pasteSymbolButtonWidget.method_25358(this.method_25368() - 2 - SmoothScrollableContainerWidget.ScrollbarStyle.SLIM.getWidth());
        }
        if (!type.hasTooltip()) {
            pasteSymbolButtonWidget.method_47400(null);
        }
        return pasteSymbolButtonWidget;
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_48579(drawContext, mouseX, mouseY, delta);
        if (this.emptyText != null) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            List orderedTexts = textRenderer.method_1728((class_5348)this.emptyText, this.field_22758 - 4);
            int centerX = this.method_46426() + this.method_25368() / 2;
            int n = this.method_46427() + this.method_25364() / 2;
            int n2 = orderedTexts.size();
            Objects.requireNonNull(textRenderer);
            int startY = n - n2 * 9 / 2;
            for (int i = 0; i < orderedTexts.size(); ++i) {
                class_5481 orderedText = (class_5481)orderedTexts.get(i);
                Objects.requireNonNull(textRenderer);
                int dy = startY + i * 9;
                drawContext.method_51430(textRenderer, orderedText, centerX - textRenderer.method_30880(orderedText) / 2, dy, 0x66FFFFFF, false);
            }
        }
    }
}

