/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.mixin.widget;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_342;
import net.replaceitem.symbolchat.extensions.SymbolEditableWidget;
import net.replaceitem.symbolchat.resource.FontProcessor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_342.class})
public class TextFieldWidgetMixin
implements SymbolEditableWidget {
    @Shadow
    private int field_2102;
    @Shadow
    private int field_2101;
    @Shadow
    private String field_2092;
    @Unique
    @Nullable
    private Supplier<FontProcessor> fontProcessorSupplier;
    @Unique
    @Nullable
    private @Nullable BiFunction<String, @Nullable String, Boolean> convertFontsPredicate;
    @Unique
    @Nullable
    private Runnable refreshSuggestions;
    @Unique
    private boolean lastReverseDirection;

    @Inject(method={"write"}, at={@At(value="HEAD")})
    private void beforeWrite(String text, CallbackInfo ci, @Local(argsOnly=true) LocalRef<String> textRef) {
        this.lastReverseDirection = false;
        if (this.convertFontsPredicate == null || this.convertFontsPredicate.apply(this.field_2092, text).booleanValue()) {
            FontProcessor fontProcessor;
            FontProcessor fontProcessor2 = fontProcessor = this.fontProcessorSupplier == null ? null : this.fontProcessorSupplier.get();
            if (fontProcessor != null) {
                textRef.set((Object)fontProcessor.convertString(text));
                this.lastReverseDirection = fontProcessor.isReverseDirection();
            }
        }
    }

    @ModifyArg(method={"write"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;setSelectionStart(I)V"))
    private int modifySelectionStart(int cursor) {
        if (this.lastReverseDirection) {
            return Math.min(this.field_2102, this.field_2101);
        }
        return cursor;
    }

    @Inject(method={"setSelectionEnd"}, at={@At(value="RETURN")})
    private void afterSetSelectionEnd(int cursor, CallbackInfo ci) {
        if (this.refreshSuggestions != null) {
            this.refreshSuggestions.run();
        }
    }

    @Override
    public void setFontProcessorSupplier(@Nullable Supplier<FontProcessor> fontProcessorSupplier) {
        this.fontProcessorSupplier = fontProcessorSupplier;
    }

    @Override
    public void setConvertFontsPredicate(@Nullable @Nullable BiFunction<String, @Nullable String, Boolean> convertFontsPredicate) {
        this.convertFontsPredicate = convertFontsPredicate;
    }

    @Override
    public void setRefreshSuggestions(@Nullable Runnable refreshSuggestions) {
        this.refreshSuggestions = refreshSuggestions;
    }
}

