/*
 * Decompiled with CFR 0.152.
 */
package com.roklenarcic.util.strings;

import com.roklenarcic.util.strings.Queue;
import com.roklenarcic.util.strings.SetMatchListener;
import com.roklenarcic.util.strings.StringSet;
import com.roklenarcic.util.strings.threshold.RangeNodeThreshold;
import com.roklenarcic.util.strings.threshold.Thresholder;
import java.util.Arrays;

public class AhoCorasickSet
implements StringSet {
    private boolean caseSensitive = true;
    private TrieNode root = new HashmapNode(true);

    public AhoCorasickSet(Iterable<String> keywords, boolean caseSensitive) {
        this(keywords, caseSensitive, new RangeNodeThreshold());
    }

    public AhoCorasickSet(Iterable<String> keywords, boolean caseSensitive, final Thresholder thresholdStrategy) {
        this.caseSensitive = caseSensitive;
        for (String keyword : keywords) {
            if (keyword == null || keyword.length() <= 0) continue;
            HashmapNode currentNode = (HashmapNode)this.root;
            for (int idx = 0; idx < keyword.length(); ++idx) {
                currentNode = currentNode.getOrAddChild(caseSensitive ? keyword.charAt(idx) : Character.toLowerCase(keyword.charAt(idx)));
            }
            currentNode.matchLength = keyword.length();
        }
        final Queue<TrieNode> queue = new Queue<TrieNode>();
        this.root = this.root.optimizeNode(0, thresholdStrategy);
        queue.push(this.root);
        queue.push(null);
        final int[] level = new int[]{1};
        EntryVisitor failTransAndOutputsVisitor = new EntryVisitor(){

            @Override
            public void visit(TrieNode parent, char key, TrieNode value) {
                value = value.optimizeNode(level[0], thresholdStrategy);
                parent.updateTransition(key, value);
                TrieNode parentFail = parent.getFailTransition();
                if (parentFail == null) {
                    value.failTransition = parent;
                } else {
                    do {
                        TrieNode matchContinuation;
                        if ((matchContinuation = parentFail.getTransition(key)) != null) {
                            value.failTransition = matchContinuation;
                            continue;
                        }
                        parentFail = parentFail.getFailTransition();
                    } while (value.failTransition == null);
                    TrieNode fail = value.failTransition;
                    while (fail != AhoCorasickSet.this.root && fail.matchLength == 0) {
                        fail = fail.failTransition;
                    }
                    if (fail.matchLength > 0) {
                        if (value.matchLength == 0) {
                            value.matchLength = fail.matchLength;
                            value.suffixMatch = fail.suffixMatch;
                        } else {
                            value.suffixMatch = fail;
                        }
                    }
                }
                if (!value.isEmpty()) {
                    queue.push(value);
                }
            }
        };
        while (!queue.isEmpty()) {
            TrieNode n = (TrieNode)queue.take();
            if (n == null) {
                if (queue.isEmpty()) continue;
                queue.push(null);
                level[0] = level[0] + 1;
                continue;
            }
            n.mapEntries(failTransAndOutputsVisitor);
        }
        EntryVisitor enqueueNodesVisitor = new EntryVisitor(){

            @Override
            public void visit(TrieNode parent, char key, TrieNode value) {
                if (!value.isEmpty()) {
                    queue.push(value);
                }
            }
        };
        this.root.mapEntries(enqueueNodesVisitor);
        while (!queue.isEmpty()) {
            TrieNode node = (TrieNode)queue.pop();
            if (node == null) {
                node = (TrieNode)queue.pop();
                if (!(node instanceof RangeNode)) continue;
                RangeNode rangeNode = (RangeNode)node;
                block4: for (int i = 0; i < rangeNode.size; ++i) {
                    if (rangeNode.children[i] != null) continue;
                    char charOfMissingTransition = (char)(rangeNode.baseChar + i);
                    TrieNode n = rangeNode.failTransition;
                    while (n != null) {
                        TrieNode nextNode = n.getTransition(charOfMissingTransition);
                        if (nextNode == null) {
                            n = n.failTransition;
                            continue;
                        }
                        ((RangeNode)rangeNode).children[i] = nextNode;
                        continue block4;
                    }
                }
                continue;
            }
            queue.push(null);
            node.mapEntries(enqueueNodesVisitor);
        }
    }

    @Override
    public void match(String haystack, SetMatchListener listener) {
        TrieNode currentNode = this.root;
        int idx = 0;
        int len = haystack.length();
        if (this.caseSensitive) {
            while (idx < len) {
                char c = haystack.charAt(idx);
                TrieNode nextNode = currentNode.getTransition(c);
                while (nextNode == null) {
                    currentNode = currentNode.getFailTransition();
                    nextNode = currentNode.getTransition(c);
                }
                currentNode = nextNode;
                if (currentNode.output(haystack, listener, ++idx)) continue;
                break;
            }
        } else {
            while (idx < len) {
                char c = Character.toLowerCase(haystack.charAt(idx));
                TrieNode nextNode = currentNode.getTransition(c);
                while (nextNode == null) {
                    currentNode = currentNode.getFailTransition();
                    nextNode = currentNode.getTransition(c);
                }
                currentNode = nextNode;
                if (currentNode.output(haystack, listener, ++idx)) continue;
                break;
            }
        }
    }

    private static abstract class TrieNode {
        protected TrieNode defaultTransition = null;
        protected TrieNode failTransition;
        protected int matchLength = 0;
        protected TrieNode suffixMatch;

        protected TrieNode(boolean root) {
            this.defaultTransition = root ? this : null;
        }

        public final TrieNode getFailTransition() {
            return this.failTransition;
        }

        public abstract TrieNode getTransition(char var1);

        public abstract boolean isEmpty();

        public abstract void mapEntries(EntryVisitor var1);

        public final boolean output(String haystack, SetMatchListener listener, int idx) {
            boolean ret = true;
            if (this.matchLength > 0) {
                ret = listener.match(haystack, idx - this.matchLength, idx);
                TrieNode suffixMatch = this.suffixMatch;
                while (suffixMatch != null && ret) {
                    ret = listener.match(haystack, idx - suffixMatch.matchLength, idx);
                    suffixMatch = suffixMatch.suffixMatch;
                }
            }
            return ret;
        }

        public abstract void updateTransition(char var1, TrieNode var2);

        protected TrieNode optimizeNode(int level, Thresholder thresholdStrategy) {
            return this;
        }
    }

    private static final class RangeNode
    extends TrieNode {
        private char baseChar = '\u0000';
        private TrieNode[] children;
        private int size = 0;

        private RangeNode(HashmapNode oldNode, char from, char to) {
            super(oldNode.defaultTransition != null);
            this.baseChar = from;
            this.size = to - from + 1;
            this.matchLength = oldNode.matchLength;
            if (this.size <= 0) {
                this.size = 0;
            } else {
                this.children = new TrieNode[this.size];
                if (oldNode.defaultTransition != null) {
                    Arrays.fill(this.children, this);
                }
                for (int i = 0; i < oldNode.children.length; ++i) {
                    if (oldNode.children[i] == null) continue;
                    this.children[((HashmapNode)oldNode).keys[i] - from] = oldNode.children[i];
                }
            }
        }

        @Override
        public TrieNode getTransition(char c) {
            char idx = (char)(c - this.baseChar);
            if (idx < this.size) {
                return this.children[idx];
            }
            return this.defaultTransition;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public void mapEntries(EntryVisitor visitor) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null || this.children[i] == this) continue;
                    visitor.visit(this, (char)(this.baseChar + i), this.children[i]);
                }
            }
        }

        @Override
        public void updateTransition(char c, TrieNode node) {
            char idx = (char)(c - this.baseChar);
            if (idx < this.size) {
                if (this.children[idx] != null) {
                    this.children[idx] = node;
                    return;
                }
                throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
            }
            throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
        }
    }

    private static final class HashmapNode
    extends TrieNode {
        private TrieNode[] children = new TrieNode[1];
        private char[] keys = new char[1];
        private int modulusMask = this.keys.length - 1;
        private int numEntries = 0;

        protected HashmapNode(boolean root) {
            super(root);
        }

        @Override
        public TrieNode getTransition(char key) {
            int defaultSlot;
            int currentSlot = defaultSlot = this.hash(key) & this.modulusMask;
            do {
                if (this.keys[currentSlot] == key) {
                    return this.children[currentSlot];
                }
                if (this.children[currentSlot] == null) {
                    return this.defaultTransition;
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            return this.defaultTransition;
        }

        @Override
        public boolean isEmpty() {
            return this.numEntries == 0;
        }

        @Override
        public void mapEntries(EntryVisitor visitor) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.children[i] == null) continue;
                visitor.visit(this, this.keys[i], this.children[i]);
            }
        }

        @Override
        public void updateTransition(char c, TrieNode node) {
            int defaultSlot;
            int currentSlot = defaultSlot = this.hash(c) & this.modulusMask;
            do {
                if (this.children[currentSlot] == null) {
                    throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
                }
                if (this.keys[currentSlot] == c) {
                    this.children[currentSlot] = node;
                    return;
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
        }

        @Override
        protected TrieNode optimizeNode(int level, Thresholder thresholdStrategy) {
            char minKey = '\uffff';
            char maxKey = '\u0000';
            int size = this.numEntries;
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (this.keys[i] > maxKey) {
                    maxKey = this.keys[i];
                }
                if (this.keys[i] >= minKey) continue;
                minKey = this.keys[i];
            }
            int keyIntervalSize = maxKey - minKey + 1;
            if (this.defaultTransition != null || thresholdStrategy.isOverThreshold(size, level, keyIntervalSize)) {
                return new RangeNode(this, minKey, maxKey);
            }
            return this;
        }

        private void enlarge() {
            char[] biggerKeys = new char[this.keys.length * 2];
            TrieNode[] biggerChildren = new TrieNode[this.children.length * 2];
            int biggerMask = biggerKeys.length - 1;
            block0: for (int i = 0; i < this.children.length; ++i) {
                int defaultSlot;
                char key = this.keys[i];
                TrieNode node = this.children[i];
                if (node == null) continue;
                int currentSlot = defaultSlot = this.hash(key) & biggerMask;
                do {
                    if (biggerChildren[currentSlot] == null) {
                        biggerKeys[currentSlot] = key;
                        biggerChildren[currentSlot] = node;
                        continue block0;
                    }
                    if (biggerKeys[currentSlot] == key) {
                        throw new IllegalStateException();
                    }
                    ++currentSlot;
                } while ((currentSlot &= biggerMask) != defaultSlot);
            }
            this.keys = biggerKeys;
            this.children = biggerChildren;
            this.modulusMask = biggerMask;
        }

        private HashmapNode getOrAddChild(char key) {
            int defaultSlot;
            if (this.keys.length < 65536 && (this.numEntries >= this.keys.length || this.numEntries > 16 && (float)this.numEntries >= (float)this.keys.length * 0.9f)) {
                this.enlarge();
            }
            int currentSlot = defaultSlot = this.hash(key) & this.modulusMask;
            do {
                if (this.children[currentSlot] == null) {
                    this.keys[currentSlot] = key;
                    HashmapNode newChild = new HashmapNode(false);
                    this.children[currentSlot] = newChild;
                    ++this.numEntries;
                    return newChild;
                }
                if (this.keys[currentSlot] == key) {
                    return (HashmapNode)this.children[currentSlot];
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            throw new IllegalStateException();
        }

        private int hash(char c) {
            int HASH_PRIME = 16777619;
            return ((0x811C9DC5 ^ c >> 8) * 16777619 ^ c & 0xFF) * 16777619;
        }
    }

    private static interface EntryVisitor {
        public void visit(TrieNode var1, char var2, TrieNode var3);
    }
}

