/*
 * Decompiled with CFR 0.152.
 */
package com.roklenarcic.util.strings;

import com.roklenarcic.util.strings.MapMatchListener;
import com.roklenarcic.util.strings.ReadableMatchListener;

class MapMatchQueue<T> {
    private int emptySlotIdx = 0;
    private int[] endIndexes = new int[2];
    private int[] startIndexes = new int[2];
    private Object[] values = new Object[2];

    MapMatchQueue() {
    }

    public void clear() {
        this.emptySlotIdx = 0;
    }

    public boolean isEmpty() {
        return this.emptySlotIdx == 0;
    }

    public boolean matchAndClear(ReadableMatchListener<T> listener, int purgeToIndex) {
        if (!this.isEmpty()) {
            int i;
            for (i = 0; i < this.emptySlotIdx && this.endIndexes[i] <= purgeToIndex; ++i) {
                if (listener.match(this.values[i])) continue;
                return false;
            }
            if (i > 0) {
                this.emptySlotIdx -= i;
                System.arraycopy(this.endIndexes, i, this.endIndexes, 0, this.emptySlotIdx);
                System.arraycopy(this.startIndexes, i, this.startIndexes, 0, this.emptySlotIdx);
                System.arraycopy(this.values, i, this.values, 0, this.emptySlotIdx);
            }
        }
        return true;
    }

    public boolean matchAndClear(String haystack, MapMatchListener<T> listener, int purgeToIndex) {
        if (!this.isEmpty()) {
            int i;
            for (i = 0; i < this.emptySlotIdx && this.endIndexes[i] <= purgeToIndex; ++i) {
                if (listener.match(haystack, this.startIndexes[i], this.endIndexes[i], this.values[i])) continue;
                return false;
            }
            if (i > 0) {
                this.emptySlotIdx -= i;
                System.arraycopy(this.endIndexes, i, this.endIndexes, 0, this.emptySlotIdx);
                System.arraycopy(this.startIndexes, i, this.startIndexes, 0, this.emptySlotIdx);
                System.arraycopy(this.values, i, this.values, 0, this.emptySlotIdx);
            }
        }
        return true;
    }

    public boolean push(int length, int idx, T value) {
        if (this.emptySlotIdx + 1 == this.endIndexes.length) {
            int newCapacity = this.endIndexes.length * 2;
            if (newCapacity < 0) {
                newCapacity = 0x7FFFFFF7;
            }
            int[] newArr = new int[newCapacity];
            int[] newStartIndexes = new int[newCapacity];
            Object[] newValues = new Object[newCapacity];
            System.arraycopy(this.endIndexes, 0, newArr, 0, this.emptySlotIdx);
            System.arraycopy(this.startIndexes, 0, newStartIndexes, 0, this.emptySlotIdx);
            System.arraycopy(this.values, 0, newValues, 0, this.emptySlotIdx);
            this.endIndexes = newArr;
            this.startIndexes = newStartIndexes;
            this.values = newValues;
        }
        if (!this.isEmpty()) {
            int idxToFind = idx - length;
            for (int currSlot = this.emptySlotIdx - 1; currSlot >= 0; --currSlot) {
                int currStartIdx = this.startIndexes[currSlot];
                if (idxToFind < currStartIdx) continue;
                if (idxToFind >= this.endIndexes[currSlot]) {
                    this.startIndexes[currSlot + 1] = idxToFind;
                    this.endIndexes[currSlot + 1] = idx;
                    this.values[currSlot + 1] = value;
                    this.emptySlotIdx = currSlot + 2;
                    return true;
                }
                if (idxToFind == currStartIdx && this.endIndexes[currSlot] < idx) {
                    this.startIndexes[currSlot] = idxToFind;
                    this.endIndexes[currSlot] = idx;
                    this.values[currSlot] = value;
                    this.emptySlotIdx = currSlot + 1;
                    return true;
                }
                return false;
            }
            this.startIndexes[0] = idxToFind;
            this.endIndexes[0] = idx;
            this.values[0] = value;
            this.emptySlotIdx = 1;
            return true;
        }
        this.startIndexes[this.emptySlotIdx] = idx - length;
        this.endIndexes[this.emptySlotIdx] = idx;
        this.values[this.emptySlotIdx] = value;
        ++this.emptySlotIdx;
        return true;
    }
}

