/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;

public class AbstractItemFoodComponent
implements AbstractItemComponent {
    private Boolean canAlwaysEat = null;
    private Integer nutrition = null;
    private Float saturation = null;
    private Float eatSeconds = null;

    public AbstractItemFoodComponent(MythicItem mythicItem, MythicConfig config) {
        if (config.isSet("Nutrition")) {
            this.nutrition = config.getInt("Nutrition", 0);
        }
        if (config.isSet("Saturation")) {
            this.saturation = Float.valueOf(config.getFloat("Saturation", 0.0f));
        }
        if (config.isSet("EatSeconds")) {
            this.eatSeconds = Float.valueOf(config.getFloat("EatSeconds", 1.6f));
        }
        if (config.isSet("CanAlwaysEat")) {
            this.canAlwaysEat = config.getBoolean("CanAlwaysEat", false);
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyFoodComponent(this);
    }

    public Boolean getCanAlwaysEat() {
        return this.canAlwaysEat;
    }

    public Integer getNutrition() {
        return this.nutrition;
    }

    public Float getSaturation() {
        return this.saturation;
    }

    public Float getEatSeconds() {
        return this.eatSeconds;
    }

    public void setCanAlwaysEat(Boolean canAlwaysEat) {
        this.canAlwaysEat = canAlwaysEat;
    }

    public void setNutrition(Integer nutrition) {
        this.nutrition = nutrition;
    }

    public void setSaturation(Float saturation) {
        this.saturation = saturation;
    }

    public void setEatSeconds(Float eatSeconds) {
        this.eatSeconds = eatSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemFoodComponent)) {
            return false;
        }
        AbstractItemFoodComponent other = (AbstractItemFoodComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$canAlwaysEat = this.getCanAlwaysEat();
        Boolean other$canAlwaysEat = other.getCanAlwaysEat();
        if (this$canAlwaysEat == null ? other$canAlwaysEat != null : !((Object)this$canAlwaysEat).equals(other$canAlwaysEat)) {
            return false;
        }
        Integer this$nutrition = this.getNutrition();
        Integer other$nutrition = other.getNutrition();
        if (this$nutrition == null ? other$nutrition != null : !((Object)this$nutrition).equals(other$nutrition)) {
            return false;
        }
        Float this$saturation = this.getSaturation();
        Float other$saturation = other.getSaturation();
        if (this$saturation == null ? other$saturation != null : !((Object)this$saturation).equals(other$saturation)) {
            return false;
        }
        Float this$eatSeconds = this.getEatSeconds();
        Float other$eatSeconds = other.getEatSeconds();
        return !(this$eatSeconds == null ? other$eatSeconds != null : !((Object)this$eatSeconds).equals(other$eatSeconds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemFoodComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $canAlwaysEat = this.getCanAlwaysEat();
        result = result * 59 + ($canAlwaysEat == null ? 43 : ((Object)$canAlwaysEat).hashCode());
        Integer $nutrition = this.getNutrition();
        result = result * 59 + ($nutrition == null ? 43 : ((Object)$nutrition).hashCode());
        Float $saturation = this.getSaturation();
        result = result * 59 + ($saturation == null ? 43 : ((Object)$saturation).hashCode());
        Float $eatSeconds = this.getEatSeconds();
        result = result * 59 + ($eatSeconds == null ? 43 : ((Object)$eatSeconds).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemFoodComponent(canAlwaysEat=" + this.getCanAlwaysEat() + ", nutrition=" + this.getNutrition() + ", saturation=" + this.getSaturation() + ", eatSeconds=" + this.getEatSeconds() + ")";
    }
}

