/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderColor;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.adapters.BukkitPotionEffect;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AbstractItemPotionComponent
implements AbstractItemComponent {
    private PlaceholderString customName;
    private PlaceholderColor potionColor;
    private Collection<BukkitPotionEffect> effects = new ArrayList<BukkitPotionEffect>();

    public AbstractItemPotionComponent(MythicItem mythicItem, MythicConfig config) {
        this.customName = config.getPlaceholderString("Potion.Name", null);
        this.potionColor = config.getPlaceholderColor("Options.Color", null);
        this.potionColor = config.getPlaceholderColor("Potion.Color", this.potionColor == null ? null : this.potionColor.toString());
        List<String> in = config.getStringList("Potion.Effects");
        in.addAll(config.getStringList("PotionEffects"));
        for (String line : in) {
            if (line.contains("{")) {
                MythicLineConfigImpl foodEffectConfig = MythicLineConfigImpl.of(line);
                String foodEffectType = foodEffectConfig.getKey();
                int foodEffectDuration = foodEffectConfig.getInteger(new String[]{"duration", "d"}, 60);
                int foodEffectLevel = foodEffectConfig.getInteger(new String[]{"level", "lvl", "l"}, 0);
                boolean ambientParticles = foodEffectConfig.getBoolean(new String[]{"ambientparticles", "ambient", "a"}, false);
                boolean hasParticles = foodEffectConfig.getBoolean(new String[]{"hasparticles", "particles", "p"}, true);
                boolean hasIcon = foodEffectConfig.getBoolean(new String[]{"hasicon", "icon", "i"}, true);
                BukkitPotionEffect effect = new BukkitPotionEffect(foodEffectType, foodEffectDuration, foodEffectLevel, ambientParticles, hasParticles, hasIcon);
                this.effects.add(effect);
                continue;
            }
            try {
                String[] sp = line.split(" ");
                if (sp.length < 3) {
                    MythicLogger.errorItemConfig(mythicItem, config, "A potion effect is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + line);
                    continue;
                }
                int duration = Integer.parseInt(sp[1]);
                int level = Integer.parseInt(sp[2]);
                BukkitPotionEffect effect = new BukkitPotionEffect(sp[0].toUpperCase(), duration, level, true, true, true);
                this.effects.add(effect);
            }
            catch (Throwable ex) {
                MythicLogger.errorItemConfig(mythicItem, config, "A potion effect is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + line);
            }
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyPotionComponent(dropMetadata, this);
    }

    public PlaceholderString getCustomName() {
        return this.customName;
    }

    public PlaceholderColor getPotionColor() {
        return this.potionColor;
    }

    public Collection<BukkitPotionEffect> getEffects() {
        return this.effects;
    }

    public void setCustomName(PlaceholderString customName) {
        this.customName = customName;
    }

    public void setPotionColor(PlaceholderColor potionColor) {
        this.potionColor = potionColor;
    }

    public void setEffects(Collection<BukkitPotionEffect> effects) {
        this.effects = effects;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemPotionComponent)) {
            return false;
        }
        AbstractItemPotionComponent other = (AbstractItemPotionComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlaceholderString this$customName = this.getCustomName();
        PlaceholderString other$customName = other.getCustomName();
        if (this$customName == null ? other$customName != null : !this$customName.equals(other$customName)) {
            return false;
        }
        PlaceholderColor this$potionColor = this.getPotionColor();
        PlaceholderColor other$potionColor = other.getPotionColor();
        if (this$potionColor == null ? other$potionColor != null : !this$potionColor.equals(other$potionColor)) {
            return false;
        }
        Collection<BukkitPotionEffect> this$effects = this.getEffects();
        Collection<BukkitPotionEffect> other$effects = other.getEffects();
        return !(this$effects == null ? other$effects != null : !((Object)this$effects).equals(other$effects));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemPotionComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlaceholderString $customName = this.getCustomName();
        result = result * 59 + ($customName == null ? 43 : $customName.hashCode());
        PlaceholderColor $potionColor = this.getPotionColor();
        result = result * 59 + ($potionColor == null ? 43 : $potionColor.hashCode());
        Collection<BukkitPotionEffect> $effects = this.getEffects();
        result = result * 59 + ($effects == null ? 43 : ((Object)$effects).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemPotionComponent(customName=" + String.valueOf(this.getCustomName()) + ", potionColor=" + String.valueOf(this.getPotionColor()) + ", effects=" + String.valueOf(this.getEffects()) + ")";
    }
}

