/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import org.bukkit.NamespacedKey;

public class AbstractItemUseCooldownComponent
implements AbstractItemComponent {
    private NamespacedKey cooldownGroup;
    private Integer cooldownSeconds;

    public AbstractItemUseCooldownComponent(MythicItem mythicItem, MythicConfig config) {
        Object configuredCooldownGroup = config.getString("CooldownGroup");
        if (configuredCooldownGroup != null) {
            if (!((String)configuredCooldownGroup).contains(":")) {
                configuredCooldownGroup = "minecraft:" + (String)configuredCooldownGroup;
            }
            this.cooldownGroup = NamespacedKey.fromString((String)configuredCooldownGroup);
        }
        if (config.isSet("CooldownSeconds")) {
            this.cooldownSeconds = config.getInt("CooldownSeconds");
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyUseCooldownComponent(this);
    }

    public NamespacedKey getCooldownGroup() {
        return this.cooldownGroup;
    }

    public Integer getCooldownSeconds() {
        return this.cooldownSeconds;
    }

    public void setCooldownGroup(NamespacedKey cooldownGroup) {
        this.cooldownGroup = cooldownGroup;
    }

    public void setCooldownSeconds(Integer cooldownSeconds) {
        this.cooldownSeconds = cooldownSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemUseCooldownComponent)) {
            return false;
        }
        AbstractItemUseCooldownComponent other = (AbstractItemUseCooldownComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$cooldownSeconds = this.getCooldownSeconds();
        Integer other$cooldownSeconds = other.getCooldownSeconds();
        if (this$cooldownSeconds == null ? other$cooldownSeconds != null : !((Object)this$cooldownSeconds).equals(other$cooldownSeconds)) {
            return false;
        }
        NamespacedKey this$cooldownGroup = this.getCooldownGroup();
        NamespacedKey other$cooldownGroup = other.getCooldownGroup();
        return !(this$cooldownGroup == null ? other$cooldownGroup != null : !this$cooldownGroup.equals(other$cooldownGroup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemUseCooldownComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $cooldownSeconds = this.getCooldownSeconds();
        result = result * 59 + ($cooldownSeconds == null ? 43 : ((Object)$cooldownSeconds).hashCode());
        NamespacedKey $cooldownGroup = this.getCooldownGroup();
        result = result * 59 + ($cooldownGroup == null ? 43 : $cooldownGroup.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemUseCooldownComponent(cooldownGroup=" + String.valueOf(this.getCooldownGroup()) + ", cooldownSeconds=" + this.getCooldownSeconds() + ")";
    }
}

