/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.volatilecode.virtual;

import io.lumine.mythic.api.MythicPlugin;
import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.volatilecode.virtual.IPacketEntityRenderer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntityRenderer;
import io.lumine.mythic.bukkit.utils.cache.DataTracker;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Display;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketBlockDisplay<T extends PacketEntityRenderer>
extends PacketEntity {
    private DataTracker<Integer> interpolationDelay = DataTracker.of(0);
    private DataTracker<Integer> interpolationDuration = DataTracker.of(1);
    private DataTracker<Float> viewRange = DataTracker.of(Float.valueOf(4096.0f));
    private DataTracker<Float> height = DataTracker.of(Float.valueOf(4096.0f));
    private DataTracker<Float> width = DataTracker.of(Float.valueOf(4096.0f));
    private DataTracker<Display.Billboard> billboard = DataTracker.of(Display.Billboard.FIXED);
    private DataTracker<Integer> brightness = DataTracker.of(-1, false);
    private DataTracker<Vector3f> scale = DataTracker.of(new Vector3f(1.0f, 1.0f, 1.0f));
    private DataTracker<Vector3f> translation = DataTracker.of(new Vector3f(0.0f, 0.0f, 0.0f));
    private DataTracker<Quaternionf> rotationLeft = DataTracker.of(new Quaternionf(), false);
    private DataTracker<Quaternionf> rotationRight = DataTracker.of(new Quaternionf(), false);
    private DataTracker<BlockData> blockData = DataTracker.of(Material.STONE.createBlockData());
    private static final float DEG2RAD = (float)Math.PI / 180;

    public static PacketBlockDisplayBuilder create() {
        return new PacketBlockDisplayBuilder();
    }

    public PacketBlockDisplay(AbstractLocation location) {
        this(MythicProvider.get(), location);
    }

    public PacketBlockDisplay(AbstractLocation location, PacketBlockDisplayBuilder builder) {
        this(MythicProvider.get(), location);
        if (builder.interpolationDelay != null) {
            this.interpolationDelay.set(builder.interpolationDelay);
        }
        if (builder.interpolationDuration != null) {
            this.interpolationDuration.set(builder.interpolationDuration);
        }
        if (builder.height != null) {
            this.height.set(builder.height);
        }
        if (builder.width != null) {
            this.width.set(builder.width);
        }
        if (builder.billboard != null) {
            this.billboard.set(builder.billboard);
        }
        if (builder.brightness != null) {
            this.brightness.set(builder.brightness);
        }
        if (builder.scale != null) {
            this.scale.set(builder.scale);
        }
        if (builder.translation != null) {
            this.translation.set(builder.translation);
        } else if (builder.yOffset != null) {
            this.translation.set(new Vector3f(0.0f, builder.yOffset.floatValue(), 0.0f));
        }
        if (builder.rotationLeft != null) {
            this.rotationLeft.set(builder.rotationLeft);
        }
        if (builder.rotationRight != null) {
            this.rotationRight.set(builder.rotationRight);
        }
        if (builder.blockData != null) {
            this.blockData.set(builder.blockData);
        }
    }

    public PacketBlockDisplay(MythicPlugin plugin, AbstractLocation location) {
        super(location);
        this.setRenderer(plugin.getVolatileCodeHandler().getWorldHandler().createVirtualDisplayBlockEntityRenderer(this));
    }

    public void setBlock(Material material) {
        if (!material.isBlock()) {
            return;
        }
        if (this.blockData.set(material.createBlockData())) {
            this.setDirty();
        }
    }

    public void setBlock(AbstractBlock abstractBlock) {
        if (this.blockData.set(abstractBlock.getBlockData())) {
            this.setDirty();
        }
    }

    public void setBlock(BlockState block) {
        if (this.blockData.set(block.getBlockData())) {
            this.setDirty();
        }
    }

    public void setRotation(float yaw, float pitch) {
        Quaternionf q = new Quaternionf().rotateY(-yaw * ((float)Math.PI / 180)).rotateX(-pitch * ((float)Math.PI / 180));
        if (ServerVersion.isAfter(MinecraftVersions.v1_19_4)) {
            q.rotateY((float)Math.PI);
        }
        if (this.rotationLeft.set(q)) {
            this.setDirty();
        }
    }

    public void setRotationTransformation(float x, float y, float z) {
        if (this.rotationRight.set(new Quaternionf().rotationXYZ(x, y, z))) {
            this.setDirty();
        }
    }

    public void setTranslationTransformation(float x, float y, float z) {
        if (this.translation.set(new Vector3f(x, y, z))) {
            this.setDirty();
        }
    }

    public void setScale(AbstractVector scale) {
        if (this.scale.set(scale.toVector3f())) {
            this.setDirty();
        }
    }

    public void setBrightness(Display.Brightness brightness) {
        int brightnessBlock = brightness.getBlockLight();
        int brightnessSky = brightness.getSkyLight();
        this.brightness.set(brightnessBlock << 4 | brightnessSky << 20);
        this.setDirty();
    }

    public DataTracker<Integer> getInterpolationDelay() {
        return this.interpolationDelay;
    }

    public DataTracker<Integer> getInterpolationDuration() {
        return this.interpolationDuration;
    }

    public DataTracker<Float> getViewRange() {
        return this.viewRange;
    }

    public DataTracker<Float> getHeight() {
        return this.height;
    }

    public DataTracker<Float> getWidth() {
        return this.width;
    }

    public DataTracker<Display.Billboard> getBillboard() {
        return this.billboard;
    }

    public DataTracker<Integer> getBrightness() {
        return this.brightness;
    }

    public DataTracker<Vector3f> getScale() {
        return this.scale;
    }

    public DataTracker<Vector3f> getTranslation() {
        return this.translation;
    }

    public DataTracker<Quaternionf> getRotationLeft() {
        return this.rotationLeft;
    }

    public DataTracker<Quaternionf> getRotationRight() {
        return this.rotationRight;
    }

    public DataTracker<BlockData> getBlockData() {
        return this.blockData;
    }

    public static class PacketBlockDisplayBuilder {
        private Integer interpolationDelay;
        private Integer interpolationDuration;
        private Float viewRange;
        private Float height;
        private Float width;
        private Float yOffset;
        private Display.Billboard billboard;
        private Integer brightness;
        private Vector3f scale;
        private Vector3f translation;
        private Quaternionf rotationLeft;
        private Quaternionf rotationRight;
        private BlockData blockData;

        public PacketBlockDisplayBuilder scale(Vector3f scale) {
            this.scale = scale;
            return this;
        }

        public PacketBlockDisplayBuilder scale(AbstractVector scale) {
            this.scale = new Vector3f((float)scale.getX(), (float)scale.getY(), (float)scale.getZ());
            return this;
        }

        public PacketBlockDisplayBuilder brightness(int brightness) {
            this.brightness = brightness;
            return this;
        }

        public PacketBlockDisplayBuilder billboard(Display.Billboard billboard) {
            this.billboard = billboard;
            return this;
        }

        public PacketBlockDisplayBuilder billboard(String billboarding) {
            this.billboard = Display.Billboard.valueOf((String)billboarding.toUpperCase());
            return this;
        }

        public PacketBlockDisplay build(AbstractLocation location) {
            return new PacketBlockDisplay(location, this);
        }

        public Integer interpolationDelay() {
            return this.interpolationDelay;
        }

        public Integer interpolationDuration() {
            return this.interpolationDuration;
        }

        public Float viewRange() {
            return this.viewRange;
        }

        public Float height() {
            return this.height;
        }

        public Float width() {
            return this.width;
        }

        public Float yOffset() {
            return this.yOffset;
        }

        public Display.Billboard billboard() {
            return this.billboard;
        }

        public Integer brightness() {
            return this.brightness;
        }

        public Vector3f scale() {
            return this.scale;
        }

        public Vector3f translation() {
            return this.translation;
        }

        public Quaternionf rotationLeft() {
            return this.rotationLeft;
        }

        public Quaternionf rotationRight() {
            return this.rotationRight;
        }

        public BlockData blockData() {
            return this.blockData;
        }

        public PacketBlockDisplayBuilder interpolationDelay(Integer interpolationDelay) {
            this.interpolationDelay = interpolationDelay;
            return this;
        }

        public PacketBlockDisplayBuilder interpolationDuration(Integer interpolationDuration) {
            this.interpolationDuration = interpolationDuration;
            return this;
        }

        public PacketBlockDisplayBuilder viewRange(Float viewRange) {
            this.viewRange = viewRange;
            return this;
        }

        public PacketBlockDisplayBuilder height(Float height) {
            this.height = height;
            return this;
        }

        public PacketBlockDisplayBuilder width(Float width) {
            this.width = width;
            return this;
        }

        public PacketBlockDisplayBuilder yOffset(Float yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        public PacketBlockDisplayBuilder translation(Vector3f translation) {
            this.translation = translation;
            return this;
        }

        public PacketBlockDisplayBuilder rotationLeft(Quaternionf rotationLeft) {
            this.rotationLeft = rotationLeft;
            return this;
        }

        public PacketBlockDisplayBuilder rotationRight(Quaternionf rotationRight) {
            this.rotationRight = rotationRight;
            return this;
        }

        public PacketBlockDisplayBuilder blockData(BlockData blockData) {
            this.blockData = blockData;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PacketBlockDisplayBuilder)) {
                return false;
            }
            PacketBlockDisplayBuilder other = (PacketBlockDisplayBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$interpolationDelay = this.interpolationDelay();
            Integer other$interpolationDelay = other.interpolationDelay();
            if (this$interpolationDelay == null ? other$interpolationDelay != null : !((Object)this$interpolationDelay).equals(other$interpolationDelay)) {
                return false;
            }
            Integer this$interpolationDuration = this.interpolationDuration();
            Integer other$interpolationDuration = other.interpolationDuration();
            if (this$interpolationDuration == null ? other$interpolationDuration != null : !((Object)this$interpolationDuration).equals(other$interpolationDuration)) {
                return false;
            }
            Float this$viewRange = this.viewRange();
            Float other$viewRange = other.viewRange();
            if (this$viewRange == null ? other$viewRange != null : !((Object)this$viewRange).equals(other$viewRange)) {
                return false;
            }
            Float this$height = this.height();
            Float other$height = other.height();
            if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
                return false;
            }
            Float this$width = this.width();
            Float other$width = other.width();
            if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
                return false;
            }
            Float this$yOffset = this.yOffset();
            Float other$yOffset = other.yOffset();
            if (this$yOffset == null ? other$yOffset != null : !((Object)this$yOffset).equals(other$yOffset)) {
                return false;
            }
            Integer this$brightness = this.brightness();
            Integer other$brightness = other.brightness();
            if (this$brightness == null ? other$brightness != null : !((Object)this$brightness).equals(other$brightness)) {
                return false;
            }
            Display.Billboard this$billboard = this.billboard();
            Display.Billboard other$billboard = other.billboard();
            if (this$billboard == null ? other$billboard != null : !this$billboard.equals(other$billboard)) {
                return false;
            }
            Vector3f this$scale = this.scale();
            Vector3f other$scale = other.scale();
            if (this$scale == null ? other$scale != null : !this$scale.equals(other$scale)) {
                return false;
            }
            Vector3f this$translation = this.translation();
            Vector3f other$translation = other.translation();
            if (this$translation == null ? other$translation != null : !this$translation.equals(other$translation)) {
                return false;
            }
            Quaternionf this$rotationLeft = this.rotationLeft();
            Quaternionf other$rotationLeft = other.rotationLeft();
            if (this$rotationLeft == null ? other$rotationLeft != null : !this$rotationLeft.equals(other$rotationLeft)) {
                return false;
            }
            Quaternionf this$rotationRight = this.rotationRight();
            Quaternionf other$rotationRight = other.rotationRight();
            if (this$rotationRight == null ? other$rotationRight != null : !this$rotationRight.equals(other$rotationRight)) {
                return false;
            }
            BlockData this$blockData = this.blockData();
            BlockData other$blockData = other.blockData();
            return !(this$blockData == null ? other$blockData != null : !this$blockData.equals(other$blockData));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PacketBlockDisplayBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $interpolationDelay = this.interpolationDelay();
            result = result * 59 + ($interpolationDelay == null ? 43 : ((Object)$interpolationDelay).hashCode());
            Integer $interpolationDuration = this.interpolationDuration();
            result = result * 59 + ($interpolationDuration == null ? 43 : ((Object)$interpolationDuration).hashCode());
            Float $viewRange = this.viewRange();
            result = result * 59 + ($viewRange == null ? 43 : ((Object)$viewRange).hashCode());
            Float $height = this.height();
            result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
            Float $width = this.width();
            result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
            Float $yOffset = this.yOffset();
            result = result * 59 + ($yOffset == null ? 43 : ((Object)$yOffset).hashCode());
            Integer $brightness = this.brightness();
            result = result * 59 + ($brightness == null ? 43 : ((Object)$brightness).hashCode());
            Display.Billboard $billboard = this.billboard();
            result = result * 59 + ($billboard == null ? 43 : $billboard.hashCode());
            Vector3f $scale = this.scale();
            result = result * 59 + ($scale == null ? 43 : $scale.hashCode());
            Vector3f $translation = this.translation();
            result = result * 59 + ($translation == null ? 43 : $translation.hashCode());
            Quaternionf $rotationLeft = this.rotationLeft();
            result = result * 59 + ($rotationLeft == null ? 43 : $rotationLeft.hashCode());
            Quaternionf $rotationRight = this.rotationRight();
            result = result * 59 + ($rotationRight == null ? 43 : $rotationRight.hashCode());
            BlockData $blockData = this.blockData();
            result = result * 59 + ($blockData == null ? 43 : $blockData.hashCode());
            return result;
        }

        public String toString() {
            return "PacketBlockDisplay.PacketBlockDisplayBuilder(interpolationDelay=" + this.interpolationDelay() + ", interpolationDuration=" + this.interpolationDuration() + ", viewRange=" + this.viewRange() + ", height=" + this.height() + ", width=" + this.width() + ", yOffset=" + this.yOffset() + ", billboard=" + String.valueOf(this.billboard()) + ", brightness=" + this.brightness() + ", scale=" + String.valueOf(this.scale()) + ", translation=" + String.valueOf(this.translation()) + ", rotationLeft=" + String.valueOf(this.rotationLeft()) + ", rotationRight=" + String.valueOf(this.rotationRight()) + ", blockData=" + String.valueOf(this.blockData()) + ")";
        }
    }

    public static interface PacketBlockDisplayEntityRenderer
    extends IPacketEntityRenderer {
    }
}

