/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.volatilecode.virtual;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.MythicPlugin;
import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.volatilecode.virtual.IPacketEntityRenderer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntityRenderer;
import io.lumine.mythic.bukkit.utils.cache.DataTracker;
import io.lumine.mythic.bukkit.utils.text.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketTextDisplay<T extends PacketEntityRenderer>
extends PacketEntity {
    private DataTracker<Integer> interpolationDelay = new DataTracker<Integer>(0);
    private DataTracker<Integer> interpolationDuration = new DataTracker<Integer>(1);
    private DataTracker<Float> viewRange = new DataTracker<Float>(Float.valueOf(4096.0f));
    private DataTracker<Float> height = new DataTracker<Float>(Float.valueOf(5.0f));
    private DataTracker<Float> width = new DataTracker<Float>(Float.valueOf(5.0f));
    private DataTracker<Display.Billboard> billboard = new DataTracker<Display.Billboard>(Display.Billboard.VERTICAL);
    private DataTracker<Integer> brightness = new DataTracker<Object>(null);
    private DataTracker<Vector3f> scale = new DataTracker<Vector3f>(new Vector3f(1.0f, 1.0f, 1.0f));
    private DataTracker<Vector3f> translation = new DataTracker<Vector3f>(new Vector3f(0.0f, 0.0f, 0.0f));
    private DataTracker<Quaternionf> rotationLeft = new DataTracker<Quaternionf>(new Quaternionf(), false);
    private DataTracker<Quaternionf> rotationRight = new DataTracker<Quaternionf>(new Quaternionf(), false);
    private DataTracker<Function<AbstractPlayer, Component>> text = new DataTracker<Function<AbstractPlayer, Component>>(player -> Component.empty());
    private DataTracker<Integer> lineWidth = new DataTracker<Object>(null);
    private DataTracker<Color> backgroundColor = new DataTracker<Color>(Color.fromARGB((int)64, (int)0, (int)0, (int)0));
    private static final float DEG2RAD = (float)Math.PI / 180;

    public static PacketTextDisplayBuilder create() {
        return new PacketTextDisplayBuilder();
    }

    public PacketTextDisplay(AbstractLocation location) {
        this(MythicProvider.get(), location);
    }

    public PacketTextDisplay(MythicPlugin plugin, AbstractLocation location) {
        super(location);
        this.setRenderer(plugin.getVolatileCodeHandler().getWorldHandler().createVirtualTextDisplayEntityRenderer(this));
    }

    public PacketTextDisplay(AbstractLocation location, PacketTextDisplayBuilder builder) {
        super(location);
        if (builder.interpolationDelay != null) {
            this.interpolationDelay.set(builder.interpolationDelay);
        }
        if (builder.interpolationDuration != null) {
            this.interpolationDuration.set(builder.interpolationDuration);
        }
        if (builder.height != null) {
            this.height.set(builder.height);
        }
        if (builder.width != null) {
            this.width.set(builder.width);
        }
        if (builder.billboard != null) {
            this.billboard.set(builder.billboard);
        }
        if (builder.brightness != null) {
            this.brightness.set(builder.brightness);
        }
        if (builder.scale != null) {
            this.scale.set(builder.scale);
        }
        if (builder.yOffset != null) {
            this.translation.set(new Vector3f(0.0f, builder.yOffset.floatValue(), 0.0f));
        }
        if (builder.lineWidth != null) {
            this.lineWidth.set(builder.lineWidth);
        }
        if (builder.textFunction != null) {
            this.text.set(builder.textFunction);
        }
        if (builder.backgroundColor != null) {
            this.backgroundColor.set(builder.backgroundColor);
        }
        if (builder.rotation != null) {
            this.setRotation(builder.rotation.y(), builder.rotation.x(), builder.rotation.z());
        }
        this.setRenderer(MythicProvider.get().getVolatileCodeHandler().getWorldHandler().createVirtualTextDisplayEntityRenderer(this));
        if (builder.cullingDistance != null) {
            ((PacketEntityRenderer)this.getRenderer()).setCullingDistance(builder.cullingDistance);
        }
    }

    @Override
    public T getRenderer() {
        return (T)((PacketEntityRenderer)super.getRenderer());
    }

    public void setText(String text) {
        this.setTextComponent(Text.parse(text));
    }

    public void setText(String[] text) {
        ArrayList collection = Lists.newArrayList();
        TextComponent.Builder mergedComponent = Component.text();
        int i = 0;
        int size = text.length;
        for (String line : text) {
            mergedComponent = (TextComponent.Builder)mergedComponent.append(Text.parse(line));
            if (i < size - 1) {
                mergedComponent = (TextComponent.Builder)mergedComponent.appendNewline();
            }
            ++i;
        }
        this.setTextComponent((Component)mergedComponent.build());
    }

    public void setText(Collection<String> text) {
        ArrayList collection = Lists.newArrayList();
        TextComponent.Builder mergedComponent = Component.text();
        int i = 0;
        int size = text.size();
        for (String line : text) {
            mergedComponent = (TextComponent.Builder)mergedComponent.append(Text.parse(line));
            if (i < size - 1) {
                mergedComponent = (TextComponent.Builder)mergedComponent.appendNewline();
            }
            ++i;
        }
        this.setTextComponent((Component)mergedComponent.build());
    }

    public void setTextComponent(Collection<Component> components) {
        TextComponent.Builder mergedComponent = Component.text();
        int i = 0;
        int size = components.size();
        for (Component component : components) {
            mergedComponent = (TextComponent.Builder)mergedComponent.append(component);
            if (i < size - 1) {
                mergedComponent = (TextComponent.Builder)mergedComponent.appendNewline();
            }
            ++i;
        }
        this.setTextComponent((Component)mergedComponent.build());
    }

    public void setTextComponent(Component text) {
        this.setTextComponent((AbstractPlayer player) -> text);
    }

    public void setTextComponent(Function<AbstractPlayer, Component> text) {
        if (this.text.set(text)) {
            this.setDirty();
        }
    }

    public void setScale(AbstractVector scale) {
        if (this.scale.set(scale.toVector3f())) {
            this.setDirty();
        }
    }

    public void setRotation(float yaw, float pitch) {
        if (this.rotationLeft.set(new Quaternionf().rotateY(-yaw * ((float)Math.PI / 180)).rotateX(-pitch * ((float)Math.PI / 180)))) {
            this.setDirty();
        }
    }

    public void setRotation(float yaw, float pitch, float roll) {
        if (this.rotationLeft.set(new Quaternionf().rotateY(yaw * ((float)Math.PI / 180)).rotateX(-pitch * ((float)Math.PI / 180)).rotateZ(-roll * ((float)Math.PI / 180)))) {
            this.setDirty();
        }
    }

    public DataTracker<Integer> getInterpolationDelay() {
        return this.interpolationDelay;
    }

    public DataTracker<Integer> getInterpolationDuration() {
        return this.interpolationDuration;
    }

    public DataTracker<Float> getViewRange() {
        return this.viewRange;
    }

    public DataTracker<Float> getHeight() {
        return this.height;
    }

    public DataTracker<Float> getWidth() {
        return this.width;
    }

    public DataTracker<Display.Billboard> getBillboard() {
        return this.billboard;
    }

    public DataTracker<Integer> getBrightness() {
        return this.brightness;
    }

    public DataTracker<Vector3f> getScale() {
        return this.scale;
    }

    public DataTracker<Vector3f> getTranslation() {
        return this.translation;
    }

    public DataTracker<Quaternionf> getRotationLeft() {
        return this.rotationLeft;
    }

    public DataTracker<Quaternionf> getRotationRight() {
        return this.rotationRight;
    }

    public DataTracker<Function<AbstractPlayer, Component>> getText() {
        return this.text;
    }

    public DataTracker<Integer> getLineWidth() {
        return this.lineWidth;
    }

    public DataTracker<Color> getBackgroundColor() {
        return this.backgroundColor;
    }

    public static class PacketTextDisplayBuilder {
        private Integer cullingDistance;
        private Integer interpolationDelay;
        private Integer interpolationDuration;
        private Float height;
        private Float width;
        private Float yOffset;
        private Display.Billboard billboard;
        private Integer brightness;
        private Vector3f scale;
        private Vector3f rotation;
        private Integer lineWidth;
        private Function<AbstractPlayer, Component> textFunction;
        private Color backgroundColor;

        public PacketTextDisplayBuilder text(String text) {
            return this.textComponent(Text.parse(text));
        }

        public PacketTextDisplayBuilder text(String[] text) {
            ArrayList collection = Lists.newArrayList();
            TextComponent.Builder mergedComponent = Component.text();
            int i = 0;
            int size = text.length;
            for (String line : text) {
                mergedComponent = (TextComponent.Builder)mergedComponent.append(Text.parse(line));
                if (i < size - 1) {
                    mergedComponent = (TextComponent.Builder)mergedComponent.appendNewline();
                }
                ++i;
            }
            return this.textComponent((Component)mergedComponent.build());
        }

        public PacketTextDisplayBuilder text(Collection<String> text) {
            ArrayList collection = Lists.newArrayList();
            TextComponent.Builder mergedComponent = Component.text();
            int i = 0;
            int size = text.size();
            for (String line : text) {
                mergedComponent = (TextComponent.Builder)mergedComponent.append(Text.parse(line));
                if (i < size - 1) {
                    mergedComponent = (TextComponent.Builder)mergedComponent.appendNewline();
                }
                ++i;
            }
            return this.textComponent((Component)mergedComponent.build());
        }

        public PacketTextDisplayBuilder textComponent(Collection<Component> components) {
            TextComponent.Builder mergedComponent = Component.text();
            int i = 0;
            int size = components.size();
            for (Component component : components) {
                mergedComponent = (TextComponent.Builder)mergedComponent.append(component);
                if (i < size - 1) {
                    mergedComponent = (TextComponent.Builder)mergedComponent.appendNewline();
                }
                ++i;
            }
            return this.textComponent((Component)mergedComponent.build());
        }

        public PacketTextDisplayBuilder textComponent(Component text) {
            return this.textFunction(player -> text);
        }

        public PacketTextDisplayBuilder scale(AbstractVector scale) {
            this.scale = new Vector3f((float)scale.getX(), (float)scale.getY(), (float)scale.getZ());
            return this;
        }

        public PacketTextDisplayBuilder rotation(float yaw, float pitch, float roll) {
            this.rotation = new Vector3f(pitch, yaw, roll);
            return this;
        }

        public PacketTextDisplay build(AbstractLocation location) {
            return new PacketTextDisplay(location, this);
        }

        public PacketTextDisplayBuilder cullingDistance(Integer cullingDistance) {
            this.cullingDistance = cullingDistance;
            return this;
        }

        public PacketTextDisplayBuilder interpolationDelay(Integer interpolationDelay) {
            this.interpolationDelay = interpolationDelay;
            return this;
        }

        public PacketTextDisplayBuilder interpolationDuration(Integer interpolationDuration) {
            this.interpolationDuration = interpolationDuration;
            return this;
        }

        public PacketTextDisplayBuilder height(Float height) {
            this.height = height;
            return this;
        }

        public PacketTextDisplayBuilder width(Float width) {
            this.width = width;
            return this;
        }

        public PacketTextDisplayBuilder yOffset(Float yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        public PacketTextDisplayBuilder billboard(Display.Billboard billboard) {
            this.billboard = billboard;
            return this;
        }

        public PacketTextDisplayBuilder brightness(Integer brightness) {
            this.brightness = brightness;
            return this;
        }

        public PacketTextDisplayBuilder rotation(Vector3f rotation) {
            this.rotation = rotation;
            return this;
        }

        public PacketTextDisplayBuilder lineWidth(Integer lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public PacketTextDisplayBuilder textFunction(Function<AbstractPlayer, Component> textFunction) {
            this.textFunction = textFunction;
            return this;
        }

        public PacketTextDisplayBuilder backgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PacketTextDisplayBuilder)) {
                return false;
            }
            PacketTextDisplayBuilder other = (PacketTextDisplayBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$cullingDistance = this.cullingDistance();
            Integer other$cullingDistance = other.cullingDistance();
            if (this$cullingDistance == null ? other$cullingDistance != null : !((Object)this$cullingDistance).equals(other$cullingDistance)) {
                return false;
            }
            Integer this$interpolationDelay = this.interpolationDelay();
            Integer other$interpolationDelay = other.interpolationDelay();
            if (this$interpolationDelay == null ? other$interpolationDelay != null : !((Object)this$interpolationDelay).equals(other$interpolationDelay)) {
                return false;
            }
            Integer this$interpolationDuration = this.interpolationDuration();
            Integer other$interpolationDuration = other.interpolationDuration();
            if (this$interpolationDuration == null ? other$interpolationDuration != null : !((Object)this$interpolationDuration).equals(other$interpolationDuration)) {
                return false;
            }
            Float this$height = this.height();
            Float other$height = other.height();
            if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
                return false;
            }
            Float this$width = this.width();
            Float other$width = other.width();
            if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
                return false;
            }
            Float this$yOffset = this.yOffset();
            Float other$yOffset = other.yOffset();
            if (this$yOffset == null ? other$yOffset != null : !((Object)this$yOffset).equals(other$yOffset)) {
                return false;
            }
            Integer this$brightness = this.brightness();
            Integer other$brightness = other.brightness();
            if (this$brightness == null ? other$brightness != null : !((Object)this$brightness).equals(other$brightness)) {
                return false;
            }
            Integer this$lineWidth = this.lineWidth();
            Integer other$lineWidth = other.lineWidth();
            if (this$lineWidth == null ? other$lineWidth != null : !((Object)this$lineWidth).equals(other$lineWidth)) {
                return false;
            }
            Display.Billboard this$billboard = this.billboard();
            Display.Billboard other$billboard = other.billboard();
            if (this$billboard == null ? other$billboard != null : !this$billboard.equals(other$billboard)) {
                return false;
            }
            Vector3f this$scale = this.scale();
            Vector3f other$scale = other.scale();
            if (this$scale == null ? other$scale != null : !this$scale.equals(other$scale)) {
                return false;
            }
            Vector3f this$rotation = this.rotation();
            Vector3f other$rotation = other.rotation();
            if (this$rotation == null ? other$rotation != null : !this$rotation.equals(other$rotation)) {
                return false;
            }
            Function<AbstractPlayer, Component> this$textFunction = this.textFunction();
            Function<AbstractPlayer, Component> other$textFunction = other.textFunction();
            if (this$textFunction == null ? other$textFunction != null : !this$textFunction.equals(other$textFunction)) {
                return false;
            }
            Color this$backgroundColor = this.backgroundColor();
            Color other$backgroundColor = other.backgroundColor();
            return !(this$backgroundColor == null ? other$backgroundColor != null : !this$backgroundColor.equals(other$backgroundColor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PacketTextDisplayBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $cullingDistance = this.cullingDistance();
            result = result * 59 + ($cullingDistance == null ? 43 : ((Object)$cullingDistance).hashCode());
            Integer $interpolationDelay = this.interpolationDelay();
            result = result * 59 + ($interpolationDelay == null ? 43 : ((Object)$interpolationDelay).hashCode());
            Integer $interpolationDuration = this.interpolationDuration();
            result = result * 59 + ($interpolationDuration == null ? 43 : ((Object)$interpolationDuration).hashCode());
            Float $height = this.height();
            result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
            Float $width = this.width();
            result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
            Float $yOffset = this.yOffset();
            result = result * 59 + ($yOffset == null ? 43 : ((Object)$yOffset).hashCode());
            Integer $brightness = this.brightness();
            result = result * 59 + ($brightness == null ? 43 : ((Object)$brightness).hashCode());
            Integer $lineWidth = this.lineWidth();
            result = result * 59 + ($lineWidth == null ? 43 : ((Object)$lineWidth).hashCode());
            Display.Billboard $billboard = this.billboard();
            result = result * 59 + ($billboard == null ? 43 : $billboard.hashCode());
            Vector3f $scale = this.scale();
            result = result * 59 + ($scale == null ? 43 : $scale.hashCode());
            Vector3f $rotation = this.rotation();
            result = result * 59 + ($rotation == null ? 43 : $rotation.hashCode());
            Function<AbstractPlayer, Component> $textFunction = this.textFunction();
            result = result * 59 + ($textFunction == null ? 43 : $textFunction.hashCode());
            Color $backgroundColor = this.backgroundColor();
            result = result * 59 + ($backgroundColor == null ? 43 : $backgroundColor.hashCode());
            return result;
        }

        public String toString() {
            return "PacketTextDisplay.PacketTextDisplayBuilder(cullingDistance=" + this.cullingDistance() + ", interpolationDelay=" + this.interpolationDelay() + ", interpolationDuration=" + this.interpolationDuration() + ", height=" + this.height() + ", width=" + this.width() + ", yOffset=" + this.yOffset() + ", billboard=" + String.valueOf(this.billboard()) + ", brightness=" + this.brightness() + ", scale=" + String.valueOf(this.scale()) + ", rotation=" + String.valueOf(this.rotation()) + ", lineWidth=" + this.lineWidth() + ", textFunction=" + String.valueOf(this.textFunction()) + ", backgroundColor=" + String.valueOf(this.backgroundColor()) + ")";
        }

        public Integer cullingDistance() {
            return this.cullingDistance;
        }

        public Integer interpolationDelay() {
            return this.interpolationDelay;
        }

        public Integer interpolationDuration() {
            return this.interpolationDuration;
        }

        public Float height() {
            return this.height;
        }

        public Float width() {
            return this.width;
        }

        public Float yOffset() {
            return this.yOffset;
        }

        public Display.Billboard billboard() {
            return this.billboard;
        }

        public Integer brightness() {
            return this.brightness;
        }

        public Vector3f scale() {
            return this.scale;
        }

        public Vector3f rotation() {
            return this.rotation;
        }

        public Integer lineWidth() {
            return this.lineWidth;
        }

        public Function<AbstractPlayer, Component> textFunction() {
            return this.textFunction;
        }

        public Color backgroundColor() {
            return this.backgroundColor;
        }
    }

    public static interface PacketTextDisplayEntityRenderer
    extends IPacketEntityRenderer {
    }
}

