/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.lumine.mythic.api.adapters.AbstractAttributeModifier;
import io.lumine.mythic.api.adapters.AbstractItemFlag;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBannerComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemPotionComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemSpawnerComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemTrialSpawnerComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemTrimComponent;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitPotionEffect;
import io.lumine.mythic.bukkit.utils.gson.GsonProvider;
import io.lumine.mythic.bukkit.utils.serialize.Base64Util;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.constants.ItemKeys;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.utils.Patterns;
import io.lumine.mythic.core.utils.UUIDUtil;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import java.awt.Color;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.TrialSpawner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.Nullable;

public abstract class BukkitItemStack
implements AbstractItemStack {
    protected ItemStack itemStack;

    protected BukkitItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    protected BukkitItemStack(Material material) {
        this.itemStack = new ItemStack(material);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public Material getType() {
        return this.itemStack.getType();
    }

    @Deprecated
    public BukkitItemStack type(Material material) {
        this.itemStack.setType(material);
        return this;
    }

    @Nullable
    public ItemMeta getItemMeta() {
        return this.itemStack.getItemMeta();
    }

    public BukkitItemStack editMeta(Consumer<ItemMeta> consumer) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta == null) {
            return this;
        }
        consumer.accept(meta);
        this.itemStack.setItemMeta(meta);
        return this;
    }

    public <T extends ItemMeta> BukkitItemStack editMeta(Class<T> clazz, Consumer<T> consumer) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta == null || !meta.getClass().equals(clazz)) {
            return this;
        }
        consumer.accept(meta);
        this.itemStack.setItemMeta(meta);
        return this;
    }

    @Override
    @Deprecated
    @Nullable
    public String getName() {
        Component component = this.name();
        if (component instanceof TextComponent) {
            TextComponent text = (TextComponent)component;
            return text.content();
        }
        return null;
    }

    @Override
    public Component name() {
        return this.itemStack.displayName();
    }

    @Override
    public abstract BukkitItemStack setName(@Nullable String var1);

    @Override
    public abstract BukkitItemStack name(Component var1);

    @Override
    @Deprecated
    public Collection<String> getLore() {
        return this.lore().stream().map(line -> {
            if (line instanceof TextComponent) {
                TextComponent text = (TextComponent)line;
                return text.content();
            }
            return null;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<Component> lore() {
        return this.itemStack.lore();
    }

    @Override
    public abstract BukkitItemStack setLore(List<String> var1);

    @Override
    public abstract BukkitItemStack lore(List<Component> var1);

    @Override
    public BukkitItemStack loreText(List<String> lore) {
        ArrayList componentList = Lists.newArrayList();
        for (String line : lore) {
            if (line == null) continue;
            componentList.add(Text.parse(line));
        }
        return this.lore((List)componentList);
    }

    @Override
    public BukkitItemStack clearLore() {
        this.itemStack.lore().clear();
        return this;
    }

    @Override
    public int getAmount() {
        return this.itemStack.getAmount();
    }

    @Override
    public abstract BukkitItemStack amount(int var1);

    @Override
    @Deprecated
    public int getData() {
        return this.itemStack.getDurability();
    }

    @Override
    public abstract BukkitItemStack data(int var1);

    @Override
    public abstract BukkitItemStack breakable(boolean var1);

    @Override
    public abstract BukkitItemStack hideAll();

    @Override
    public BukkitItemStack flags(AbstractItemFlag ... flags) {
        return this.flags(Arrays.stream(flags).toList());
    }

    @Override
    public abstract BukkitItemStack flags(Collection<AbstractItemFlag> var1);

    @Override
    public abstract BukkitItemStack repairCost(int var1);

    @Override
    public int getMaxStackSize() {
        return this.getType().getMaxStackSize();
    }

    @Override
    public abstract BukkitItemStack maxStackSize(int var1);

    @Override
    public BukkitItemStack unstackable() {
        return this.maxStackSize(1);
    }

    @Override
    public int getModelData() {
        return Optional.ofNullable(this.getItemMeta()).map(ItemMeta::getCustomModelData).orElse(0);
    }

    @Override
    public abstract BukkitItemStack modelData(int var1);

    @Override
    public abstract BukkitItemStack addAttributeModifier(AbstractAttributeModifier var1);

    @Override
    public BukkitItemStack skullOwner(String username) {
        return this.skullOwner(username, UUIDUtil.getUUIDFromString(username));
    }

    @Override
    public BukkitItemStack skullOwner(String username, UUID uniqueId) {
        return this.editMeta(meta -> {
            if (meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                com.destroystokyo.paper.profile.PlayerProfile profile = Bukkit.createProfileExact((UUID)uniqueId, (String)username);
                skullMeta.setPlayerProfile(profile);
            }
        });
    }

    @Override
    public BukkitItemStack skullTexture(String skinTexture) {
        try {
            String decoded = Base64Util.decodeString(skinTexture);
            GsonProvider.parser();
            JsonObject obj = JsonParser.parseString((String)decoded).getAsJsonObject();
            String skinUrl = obj.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
            return this.skullTexture(URI.create(skinUrl));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return this;
        }
    }

    @Override
    public BukkitItemStack skullTexture(URI url) {
        return this.editMeta(meta -> {
            if (meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                if (ServerVersion.isPaper()) {
                    com.destroystokyo.paper.profile.PlayerProfile profile = Bukkit.createProfileExact((UUID)UUIDUtil.getUUIDFromString(url.toString()), null);
                    try {
                        PlayerTextures textures = profile.getTextures();
                        textures.setSkin(url.toURL());
                        profile.setTextures(textures);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    skullMeta.setPlayerProfile(profile);
                } else {
                    PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUIDUtil.getUUIDFromString(url.toString()), null);
                    try {
                        PlayerTextures textures = profile.getTextures();
                        textures.setSkin(url.toURL());
                        profile.setTextures(textures);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    skullMeta.setOwnerProfile(profile);
                }
            }
        });
    }

    @Override
    public BukkitItemStack skullTextureId(String id) {
        return this.skullTexture(URI.create("https://textures.minecraft.net/texture/" + id));
    }

    @Override
    public abstract BukkitItemStack enchant(Enchantment var1, int var2);

    @Override
    public abstract BukkitItemStack removeEnchant(Enchantment var1);

    @Override
    public abstract BukkitItemStack enchantmentGlow(boolean var1);

    @Override
    public abstract BukkitItemStack durability(int var1);

    @Override
    public abstract BukkitItemStack maxDurability(int var1);

    @Override
    public abstract BukkitItemStack canPlaceOn(Collection<Material> var1);

    @Override
    public abstract BukkitItemStack canBreak(Collection<Material> var1);

    @Override
    public abstract BukkitItemStack potionEffect(PotionEffectType var1, int var2, int var3);

    @Override
    public abstract BukkitItemStack color(int var1, int var2, int var3);

    @Override
    public BukkitItemStack color(Chroma color) {
        return this.color(color.red(), color.green(), color.blue());
    }

    @Override
    public BukkitItemStack color(String color) {
        int b;
        int g2;
        int r;
        if (color.startsWith("#")) {
            Color parsedColor = Color.decode(color);
            r = parsedColor.getRed();
            g2 = parsedColor.getRed();
            b = parsedColor.getRed();
        } else if (StringUtils.countMatches((CharSequence)color, (CharSequence)",") == 2) {
            String[] components = color.split(",");
            r = Integer.parseInt(components[0]);
            g2 = Integer.parseInt(components[1]);
            b = Integer.parseInt(components[2]);
        } else {
            org.bukkit.Color bukkitColor = DyeColor.valueOf((String)color.toUpperCase()).getColor();
            r = bukkitColor.getRed();
            g2 = bukkitColor.getGreen();
            b = bukkitColor.getBlue();
        }
        return this.color(r, g2, b);
    }

    @Override
    public AbstractItemStack applyBannerComponent(DropMetadata dropMetadata, AbstractItemBannerComponent bannerComponent) {
        return this.editMeta(meta -> {
            block19: {
                BlockStateMeta blockStateMeta;
                BlockState patt0$temp;
                block18: {
                    if (!(meta instanceof BannerMeta)) break block18;
                    BannerMeta bannerMeta = (BannerMeta)meta;
                    if (bannerComponent.getColor() != null) {
                        DyeColor baseColor = bannerComponent.getColor().get(dropMetadata).toBukkitDyeColor();
                        if (ServerVersion.isBefore(MinecraftVersions.v1_21)) {
                            MythicBukkit.inst().getVolatileCodeHandler().getCompatibilityHandler().setLegacyBannerPattern(bannerMeta, baseColor, "BASE");
                        } else {
                            try {
                                PatternType patternType = (PatternType)Registry.BANNER_PATTERN.get(NamespacedKey.minecraft((String)"base"));
                                Pattern pattern = new Pattern(baseColor, patternType);
                                bannerMeta.addPattern(pattern);
                            }
                            catch (Exception ex) {
                                MythicLogger.error("A banner color is configured incorrectly, must use a color from the Bukkit DyeColor ENUM.");
                            }
                        }
                    }
                    for (String bannerLayerConfig : bannerComponent.getBannerLayers()) {
                        try {
                            String[] sp = bannerLayerConfig.split(" ");
                            if (sp.length < 2) {
                                MythicLogger.error("A shield banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + bannerLayerConfig);
                                continue;
                            }
                            DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                            if (ServerVersion.isBefore(MinecraftVersions.v1_21)) {
                                MythicBukkit.inst().getVolatileCodeHandler().getCompatibilityHandler().setLegacyBannerPattern(bannerMeta, dc, sp[0]);
                                continue;
                            }
                            Object patternId = sp[1].toLowerCase();
                            if (!((String)patternId).contains(":")) {
                                patternId = "minecraft:" + (String)patternId;
                            }
                            PatternType patternType = (PatternType)Registry.BANNER_PATTERN.get(NamespacedKey.fromString((String)patternId));
                            Pattern p = new Pattern(dc, patternType);
                            bannerMeta.addPattern(p);
                        }
                        catch (Exception ex) {
                            MythicLogger.error("A shield banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + bannerLayerConfig);
                        }
                    }
                    break block19;
                }
                if (!(meta instanceof BlockStateMeta) || !((patt0$temp = (blockStateMeta = (BlockStateMeta)meta).getBlockState()) instanceof Banner)) break block19;
                Banner banner = (Banner)patt0$temp;
                if (bannerComponent.getColor() != null) {
                    DyeColor baseColor = bannerComponent.getColor().get(dropMetadata).toBukkitDyeColor();
                    banner.setBaseColor(baseColor);
                }
                for (String bannerLayerConfig : bannerComponent.getBannerLayers()) {
                    try {
                        String[] sp = bannerLayerConfig.split(" ");
                        if (sp.length < 2) {
                            MythicLogger.error("A shield banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + bannerLayerConfig);
                            continue;
                        }
                        DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                        if (ServerVersion.isBefore(MinecraftVersions.v1_21)) {
                            MythicBukkit.inst().getVolatileCodeHandler().getCompatibilityHandler().setLegacyBannerPattern(banner, dc, sp[0]);
                            continue;
                        }
                        Object patternId = sp[1].toLowerCase();
                        if (!((String)patternId).contains(":")) {
                            patternId = "minecraft:" + (String)patternId;
                        }
                        PatternType patternType = (PatternType)Registry.BANNER_PATTERN.get(NamespacedKey.fromString((String)patternId));
                        Pattern p = new Pattern(dc, patternType);
                        banner.addPattern(p);
                    }
                    catch (Exception ex) {
                        MythicLogger.error("A shield banner layer is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + bannerLayerConfig);
                    }
                }
            }
        });
    }

    @Override
    public AbstractItemStack applyPotionComponent(DropMetadata dropMetadata, AbstractItemPotionComponent potionData) {
        return this.editMeta(meta -> {
            if (!(meta instanceof PotionMeta)) {
                return;
            }
            PotionMeta potionMeta = (PotionMeta)meta;
            if (potionData.getPotionColor() != null) {
                try {
                    potionMeta.setColor(potionData.getPotionColor().get(dropMetadata).toBukkitColor());
                }
                catch (Exception ex) {
                    MythicLogger.error("Potion color is configured incorrectly");
                }
            }
            if (potionData.getEffects() != null) {
                potionMeta.clearCustomEffects();
                for (BukkitPotionEffect effect : potionData.getEffects()) {
                    potionMeta.addCustomEffect(effect.getEffect(), false);
                }
            }
        });
    }

    @Override
    public AbstractItemStack applyMobSpawnerComponent(AbstractItemSpawnerComponent spawnerData) {
        return this.editMeta(meta -> {
            if (meta instanceof BlockStateMeta) {
                BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
                BlockState blockState = blockStateMeta.getBlockState();
                if (blockState instanceof CreatureSpawner) {
                    CreatureSpawner creatureSpawner = (CreatureSpawner)blockState;
                    if (spawnerData.getDelay() != null) {
                        creatureSpawner.setDelay(creatureSpawner.getDelay());
                    }
                    if (spawnerData.getMinSpawnDelay() != null) {
                        creatureSpawner.setMinSpawnDelay(spawnerData.getMinSpawnDelay().intValue());
                    }
                    if (spawnerData.getMaxSpawnDelay() != null) {
                        creatureSpawner.setMaxSpawnDelay(spawnerData.getMaxSpawnDelay().intValue());
                    }
                    if (spawnerData.getMaxNearbyEntities() != null) {
                        creatureSpawner.setMaxNearbyEntities(spawnerData.getMaxNearbyEntities().intValue());
                    }
                    if (spawnerData.getSpawnRange() != null) {
                        creatureSpawner.setSpawnRange(spawnerData.getSpawnRange().intValue());
                    }
                    if (spawnerData.getSpawnCount() != null) {
                        creatureSpawner.setSpawnCount(spawnerData.getSpawnCount().intValue());
                    }
                    if (spawnerData.getRequiredPlayerRange() != null) {
                        creatureSpawner.setRequiredPlayerRange(spawnerData.getRequiredPlayerRange().intValue());
                    }
                    ArrayList potentialSpawns = Lists.newArrayList();
                    for (AbstractItemSpawnerComponent.PotentialSpawns potentialSpawn : spawnerData.getPotentialSpawns()) {
                        String type = potentialSpawn.getType();
                        Optional<MythicMob> maybeMob = MythicBukkit.inst().getMobManager().getMythicMob(type);
                        if (maybeMob.isEmpty()) continue;
                        MythicMob mm4 = maybeMob.get();
                        EntitySnapshot entitySnapshot = BukkitAdapter.getEntitySnapshot(mm4);
                        int spawnWeight = potentialSpawn.getWeight();
                        SpawnRule spawnRule = new SpawnRule(potentialSpawn.getMinBlockLight(), potentialSpawn.getMaxBlockLight(), potentialSpawn.getMinSkyLight(), potentialSpawn.getMaxSkyLight());
                        SpawnerEntry spawnerEntry = new SpawnerEntry(entitySnapshot, spawnWeight, spawnRule);
                        potentialSpawns.add(spawnerEntry);
                    }
                    creatureSpawner.setPotentialSpawns((Collection)potentialSpawns);
                }
                blockStateMeta.setBlockState(blockState);
            }
        });
    }

    @Override
    public AbstractItemStack applyTrialSpawnerComponent(AbstractItemTrialSpawnerComponent spawnerData) {
        return this.editMeta(meta -> {
            if (meta instanceof BlockStateMeta) {
                BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
                BlockState blockState = blockStateMeta.getBlockState();
                if (blockState instanceof TrialSpawner) {
                    TrialSpawner trialSpawner = (TrialSpawner)blockState;
                }
                blockStateMeta.setBlockState(blockState);
            }
        });
    }

    @Override
    public AbstractItemStack applyTrimComponent(DropMetadata dropMetadata, AbstractItemTrimComponent trimComponent) {
        if (ServerVersion.isBefore(MinecraftVersions.v1_20)) {
            return this;
        }
        return this.editMeta(meta -> {
            Object material = trimComponent.getTrimMaterial().get(dropMetadata);
            Object pattern = trimComponent.getTrimPattern().get(dropMetadata);
            if (!((String)material).contains(":")) {
                material = "minecraft:" + (String)material;
            }
            if (!((String)pattern).contains(":")) {
                pattern = "minecraft:" + (String)pattern;
            }
            NamespacedKey materialKey = NamespacedKey.fromString((String)material);
            NamespacedKey patternKey = NamespacedKey.fromString((String)pattern);
            TrimMaterial trimMaterial = (TrimMaterial)Registry.TRIM_MATERIAL.get(materialKey);
            TrimPattern trimPattern = (TrimPattern)Registry.TRIM_PATTERN.get(patternKey);
            if (trimMaterial == null) {
                MythicLogger.error("Trim Material {0} not found", materialKey.toString());
                return;
            }
            if (trimPattern == null) {
                MythicLogger.error("Trim Pattern {0} not found", patternKey.toString());
                return;
            }
            if (meta instanceof ArmorMeta) {
                ArmorMeta armorMeta = (ArmorMeta)meta;
                ArmorTrim trim = new ArmorTrim(trimMaterial, trimPattern);
                armorMeta.setTrim(trim);
            }
        });
    }

    @Override
    public abstract BukkitItemStack customData(String var1, Tag var2);

    @Override
    public abstract BukkitItemStack customData(CompoundTag var1);

    @Override
    public AbstractItemStack mythicItemType(String itemType) {
        return this.editMeta(meta -> meta.getPersistentDataContainer().set(ItemKeys.TYPE, PersistentDataType.STRING, (Object)itemType));
    }

    @Override
    public Optional<String> getMythicItemType() {
        if (this.getItemMeta() != null && this.getItemMeta().getPersistentDataContainer().has(ItemKeys.TYPE, PersistentDataType.STRING)) {
            return Optional.of((String)this.getItemMeta().getPersistentDataContainer().get(ItemKeys.TYPE, PersistentDataType.STRING));
        }
        return Optional.empty();
    }

    @Override
    public AbstractItemStack mythicItemVersion(int itemVersion) {
        return this.editMeta(meta -> meta.getPersistentDataContainer().set(ItemKeys.VERSION, PersistentDataType.INTEGER, (Object)itemVersion));
    }

    @Override
    public Optional<Integer> getMythicItemVersion() {
        if (this.getItemMeta().getPersistentDataContainer().has(ItemKeys.VERSION, PersistentDataType.INTEGER)) {
            return Optional.of((Integer)this.getItemMeta().getPersistentDataContainer().get(ItemKeys.VERSION, PersistentDataType.INTEGER));
        }
        return Optional.empty();
    }

    @Override
    public BukkitItemStack preventEnchanting() {
        return this.editMeta(meta -> meta.getPersistentDataContainer().set(ItemKeys.PREVENT_ENCHANTING, PersistentDataType.BYTE, (Object)1));
    }

    @Override
    public BukkitItemStack preventRepairingWith() {
        return this.editMeta(meta -> meta.getPersistentDataContainer().set(ItemKeys.PREVENT_REPAIRING_WITH, PersistentDataType.BYTE, (Object)1));
    }

    @Override
    public BukkitItemStack preventCraftingWith() {
        return this.editMeta(meta -> meta.getPersistentDataContainer().set(ItemKeys.PREVENT_CRAFTING_WITH, PersistentDataType.BYTE, (Object)1));
    }

    @Override
    public BukkitItemStack preventSmithingWith() {
        return this.editMeta(meta -> meta.getPersistentDataContainer().set(ItemKeys.PREVENT_SMITHING_WITH, PersistentDataType.BYTE, (Object)1));
    }

    @Override
    public BukkitItemStack UUID(UUID uuid) {
        return this.editMeta(meta -> meta.getPersistentDataContainer().set(ItemKeys.UUID, PersistentDataType.STRING, (Object)uuid.toString()));
    }

    @Override
    public UUID getUUID() {
        String ret = (String)this.getItemMeta().getPersistentDataContainer().get(ItemKeys.UUID, PersistentDataType.STRING);
        if (ret == null) {
            return null;
        }
        return UUID.fromString(ret);
    }

    @Override
    public BukkitItemStack timestamp(long timestamp) {
        return this.editMeta(meta -> meta.getPersistentDataContainer().set(ItemKeys.TIMESTAMP, PersistentDataType.LONG, (Object)timestamp));
    }

    @Override
    public long getTimestamp() {
        Long ret = (Long)this.getItemMeta().getPersistentDataContainer().get(ItemKeys.TIMESTAMP, PersistentDataType.LONG);
        if (ret == null) {
            return 0L;
        }
        return ret;
    }

    @Override
    public abstract BukkitItemStack itemModel(NamespacedKey var1);

    @Override
    public boolean isSimilar(AbstractItemStack other) {
        if (other instanceof BukkitItemStack) {
            BukkitItemStack bukkit = (BukkitItemStack)other;
            ItemStack otherBukkit = bukkit.itemStack;
            Optional<String> maybeType = this.getMythicItemType();
            Optional<String> maybeOtherType = other.getMythicItemType();
            if (maybeType.isPresent() && maybeOtherType.isPresent() && Objects.equals(maybeType.get(), maybeOtherType.get())) {
                return true;
            }
            if (MythicBukkit.inst().getCompatibility().getMMOItems().isPresent()) {
                CompoundTag data = this.getCustomData();
                CompoundTag otherData = other.getCustomData();
                if (data.getString("MMOITEMS_ITEM_TYPE") != null && Objects.equals(data.getString("MMOITEMS_ITEM_TYPE"), otherData.getString("MMOITEMS_ITEM_TYPE"))) {
                    return true;
                }
                if (data.getString("MMOITEMS_ITEM_ID") != null && Objects.equals(data.getString("MMOITEMS_ITEM_ID"), otherData.getString("MMOITEMS_ITEM_ID"))) {
                    return true;
                }
            }
            return this.itemStack.isSimilar(otherBukkit);
        }
        return false;
    }

    public boolean isSimilar(ItemStack other) {
        return this.itemStack.isSimilar(other);
    }

    public static Collection<AbstractItemStack> getMatches(String regex) {
        HashSet<AbstractItemStack> bukkitItemStacks = new HashSet<AbstractItemStack>();
        if (regex.toLowerCase().startsWith("mmoitems.") && MythicBukkit.inst().getCompatibility().getMMOItems().isPresent()) {
            bukkitItemStacks.add(MythicBukkit.inst().getBootstrap().createItem(regex));
        } else {
            for (String itemNames : MythicBukkit.inst().getItemManager().getItemNames()) {
                if (!itemNames.matches(Patterns.toRegex(regex))) continue;
                bukkitItemStacks.add(MythicBukkit.inst().getBootstrap().createItem(itemNames));
            }
            for (Material mats : Material.values()) {
                if (!mats.toString().matches(Patterns.toRegex(regex.toUpperCase()))) continue;
                bukkitItemStacks.add(BukkitAdapter.adapt(mats));
            }
        }
        return bukkitItemStacks;
    }

    public int hashCode() {
        Material material = this.itemStack.getType();
        int cmd = this.itemStack.hasItemMeta() && this.itemStack.getItemMeta().hasCustomModelData() ? this.itemStack.getItemMeta().getCustomModelData() : 0;
        return Objects.hash(material, cmd);
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractItemStack) {
            AbstractItemStack abstractItemStack = (AbstractItemStack)object;
            return this.isSimilar(abstractItemStack);
        }
        return false;
    }
}

