/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractParticle;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderColor;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public enum BukkitParticle implements AbstractParticle
{
    POOF("poof", "explosion_normal", "explode", "explosion", "explosion_small"),
    EXPLOSION("explosion", "explosion_large", "largeexplode", "largeexplosion"),
    EXPLOSION_EMITTER("explosion_emitter", "explosion_huge", "hugeexplode", "hugeexplosion"),
    FIREWORK("firework", "fireworks", "fireworks_spark", "fireworksspark"),
    BUBBLE("bubble", "water_bubble"),
    SPLASH("splash", "water_splash"),
    FISHING("fishing", "water_wake", "wake"),
    UNDERWATER("underwater", "suspended"),
    SUSPENDED_DEPTH("suspended_depth", "underwater", "depthsuspend"),
    CRIT("crit", new String[0]),
    ENCHANTED_HIT("enchanted_hit", "crit_magic", "magiccrit"),
    SMOKE("smoke", "smoke_normal"),
    LARGE_SMOKE("large_smoke", "smoke_large", "largesmoke"),
    EFFECT("effect", "spell"),
    INSTANT_EFFECT("instant_effect", "spell_instant", "instant_spell"),
    ENTITY_EFFECT("entity_effect", "spell_mob", "mob_spell"),
    SPELL_MOB_AMBIENT("ambient_entity_effect", "mob_spell_ambient", "spell_mob_ambient"),
    WITCH("witch", "spell_witch", "witch_magic"),
    DRIPPING_WATER("dripping_water", "drip_water", "dripwater"),
    DRIPPING_LAVA("dripping_lava", "drip_lava", "driplava"),
    ANGRY_VILLAGER("angry_villager", "villager_angry", "angryvillager"),
    HAPPY_VILLAGER("happy_villager", "villager_happy", "happyvillager"),
    MYCELIUM("mycelium", "town_aura", "townaura"),
    NOTE("note", new String[0]),
    PORTAL("portal", new String[0]),
    ENCHANT("enchant", "enchantment_table", "enchantmenttable", "enchantingtable"),
    FLAME("flame", new String[0]),
    LAVA("lava", new String[0]),
    CLOUD("cloud", new String[0]),
    DUST("dust", "red_dust", "reddust", "redstone"),
    ITEM_SNOWBALL("item_snowball", "snowball", "snowballpoof"),
    ITEM_SLIME("item_slime", "slime"),
    HEART("heart", new String[0]),
    BARRIER("barrier", new String[0]),
    ITEM("item", "item_crack", "icon_crack", "item_crack", "itemcrack"),
    BLOCK("block_crack", "block_crack", "blockcrack"),
    BLOCK_DUST("block_dust", "dust", "block_dust", "blockdust"),
    RAIN("water_drop", "rain", "droplet"),
    ELDER_GUARDIAN("elder_guardian", "mob_appearance", "mobappearance"),
    DRAGON_BREATH("dragon_breath", "dragonbreath"),
    END_ROD("end_rod", "endrod"),
    DAMAGE_INDICATOR("damage_indicator", "damageindicator"),
    SWEEP_ATTACK("sweep_attack", "sweepattack"),
    FALLING_DUST("falling_dust", "fallingdust"),
    TOTEM_OF_UNDYING("totem_of_undying", "totem"),
    SPIT("spit", new String[0]),
    SQUID_INK("squid_ink", "squidink"),
    BUBBLE_POP("bubble_pop", "bubblepop"),
    CURRENT_DOWN("current_down", "currentdown"),
    BUBBLE_COLUMN_UP("bubble_column_up", "bubblecolumn", "bubble_column"),
    NAUTILUS("nautilus", new String[0]),
    DOLPHIN("dolphin", new String[0]),
    COMPOSTER("composter", new String[0]),
    FALLING_LAVA("falling_lava", "fallinglava"),
    FALLING_WATER("falling_water", "fallingwater"),
    FLASH("flash", new String[0]),
    LANDING_LAVA("landing_lava", "landinglava"),
    SNEEZE("sneeze", new String[0]),
    SNOWFLAKE("snowflake", new String[0]),
    CAMPFIRE_COSY_SMOKE("campfire_cosy_smoke", "campfire_cosy", "campfire_cozy_smoke", "campfire_cozy", "campfire"),
    CAMPFIRE_SIGNAL_SMOKE("campfire_signal_smoke", "campfire_signal"),
    DRIPPING_HONEY("dripping_honey", "drippinghoney"),
    FALLING_HONEY("falling_honey", "fallinghoney"),
    FALLING_NECTAR("falling_nectar", "fallingnectar"),
    LANDING_HONEY("landing_honey", "landinghoney"),
    ASH("ash", new String[0]),
    WHITE_ASH("white_ash", new String[0]),
    CRIMSON_SPORE("crimson_spore", "crimson_spores", "crimsonspore", "crimsonspores"),
    SOUL_FIRE_FLAME("soul_fire_flame", "soulfireflame", "soulfire", "soulflame"),
    WARPED_SPORE("warped_spore", "warped_spores", "warpedspore", "warpedspores"),
    DRIPPING_OBSIDIAN_TEAR("dripping_obsidian_tear", "dropping_obsidian_tear", "drippingobsidiantear"),
    FALLING_OBSIDIAN_TEAR("falling_obsidian_tear", "fallingobsidiantear"),
    LANDING_OBSIDIAN_TEAR("landing_obsidian_tear", "landingobsidiantear"),
    SOUL("soul", new String[0]),
    DRIPPING_DRIPSTONE_LAVA("dripping_dripstone_lava", "dropping_dripstone_lava"),
    DRIPPING_DRIPSTONE_WATER("dripping_dripstone_water", "dropping_dripstone_water"),
    DUST_COLOR_TRANSITION("dust_color_transition", "dustcolortransition", "dustcolor"),
    ELECTRIC_SPARK("electric_spark", "electricspark", "spark"),
    FALLING_DRIPSTONE_LAVA("falling_dripstone_lava", new String[0]),
    FALLING_DRIPSTONE_WATER("falling_dripstone_water", new String[0]),
    GLOW("glow", new String[0]),
    GLOW_SQUID_INK("glow_squid_ink", "glowingink", "glowink", "glowsquid"),
    LIGHT("light", new String[0]),
    REVERSE_PORTAL("reverse_portal", new String[0]),
    SCRAPE("scrape", new String[0]),
    SMALL_FLAME("small_flame", new String[0]),
    VIBRATION("vibration", new String[0]),
    WAX_OFF("wax_off", new String[0]),
    WAX_ON("wax_on", new String[0]),
    FALLING_SPORE_BLOSSOM("falling_spore_blossom", new String[0]),
    SPORE_BLOSSOM_AIR("spore_blossom_air", new String[0]),
    BLOCK_MARKER("block_marker", new String[0]),
    SCULK_SOUL("sculk_soul", new String[0]),
    SHRIEK("shriek", new String[0]),
    SCULK_CHARGE("sculk_charge", new String[0]),
    SCULK_CHARGE_POP("sculk_charge_pop", new String[0]),
    SONIC_BOOM("sonic_boom", new String[0]),
    CHERRY_LEAVES("cherry_leaves", new String[0]),
    EGG_CRACK("egg_crack", new String[0]),
    WHITE_SMOKE("white_smoke", new String[0]),
    DUST_PLUME("dust_plume", new String[0]),
    GUST("gust", new String[0]),
    GUST_EMITTER_SMALL("gust_emitter_small", new String[0]),
    GUST_EMITTER_LARGE("gust_emitter_large", "large_gust"),
    SMALL_GUST("small_gust", "gust_small"),
    TRIAL_SPAWNER_DETECTION("trial_spawner_detection", new String[0]),
    TRIAL_SPAWNER_DETECTION_OMINOUS("trial_spawner_detection_ominous", new String[0]),
    TRIAL_OMEN("trial_omen", new String[0]),
    DUST_PILLAR("dust_pillar", new String[0]),
    VAULT_CONNECTION("vault_connection", new String[0]),
    OMINOUS_SPAWNING("ominous_spawning", new String[0]),
    RAID_OMEN("raid_omen", new String[0]),
    INFESTED("infested", new String[0]),
    BLOCK_CRUMBLE("block_crumble", new String[0]),
    TRAIL("trail", new String[0]),
    PALE_OAK_LEAVES("pale_oak_leaves", new String[0]),
    TINTED_LEAVES("tinted_leaves", new String[0]),
    COPPER_FIRE_FLAME("copper_fire_flame", new String[0]);

    private static final Map<String, BukkitParticle> PARTICLE_ALIASES;
    private Particle bukkitParticle;
    private final String[] aliases;

    public static BukkitParticle get(String key) {
        BukkitParticle particle = PARTICLE_ALIASES.getOrDefault(key.toUpperCase(), null);
        if (particle == null) {
            MythicLogger.errorGenericConfig("Particle '" + key + "' is not supported by this version");
            return CLOUD;
        }
        return particle;
    }

    private BukkitParticle(String bukkitName, String ... aliases) {
        try {
            this.bukkitParticle = switch (bukkitName.toUpperCase()) {
                case "POOF" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"POOF");
                    }
                    yield Particle.valueOf((String)"EXPLOSION_NORMAL");
                }
                case "EXPLOSION" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"EXPLOSION");
                    }
                    yield Particle.valueOf((String)"EXPLOSION_LARGE");
                }
                case "EXPLOSION_EMITTER" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"EXPLOSION_EMITTER");
                    }
                    yield Particle.valueOf((String)"EXPLOSION_HUGE");
                }
                case "FIREWORK" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"FIREWORK");
                    }
                    yield Particle.valueOf((String)"FIREWORKS_SPARK");
                }
                case "BUBBLE" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"BUBBLE");
                    }
                    yield Particle.valueOf((String)"WATER_BUBBLE");
                }
                case "SPLASH" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"SPLASH");
                    }
                    yield Particle.valueOf((String)"WATER_SPLASH");
                }
                case "FISHING" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"FISHING");
                    }
                    yield Particle.valueOf((String)"WATER_WAKE");
                }
                case "UNDERWATER" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"UNDERWATER");
                    }
                    yield Particle.valueOf((String)"SUSPENDED");
                }
                case "ENCHANTED_HIT" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"ENCHANTED_HIT");
                    }
                    yield Particle.valueOf((String)"CRIT_MAGIC");
                }
                case "SMOKE" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"SMOKE");
                    }
                    yield Particle.valueOf((String)"SMOKE_NORMAL");
                }
                case "LARGE_SMOKE" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"LARGE_SMOKE");
                    }
                    yield Particle.valueOf((String)"SMOKE_LARGE");
                }
                case "EFFECT" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"EFFECT");
                    }
                    yield Particle.valueOf((String)"SPELL");
                }
                case "INSTANT_EFFECT" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"INSTANT_EFFECT");
                    }
                    yield Particle.valueOf((String)"SPELL_INSTANT");
                }
                case "ENTITY_EFFECT" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"ENTITY_EFFECT");
                    }
                    yield Particle.valueOf((String)"SPELL_MOB");
                }
                case "AMBIENT_ENTITY_EFFECT" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"ENTITY_EFFECT");
                    }
                    yield Particle.valueOf((String)"SPELL_MOB_AMBIENT");
                }
                case "DRIPPING_WATER" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"DRIPPING_WATER");
                    }
                    yield Particle.valueOf((String)"DRIP_WATER");
                }
                case "DRIPPING_LAVA" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"DRIPPING_LAVA");
                    }
                    yield Particle.valueOf((String)"DRIP_LAVA");
                }
                case "ANGRY_VILLAGER" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"ANGRY_VILLAGER");
                    }
                    yield Particle.valueOf((String)"VILLAGER_ANGRY");
                }
                case "HAPPY_VILLAGER" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"HAPPY_VILLAGER");
                    }
                    yield Particle.valueOf((String)"VILLAGER_HAPPY");
                }
                case "MYCELIUM" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"MYCELIUM");
                    }
                    yield Particle.valueOf((String)"TOWN_AURA");
                }
                case "ENCHANT" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"ENCHANT");
                    }
                    yield Particle.valueOf((String)"ENCHANTMENT_TABLE");
                }
                case "DUST" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"DUST");
                    }
                    yield Particle.valueOf((String)"REDSTONE");
                }
                case "ITEM_SNOWBALL" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"ITEM_SNOWBALL");
                    }
                    yield Particle.valueOf((String)"SNOWBALL");
                }
                case "ITEM_SLIME" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"ITEM_SLIME");
                    }
                    yield Particle.valueOf((String)"SLIME");
                }
                case "ITEM" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"ITEM");
                    }
                    yield Particle.valueOf((String)"ITEM_CRACK");
                }
                case "BLOCK" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"BLOCK");
                    }
                    yield Particle.valueOf((String)"BLOCK_CRACK");
                }
                case "RAIN" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"RAIN");
                    }
                    yield Particle.valueOf((String)"WATER_DROP");
                }
                case "ELDER_GUARDIAN" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"ELDER_GUARDIAN");
                    }
                    yield Particle.valueOf((String)"MOB_APPEARANCE");
                }
                case "TOTEM_OF_UNDYING" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"TOTEM_OF_UNDYING");
                    }
                    yield Particle.valueOf((String)"TOTEM");
                }
                case "WITCH" -> {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
                        yield Particle.valueOf((String)"WITCH");
                    }
                    yield Particle.valueOf((String)"SPELL_WITCH");
                }
                default -> Particle.valueOf((String)bukkitName.toUpperCase());
            };
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.aliases = aliases;
    }

    public Particle toBukkitParticle() {
        return this.bukkitParticle;
    }

    public boolean requiresData() {
        return !this.toBukkitParticle().getDataType().equals(Void.class);
    }

    public boolean validateData(Object obj) {
        Particle particle = this.toBukkitParticle();
        if (particle.getDataType().equals(Void.class)) {
            MythicLogger.error("Could not send particle: particle data is void.");
            return false;
        }
        if (particle.getDataType().equals(ItemStack.class)) {
            if (obj instanceof ItemStack) {
                return true;
            }
            MythicLogger.error("Could not send particle: particle {0} data must be ItemStack.", particle.getKey());
            return false;
        }
        if (particle.getDataType() == BlockData.class) {
            if (obj instanceof BlockData) {
                return true;
            }
            MythicLogger.error("Could not send particle: particle {0} data must be BlockData.", particle.getKey());
            return false;
        }
        if (particle.getDataType() == MaterialData.class) {
            if (obj instanceof MaterialData) {
                return true;
            }
            MythicLogger.error("Could not send particle: particle {0} data must be MaterialData.", particle.getKey());
            return false;
        }
        if (particle.getDataType() == Color.class) {
            if (obj instanceof Color) {
                return true;
            }
            MythicLogger.error("Could not send particle: particle {0} data must be Color.", particle.getKey());
            return false;
        }
        if (particle.getDataType() == Particle.DustOptions.class) {
            if (obj instanceof Particle.DustOptions) {
                return true;
            }
            MythicLogger.error("Could not send particle: particle {0} data must be DustOptions.", particle.getKey());
            return false;
        }
        if (particle.getDataType() == Particle.DustTransition.class) {
            if (obj instanceof Particle.DustTransition) {
                return true;
            }
            MythicLogger.error("Could not send particle: particle {0} data must be DustTransition.", particle.getKey());
            return false;
        }
        return true;
    }

    public Function<PlaceholderMeta, Object> parseDataOptions(MythicLineConfig config) {
        Particle particle = this.toBukkitParticle();
        if (particle.getDataType().equals(ItemStack.class)) {
            String strMaterial = config.getString(new String[]{"material", "m"}, "STONE", new String[0]);
            try {
                return data -> new ItemStack(Material.matchMaterial((String)strMaterial.toUpperCase()));
            }
            catch (Exception ex) {
                return data -> new ItemStack(Material.STONE);
            }
        }
        if (particle.getDataType().equals(BlockData.class)) {
            String strMaterial = config.getString(new String[]{"material", "m"}, "STONE", new String[0]);
            try {
                Material material = Material.matchMaterial((String)strMaterial.toUpperCase());
                return data -> Bukkit.getServer().createBlockData(material);
            }
            catch (Exception ex) {
                return data -> Bukkit.getServer().createBlockData(Material.STONE);
            }
        }
        if (particle.getDataType().equals(MaterialData.class)) {
            String strMaterial = config.getString(new String[]{"material", "m"}, "STONE", new String[0]);
            try {
                return data -> Material.matchMaterial((String)strMaterial.toUpperCase()).getData();
            }
            catch (Exception ex) {
                return data -> Material.STONE.getData();
            }
        }
        if (particle.getDataType().equals(Color.class)) {
            PlaceholderColor color = config.getPlaceholderColor(new String[]{"color", "c"}, "#FF0000", new String[0]);
            return data -> color.get((PlaceholderMeta)data).toBukkitColor();
        }
        if (particle.getDataType().equals(Particle.DustOptions.class)) {
            PlaceholderColor color = config.getPlaceholderColor(new String[]{"color", "c"}, "#FF0000", new String[0]);
            PlaceholderFloat size = config.getPlaceholderFloat(new String[]{"size"}, 1.0f, new String[0]);
            return data -> new Particle.DustOptions(color.get((PlaceholderMeta)data).toBukkitColor(), size.get((PlaceholderMeta)data));
        }
        if (particle.getDataType().equals(Particle.DustTransition.class)) {
            PlaceholderColor color1 = config.getPlaceholderColor(new String[]{"color", "c", "color1", "c1", "fromcolor", "fc"}, "#FF0000", new String[0]);
            PlaceholderColor color2 = config.getPlaceholderColor(new String[]{"color2", "c2", "tocolor", "tc"}, "#0000FF", new String[0]);
            PlaceholderFloat size = config.getPlaceholderFloat(new String[]{"size"}, 1.0f, new String[0]);
            return data -> new Particle.DustTransition(color1.get((PlaceholderMeta)data).toBukkitColor(), color2.get((PlaceholderMeta)data).toBukkitColor(), size.get((PlaceholderMeta)data));
        }
        try {
            if (particle.getDataType().equals(Particle.Spell.class)) {
                PlaceholderColor color = config.getPlaceholderColor(new String[]{"color", "c"}, "#FF0000", new String[0]);
                PlaceholderFloat power = config.getPlaceholderFloat(new String[]{"power", "p"}, 1.0f, new String[0]);
                return data -> new Particle.Spell(color.get((PlaceholderMeta)data).toBukkitColor(), power.get((PlaceholderMeta)data));
            }
        }
        catch (Throwable color) {
            // empty catch block
        }
        if (particle == Particle.SCULK_CHARGE || particle == Particle.SCULK_CHARGE_POP) {
            double r = config.getDouble(new String[]{"rotation", "rot", "r"}, 0.0);
            double rotation = r > 0.0 ? r / 180.0 * Math.PI : r;
            return data -> rotation;
        }
        if (particle == Particle.SHRIEK) {
            return data -> 0;
        }
        if (particle == Particle.DRAGON_BREATH) {
            return data -> Float.valueOf(0.0f);
        }
        try {
            if (particle.getDataType().equals(Particle.Trail.class)) {
                String location = config.getString(new String[]{"source", "src"}, "#FF0000", new String[0]);
                PlaceholderColor color = config.getPlaceholderColor(new String[]{"color", "c"}, "#FF0000", new String[0]);
                PlaceholderInt duration = config.getPlaceholderInteger(new String[]{"duration", "d"}, 100, new String[0]);
                SkillTargeter targeter = MythicBukkit.inst().getSkillManager().getTargeter(location);
                if (targeter == null) {
                    return null;
                }
                return data -> {
                    if (data instanceof SkillMetadata) {
                        SkillMetadata skillMetadata = (SkillMetadata)data;
                        AbstractLocation loc = MythicBukkit.inst().getSkillManager().getLocationTarget(targeter, skillMetadata);
                        return new Particle.Trail(BukkitAdapter.adapt(loc), color.get((PlaceholderMeta)data).toBukkitColor(), duration.get((PlaceholderMeta)data));
                    }
                    return null;
                };
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void send(AbstractLocation location) {
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21)) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.spawnParticle(particle, loc, 1, 0.0, 0.0, 0.0, 0.0, null, true);
            }
        } else {
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.spawnParticle(particle, loc, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void send(AbstractPlayer audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ) {
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        Player player = (Player)audience.getBukkitEntity();
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21)) {
            player.spawnParticle(particle, loc, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed, null, true);
        } else {
            player.spawnParticle(particle, loc, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed);
        }
    }

    public void send(Collection<AbstractPlayer> audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ) {
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21)) {
            for (AbstractPlayer e : audience) {
                Player player = BukkitAdapter.adapt(e.asPlayer());
                if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                player.spawnParticle(particle, loc, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed, null, true);
            }
        } else {
            for (AbstractPlayer e : audience) {
                Player player = BukkitAdapter.adapt(e.asPlayer());
                if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                player.spawnParticle(particle, loc, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed);
            }
        }
    }

    public void send(Collection<AbstractPlayer> audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ, Object data) {
        this.send(audience, location, speed, amount, offsetX, offsetY, offsetZ, data, false);
    }

    public void send(Collection<AbstractPlayer> audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ, Object data, boolean exactOffsets) {
        if (!this.validateData(data)) {
            return;
        }
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        if (exactOffsets) {
            for (int i = 0; i < amount; ++i) {
                Player player;
                Location ln = loc.clone().add((double)(0.0f - offsetX) + Numbers.randomDouble() * (double)offsetX * 2.0, (double)(offsetY - offsetY) + Numbers.randomDouble() * (double)offsetY * 2.0, (double)(0.0f - offsetZ) + Numbers.randomDouble() * (double)offsetZ * 2.0);
                if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21)) {
                    for (AbstractPlayer e : audience) {
                        player = BukkitAdapter.adapt(e.asPlayer());
                        if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                        player.spawnParticle(particle, ln, 1, 0.0, 0.0, 0.0, (double)speed, data, true);
                    }
                    continue;
                }
                for (AbstractPlayer e : audience) {
                    player = BukkitAdapter.adapt(e.asPlayer());
                    if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                    player.spawnParticle(particle, ln, 1, 0.0, 0.0, 0.0, (double)speed, data);
                }
            }
        } else if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21)) {
            for (AbstractPlayer e : audience) {
                Player player = BukkitAdapter.adapt(e.asPlayer());
                if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                player.spawnParticle(particle, loc, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed, data, true);
            }
        } else {
            for (AbstractPlayer e : audience) {
                Player player = BukkitAdapter.adapt(e.asPlayer());
                if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                player.spawnParticle(particle, loc, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed, data);
            }
        }
    }

    public void sendDirectional(Collection<AbstractPlayer> audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ, AbstractVector direction) {
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21)) {
            for (int i = 0; i < amount; ++i) {
                Location ln = loc.clone().add((double)(0.0f - offsetX) + Numbers.randomDouble() * (double)offsetX * 2.0, (double)(offsetY - offsetY) + Numbers.randomDouble() * (double)offsetY * 2.0, (double)(0.0f - offsetZ) + Numbers.randomDouble() * (double)offsetZ * 2.0);
                for (AbstractPlayer e : audience) {
                    Player player = BukkitAdapter.adapt(e.asPlayer());
                    if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                    player.spawnParticle(particle, ln, 0, (double)((float)direction.getX()), (double)((float)direction.getY()), (double)((float)direction.getZ()), (double)speed, null, true);
                }
            }
        } else {
            for (int i = 0; i < amount; ++i) {
                Location ln = loc.clone().add((double)(0.0f - offsetX) + Numbers.randomDouble() * (double)offsetX * 2.0, (double)(offsetY - offsetY) + Numbers.randomDouble() * (double)offsetY * 2.0, (double)(0.0f - offsetZ) + Numbers.randomDouble() * (double)offsetZ * 2.0);
                for (AbstractPlayer e : audience) {
                    Player player = BukkitAdapter.adapt(e.asPlayer());
                    if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                    player.spawnParticle(particle, ln, 0, (double)((float)direction.getX()), (double)((float)direction.getY()), (double)((float)direction.getZ()), (double)speed);
                }
            }
        }
    }

    public void sendLegacyColored(Collection<AbstractPlayer> audience, AbstractLocation location, float speed, int amount, float offsetX, float offsetY, float offsetZ, Chroma color) {
        Particle particle = this.toBukkitParticle();
        Location loc = BukkitAdapter.adapt(location);
        float r = (float)color.red() / 255.0f;
        float g2 = (float)color.green() / 255.0f;
        float b = (float)color.blue() / 255.0f;
        if (r < Float.MIN_NORMAL) {
            r = Float.MIN_NORMAL;
        }
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21)) {
            for (int i = 0; i < amount; ++i) {
                Location ln = loc.clone().add((double)(0.0f - offsetX) + Numbers.randomDouble() * (double)offsetX * 2.0, (double)(offsetY - offsetY) + Numbers.randomDouble() * (double)offsetY * 2.0, (double)(0.0f - offsetZ) + Numbers.randomDouble() * (double)offsetZ * 2.0);
                for (AbstractPlayer e : audience) {
                    Player player = BukkitAdapter.adapt(e.asPlayer());
                    if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                    player.spawnParticle(particle, ln, 0, (double)r, (double)g2, (double)b, speed > 0.0f ? (double)speed : 1.0, null, true);
                }
            }
        } else {
            for (int i = 0; i < amount; ++i) {
                Location ln = loc.clone().add((double)(0.0f - offsetX) + Numbers.randomDouble() * (double)offsetX * 2.0, (double)(offsetY - offsetY) + Numbers.randomDouble() * (double)offsetY * 2.0, (double)(0.0f - offsetZ) + Numbers.randomDouble() * (double)offsetZ * 2.0);
                for (AbstractPlayer e : audience) {
                    Player player = BukkitAdapter.adapt(e.asPlayer());
                    if (!player.getWorld().equals((Object)loc.getWorld())) continue;
                    player.spawnParticle(particle, ln, 0, (double)r, (double)g2, (double)b, speed > 0.0f ? (double)speed : 1.0);
                }
            }
        }
    }

    public Particle getBukkitParticle() {
        return this.bukkitParticle;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    static {
        PARTICLE_ALIASES = new HashMap<String, BukkitParticle>();
        for (BukkitParticle particle : BukkitParticle.values()) {
            PARTICLE_ALIASES.put(particle.toString().toUpperCase(), particle);
            PARTICLE_ALIASES.put(particle.toString().toUpperCase().replace("_", ""), particle);
            for (String alias : particle.getAliases()) {
                PARTICLE_ALIASES.put(alias.toUpperCase(), particle);
                PARTICLE_ALIASES.put(alias.toUpperCase().replace("_", ""), particle);
            }
        }
    }
}

