/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.debug;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class TimingsCommand
extends Command<MythicBukkit> {
    public TimingsCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length > 0) {
            if ("ON".equals(args[0].toUpperCase())) {
                MythicBukkit.inst().getTimingsHandler().enable();
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs]" + String.valueOf(ChatColor.GREEN) + " Timings have been enabled.");
                return true;
            } else if ("OFF".equals(args[0].toUpperCase())) {
                MythicBukkit.inst().getTimingsHandler().disable();
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs]" + String.valueOf(ChatColor.GREEN) + " Timings have been disabled.");
                return true;
            } else if ("RESET".equals(args[0].toUpperCase())) {
                MythicBukkit.inst().getTimingsHandler().reset();
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs]" + String.valueOf(ChatColor.GREEN) + " Timings have been reset.");
                return true;
            } else if ("SPAWNERS".equals(args[0].toUpperCase())) {
                double overallMS = MythicBukkit.inst().getTimingsHandler().getRunTimeMillis();
                double totalMS = MythicBukkit.inst().getTimingsHandler().getTimeTotal() / 1000000L;
                double totalSpawners = MythicBukkit.inst().getTimingsHandler().getTimeSpawners() / 1000000L;
                MythicLogger.log("Spawner Timings");
                MythicLogger.log("Time Analyzed: " + overallMS);
                MythicLogger.log("Clock Time: " + Math.round(totalMS * 100.0) / 100L + "ms (" + Math.round(totalMS / overallMS * 10000.0) / 100L + "%)");
                MythicLogger.log("- CSpawners: " + Math.round(totalSpawners * 100.0) / 100L + "ms (" + Math.round(totalSpawners / totalMS * 10000.0) / 100L + "% Clock, " + Math.round(totalSpawners / overallMS * 10000.0) / 100L + "% Overall)");
                MythicLogger.log("-- All Spawners:");
                HashMap map = (HashMap)MythicBukkit.inst().getTimingsHandler().getAllSpawnerTimes().clone();
                map = TimingsCommand.sortHashMapByValuesD(map);
                for (String s2 : map.keySet()) {
                    long tM = (Long)map.get(s2) / 1000000L;
                    long tMTS = Math.round((double)tM / totalSpawners * 10000.0) / 100L;
                    long tMC = Math.round((double)tM / totalMS * 10000.0) / 100L;
                    long tMO = Math.round((double)tM / overallMS * 10000.0) / 100L;
                    MythicLogger.log(String.format("** %32s %8d ms - %4d pS %4d pC %4d pOverall)", s2, tM, tMTS, tMC, tMO));
                }
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs]" + String.valueOf(ChatColor.GREEN) + " Spawner timings have been pasted to the console.");
                return true;
            } else {
                if (!"SKILLS".equals(args[0].toUpperCase())) return false;
                double overallMS = MythicBukkit.inst().getTimingsHandler().getRunTimeMillis();
                double totalMS = MythicBukkit.inst().getTimingsHandler().getTimeTotal() / 1000000L;
                double totalSkills = MythicBukkit.inst().getTimingsHandler().getTimeSkills() / 1000000L;
                MythicLogger.log(" AbstractSkill Timings");
                MythicLogger.log("Time Analyzed: " + overallMS);
                MythicLogger.log("Clock Time: " + Math.round(totalMS * 100.0) / 100L + "ms (" + Math.round(totalMS / overallMS * 10000.0) / 100L + "%)");
                MythicLogger.log("- TmrSkills: " + Math.round(totalSkills * 100.0) / 100L + "ms (" + Math.round(totalSkills / totalMS * 10000.0) / 100L + "% Clock, " + Math.round(totalSkills / overallMS * 10000.0) / 100L + "% Overall)");
                MythicLogger.log("-- All Timer Skills:");
                HashMap map = (HashMap)MythicBukkit.inst().getTimingsHandler().getAllSkillTimes().clone();
                map = TimingsCommand.sortHashMapByValuesD(map);
                for (String s3 : map.keySet()) {
                    long tM = (Long)map.get(s3) / 1000000L;
                    long tMTS = Math.round((double)tM / totalSkills * 10000.0) / 100L;
                    long tMC = Math.round((double)tM / totalMS * 10000.0) / 100L;
                    long tMO = Math.round((double)tM / overallMS * 10000.0) / 100L;
                    MythicLogger.log(String.format("** %64s %8d ms - %4d pS %4d pC %4d pOverall)", s3, tM, tMTS, tMC, tMO));
                }
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs]" + String.valueOf(ChatColor.GREEN) + " AbstractSkill timings have been pasted to the console.");
            }
            return true;
        } else {
            if (!MythicBukkit.inst().getTimingsHandler().isEnabled()) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs]" + String.valueOf(ChatColor.GREEN) + " Timings must be enabled first.");
                return true;
            }
            double overallMS = MythicBukkit.inst().getTimingsHandler().getRunTimeMillis();
            double totalMS = MythicBukkit.inst().getTimingsHandler().getTimeTotal() / 1000000L;
            double totalSkills = MythicBukkit.inst().getTimingsHandler().getTimeSkills() / 1000000L;
            double totalRandomSpawners = MythicBukkit.inst().getTimingsHandler().getTimeRandomSpawners() / 1000000L;
            double totalRandomGenerators = MythicBukkit.inst().getTimingsHandler().getTimeRandomGenerators() / 1000000L;
            double totalScanner = MythicBukkit.inst().getTimingsHandler().getTimeScanner() / 1000000L;
            double totalSpawners = MythicBukkit.inst().getTimingsHandler().getTimeSpawners() / 1000000L;
            double totalThreatT = MythicBukkit.inst().getTimingsHandler().getTimeThreatTables() / 1000000L;
            double overhead = totalMS - totalSkills - totalSpawners - totalThreatT - totalScanner - totalRandomSpawners;
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + " Clock Timings");
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Time Analyzed: " + overallMS);
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Clock Time: " + String.valueOf(ChatColor.GREEN) + (double)Math.round(totalMS * 100.0) / 100.0 + "ms (" + (double)Math.round(totalMS / overallMS * 10000.0) / 100.0 + "%)");
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "- Skills & Conditions: " + String.valueOf(ChatColor.GREEN) + (double)Math.round(totalSkills * 100.0) / 100.0 + "ms (" + (double)Math.round(totalSkills / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalSkills / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "- RndSpawns(Replaced): " + String.valueOf(ChatColor.GREEN) + (double)Math.round(totalRandomSpawners * 100.0) / 100.0 + "ms (" + (double)Math.round(totalRandomSpawners / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalRandomSpawners / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "- RndSpawns(Generate): " + String.valueOf(ChatColor.GREEN) + (double)Math.round(totalRandomGenerators * 100.0) / 100.0 + "ms (" + (double)Math.round(totalRandomGenerators / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalRandomGenerators / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "- Static Mob Spawners: " + String.valueOf(ChatColor.GREEN) + (double)Math.round(totalSpawners * 100.0) / 100.0 + "ms (" + (double)Math.round(totalSpawners / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalSpawners / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "- World Scanner: " + String.valueOf(ChatColor.GREEN) + (double)Math.round(totalScanner * 100.0) / 100.0 + "ms (" + (double)Math.round(totalScanner / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalScanner / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "- Threat Tables: " + String.valueOf(ChatColor.GREEN) + (double)Math.round(totalThreatT * 100.0) / 100.0 + "ms (" + (double)Math.round(totalThreatT / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(totalThreatT / overallMS * 10000.0) / 100.0 + "% Overall)");
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "- Overhead+: " + String.valueOf(ChatColor.GREEN) + (double)Math.round(overhead * 100.0) / 100.0 + "ms (" + (double)Math.round(overhead / totalMS * 10000.0) / 100.0 + "% Clock, " + (double)Math.round(overhead / overallMS * 10000.0) / 100.0 + "% Overall)");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.debug.timings";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "timings";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"t"};
    }

    private static LinkedHashMap sortHashMapByValuesD(HashMap passedMap) {
        ArrayList mapKeys = new ArrayList(passedMap.keySet());
        ArrayList mapValues = new ArrayList(passedMap.values());
        Collections.sort(mapValues);
        Collections.sort(mapKeys);
        LinkedHashMap<String, Long> sortedMap = new LinkedHashMap<String, Long>();
        block0: for (Object val : mapValues) {
            for (Object key : mapKeys) {
                String comp2;
                String comp1 = passedMap.get(key).toString();
                if (!comp1.equals(comp2 = val.toString())) continue;
                passedMap.remove(key);
                mapKeys.remove(key);
                sortedMap.put((String)key, (Long)val);
                continue block0;
            }
        }
        return sortedMap;
    }
}

