/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.mobs;

import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.CollectionUtils;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KillCommand
extends Command<MythicBukkit> {
    public KillCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        int radius = 0;
        boolean exact = false;
        boolean literally = false;
        boolean vanilla = false;
        boolean faction = false;
        if (args != null && args.length > 1) {
            while (args[0].startsWith("-")) {
                if (args[0].contains("p")) {
                    literally = true;
                }
                if (args[0].contains("e")) {
                    exact = true;
                }
                if (args[0].contains("v")) {
                    vanilla = true;
                }
                if (args[0].contains("f")) {
                    faction = true;
                }
                args = Arrays.copyOfRange(args, 1, args.length);
            }
        }
        if (args.length == 0) {
            CommandHelper.sendError(sender, "Must supply mob type to kill (or use <yellow>killall<red>)");
            return true;
        }
        String type = args[0].trim();
        if (args.length > 1 && sender instanceof Player) {
            radius = Integer.parseInt(args[1]);
        }
        int count = 0;
        for (ActiveMob am : ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMobs()) {
            if (am == null || faction && (am.getFaction() == null || !am.getFaction().equalsIgnoreCase(type)) || !exact && !am.getType().getInternalName().contains(type) || exact && !am.getType().getInternalName().equalsIgnoreCase(type)) continue;
            am.setDespawned();
            ((MythicBukkit)this.getPlugin()).getMobManager().unregisterActiveMob(am);
            am.getEntity().remove();
            ++count;
        }
        if (faction) {
            CommandHelper.sendSuccess(sender, "Removed <aqua>" + count + "<green> mobs matching faction <yellow>" + type);
        } else {
            String killedTypes = String.valueOf(ChatColor.GREEN);
            for (MythicMob mm4 : ((MythicBukkit)this.getPlugin()).getMobManager().getMobTypes()) {
                if (!exact && !mm4.getInternalName().contains(type) || exact && !mm4.getInternalName().equalsIgnoreCase(type)) continue;
                String[] parts = mm4.getInternalName().split(type);
                if (parts.length == 2) {
                    killedTypes = killedTypes + String.valueOf(ChatColor.RED) + parts[0] + String.valueOf(ChatColor.DARK_RED) + type + String.valueOf(ChatColor.RED) + parts[1] + String.valueOf(ChatColor.GRAY) + ", ";
                }
                if (parts.length == 1) {
                    killedTypes = killedTypes + String.valueOf(ChatColor.RED) + parts[0] + String.valueOf(ChatColor.DARK_RED) + type + String.valueOf(ChatColor.GRAY) + ", ";
                }
                if (parts.length != 0) continue;
                killedTypes = killedTypes + String.valueOf(ChatColor.DARK_RED) + type + String.valueOf(ChatColor.GRAY) + ", ";
            }
            CommandHelper.sendHeader(sender);
            CommandHelper.sendSuccess(sender, "Removed " + count + " mobs of types: ");
            CommandHelper.send(sender, killedTypes);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args != null && args.length > 1 && args[0].startsWith("-")) {
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (args.length == 1) {
            return CollectionUtils.filterMatches(args[0], ((MythicBukkit)this.getPlugin()).getMobManager().getMobNames(), 2);
        }
        return Collections.emptyList();
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.mobs.kill";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "kill";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"k"};
    }
}

