/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.mobs;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.spawning.MythicSpawnState;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;

public class StatsCommand
extends Command<MythicBukkit> {
    public StatsCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        int amount = 0;
        int alive = 0;
        int dead = 0;
        int valid = 0;
        int invalid = 0;
        int n = 0;
        Player bukkitPlayer = (Player)sender;
        World bukkitWorld = bukkitPlayer.getWorld();
        AbstractPlayer player = BukkitAdapter.adapt(bukkitPlayer);
        for (ActiveMob am : ((MythicBukkit)this.getPlugin()).getMobManager().getActiveMobs()) {
            if (!am.getLocation().getWorld().equals(player.getWorld())) continue;
            ++amount;
            if (am.getEntity() == null) {
                ++n;
                continue;
            }
            if (am.getEntity().isDead()) {
                ++dead;
            } else {
                ++alive;
            }
            if (am.getEntity().isValid()) {
                ++valid;
                continue;
            }
            ++invalid;
        }
        MythicSpawnState spawnState = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getSpawningHandler().getSpawnState(player.getLocation().getWorld());
        ConcurrentMap categoryInfo = Maps.newConcurrentMap();
        for (Entity entity : bukkitWorld.getEntities()) {
            SpawnCategory category = entity.getSpawnCategory();
            if (!categoryInfo.containsKey(category)) {
                categoryInfo.put(category, new MobStats(category));
            }
            ((MobStats)categoryInfo.get(category)).add(entity);
        }
        CommandHelper.sendHeader(sender);
        CommandHelper.send(sender, "<gold>Total Active Mobs<gray>: <white>" + amount);
        CommandHelper.send(sender, "<yellow>Alive<gray>: <white>" + alive + " <gray>(Valid: " + valid + "<gray>)");
        if (dead > 0) {
            CommandHelper.send(sender, "<yellow>Dead<gray>: <white>" + dead);
        }
        if (invalid > 0) {
            CommandHelper.send(sender, "<yellow>Invalid<gray>: <white>" + invalid);
        }
        if (n > 0) {
            CommandHelper.send(sender, "<yellow>Null<gray>: <white>" + n);
        }
        CommandHelper.send(sender, "<red> ");
        CommandHelper.send(sender, "<gold>Statistics<gray>: ");
        for (MobStats cat : categoryInfo.values()) {
            CommandHelper.send(sender, "<gray>-> <yellow>" + cat.getCategory().toString() + " <gray>- <white>" + cat.getCount() + " <gray>/ <white>Mythic: " + cat.getMythicCount() + " <gray>/ <white>Persistent: " + cat.getPersistentCount());
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.mobs.stats";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "stats";
    }

    private class MobStats {
        private final SpawnCategory category;
        private int count = 0;
        private int mythicCount = 0;
        private int persistentCount = 0;

        public void add(Entity entity) {
            LivingEntity le;
            ++this.count;
            if (((MythicBukkit)StatsCommand.this.getPlugin()).getMobManager().isMythicMob(entity)) {
                ++this.mythicCount;
            }
            if (entity instanceof LivingEntity && !(le = (LivingEntity)entity).getRemoveWhenFarAway()) {
                ++this.persistentCount;
            }
        }

        public MobStats(SpawnCategory category) {
            this.category = category;
        }

        public SpawnCategory getCategory() {
            return this.category;
        }

        public int getCount() {
            return this.count;
        }

        public int getMythicCount() {
            return this.mythicCount;
        }

        public int getPersistentCount() {
            return this.persistentCount;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setMythicCount(int mythicCount) {
            this.mythicCount = mythicCount;
        }

        public void setPersistentCount(int persistentCount) {
            this.persistentCount = persistentCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MobStats)) {
                return false;
            }
            MobStats other = (MobStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            if (this.getMythicCount() != other.getMythicCount()) {
                return false;
            }
            if (this.getPersistentCount() != other.getPersistentCount()) {
                return false;
            }
            SpawnCategory this$category = this.getCategory();
            SpawnCategory other$category = other.getCategory();
            return !(this$category == null ? other$category != null : !this$category.equals(other$category));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MobStats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            result = result * 59 + this.getMythicCount();
            result = result * 59 + this.getPersistentCount();
            SpawnCategory $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            return result;
        }

        public String toString() {
            return "StatsCommand.MobStats(category=" + String.valueOf(this.getCategory()) + ", count=" + this.getCount() + ", mythicCount=" + this.getMythicCount() + ", persistentCount=" + this.getPersistentCount() + ")";
        }
    }
}

